/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.auth;

import java.util.Objects;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.http.HttpLib;
import org.apache.jena.http.auth.AuthLib;

public class SimpleBearer {
    public static String USER_PREFIX = "user:";

    public static String requestAuthorizationToken(String user) {
        Objects.requireNonNull(user);
        String x = USER_PREFIX + user;
        String x64 = AuthLib.base64enc((String)x);
        return x64;
    }

    public static String requestAuthorizationHeader(String user) {
        Objects.requireNonNull(user);
        String x64 = SimpleBearer.requestAuthorizationToken(user);
        return HttpLib.bearerAuthHeader((String)x64);
    }

    public static String getUserFromAuthHeader(String headerValue) {
        if (!headerValue.startsWith(HttpLib.BEARER_PREFIX)) {
            throw new IllegalArgumentException("Expected a header stirng startsing \"Bearer \"");
        }
        String base64token = headerValue.substring(HttpLib.BEARER_PREFIX.length());
        return SimpleBearer.getUserFromToken64(base64token);
    }

    public static String getUserFromToken64(String b64token) {
        String string = AuthLib.base64dec((String)b64token);
        if (string == null) {
            // empty if block
        }
        return SimpleBearer.getUserFromString(string);
    }

    private static String getUserFromString(String decodedString) {
        if (!decodedString.startsWith(USER_PREFIX)) {
            Log.info(SimpleBearer.class, (String)"Bearer token does not start \"user:\"");
            return null;
        }
        String user = decodedString.substring(USER_PREFIX.length());
        return user;
    }
}

