/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.sys;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.slf4j.Logger;

public class HttpLoggerFilter
implements Filter {
    private static final Logger log = Fuseki.serverLog;
    private static final boolean verbose = true;
    private static final AtomicLong counter = new AtomicLong(0L);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        String id = "{" + counter.incrementAndGet() + "}";
        this.logRequest(id, servletRequest);
        chain.doFilter(servletRequest, servletResponse);
        this.logResponse(id, servletResponse);
    }

    private void logRequest(String id, ServletRequest servletRequest) {
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            String url = ActionLib.wholeRequestURL((HttpServletRequest)request);
            String method = request.getMethod();
            FmtLog.info((Logger)log, (String)"%s %s %s", (Object[])new Object[]{id, method, url});
            Enumeration en = request.getHeaderNames();
            if (en != null) {
                while (en.hasMoreElements()) {
                    String h = (String)en.nextElement();
                    Enumeration vals = request.getHeaders(h);
                    if (!vals.hasMoreElements()) {
                        FmtLog.info((Logger)log, (String)"%s    => %s", (Object[])new Object[]{id, h + ":"});
                        continue;
                    }
                    while (vals.hasMoreElements()) {
                        FmtLog.info((Logger)log, (String)"%s    => %-20s %s", (Object[])new Object[]{id, h + ":", vals.nextElement()});
                    }
                }
            }
        }
        catch (Throwable ex) {
            log.info("Filter (log request): unexpected exception: " + ex.getMessage(), ex);
        }
    }

    private void logResponse(String id, ServletResponse servletResponse) {
        try {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String responseContentType = response.getHeader("Content-Type");
            String responseContentLength = response.getHeader("Content-Length");
            if (responseContentType != null) {
                FmtLog.info((Logger)log, (String)"%s    <= %-20s %s", (Object[])new Object[]{id, "Content-Type:", responseContentType});
            }
            if (responseContentLength != null) {
                FmtLog.info((Logger)log, (String)"%s    <= %-20s %d", (Object[])new Object[]{id, "Content-Length:", responseContentLength});
            }
            for (String headerName : response.getHeaderNames()) {
                if (headerName.equalsIgnoreCase("Content-Type") || headerName.equalsIgnoreCase("Content-Length")) continue;
                String headerValue = response.getHeader(headerName);
                FmtLog.info((Logger)log, (String)"%s    <= %-20s %s", (Object[])new Object[]{id, headerName + ":", headerValue});
            }
            FmtLog.info((Logger)log, (String)"%s %s", (Object[])new Object[]{id, response.getStatus()});
        }
        catch (Throwable ex) {
            log.info("Filter (log response: unexpected exception: " + ex.getMessage(), ex);
        }
    }
}

