/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.configuration;

import java.io.File;
import org.apache.jena.geosparql.geof.topological.RelateFF;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;
import org.apache.jena.geosparql.implementation.function_registration.Egenhofer;
import org.apache.jena.geosparql.implementation.function_registration.GeometryProperty;
import org.apache.jena.geosparql.implementation.function_registration.NonTopological;
import org.apache.jena.geosparql.implementation.function_registration.RCC8;
import org.apache.jena.geosparql.implementation.function_registration.Relate;
import org.apache.jena.geosparql.implementation.function_registration.SimpleFeatures;
import org.apache.jena.geosparql.implementation.function_registration.Spatial;
import org.apache.jena.geosparql.implementation.index.IndexConfiguration;
import org.apache.jena.geosparql.implementation.index.QueryRewriteIndex;
import org.apache.jena.geosparql.implementation.registry.SRSRegistry;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.query.Dataset;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;

public class GeoSPARQLConfig {
    private static Boolean IS_FUNCTIONS_REGISTERED = false;
    private static Boolean IS_QUERY_REWRITE_ENABLED = true;
    public static int DECIMAL_PLACES_PRECISION = 6;
    public static int PRECISION_MODEL_SCALE_FACTOR = 1000000;

    public static final void setupMemoryIndex() {
        GeoSPARQLConfig.setup(IndexConfiguration.IndexOption.MEMORY, true);
    }

    public static final void setupMemoryIndex(Boolean isQueryRewriteEnabled) {
        GeoSPARQLConfig.setup(IndexConfiguration.IndexOption.MEMORY, isQueryRewriteEnabled);
    }

    public static final void setupMemoryIndexSize(Integer geometryLiteralIndex, Integer geometryTransformIndex, Integer queryRewriteIndex) {
        GeoSPARQLConfig.setup(IndexConfiguration.IndexOption.MEMORY, true);
        IndexConfiguration.setIndexMaxSize(geometryLiteralIndex, geometryTransformIndex, queryRewriteIndex);
    }

    public static final void setupMemoryIndexExpiry(Long geometryLiteralIndex, Long geometryTransformIndex, Long queryRewriteIndex) {
        GeoSPARQLConfig.setup(IndexConfiguration.IndexOption.MEMORY, true);
        IndexConfiguration.setIndexExpiry(geometryLiteralIndex, geometryTransformIndex, queryRewriteIndex);
    }

    public static final void setupMemoryIndex(Integer geometryLiteralIndex, Integer geometryTransformIndex, Integer queryRewriteIndex, Long geometryLiteralIndexExpiry, Long geometryTransformIndexExpiry, Long queryRewriteIndexExpiry, Boolean isQueryRewriteEnabled) {
        GeoSPARQLConfig.setup(IndexConfiguration.IndexOption.MEMORY, isQueryRewriteEnabled);
        IndexConfiguration.setIndexMaxSize(geometryLiteralIndex, geometryTransformIndex, queryRewriteIndex);
        IndexConfiguration.setIndexExpiry(geometryLiteralIndexExpiry, geometryTransformIndexExpiry, queryRewriteIndexExpiry);
    }

    public static final void setupNoIndex() {
        GeoSPARQLConfig.setup(IndexConfiguration.IndexOption.NONE, true);
    }

    public static final void setupNoIndex(Boolean isQueryRewriteEnabled) {
        GeoSPARQLConfig.setup(IndexConfiguration.IndexOption.NONE, isQueryRewriteEnabled);
    }

    public static final void setup(IndexConfiguration.IndexOption indexOption) {
        GeoSPARQLConfig.setup(indexOption, true);
    }

    public static final void setup(IndexConfiguration.IndexOption indexOption, Boolean isQueryRewriteEnabled) {
        IS_QUERY_REWRITE_ENABLED = isQueryRewriteEnabled;
        IndexConfiguration.setConfig(indexOption);
        if (!IS_FUNCTIONS_REGISTERED.booleanValue()) {
            SRSRegistry.setupDefaultSRS();
            GeometryDatatype.registerDatatypes();
            PropertyFunctionRegistry propertyRegistry = PropertyFunctionRegistry.get();
            FunctionRegistry functionRegistry = FunctionRegistry.get();
            NonTopological.loadFilterFunctions(functionRegistry);
            functionRegistry.put("http://www.opengis.net/ont/geosparql#relate", RelateFF.class);
            SimpleFeatures.loadPropertyFunctions(propertyRegistry);
            SimpleFeatures.loadFilterFunctions(functionRegistry);
            Egenhofer.loadPropertyFunctions(propertyRegistry);
            Egenhofer.loadFilterFunctions(functionRegistry);
            RCC8.loadPropertyFunctions(propertyRegistry);
            RCC8.loadFilterFunctions(functionRegistry);
            Relate.loadRelateFunction(functionRegistry);
            GeometryProperty.loadPropertyFunctions(propertyRegistry);
            GeometryProperty.loadFilterFunctions(functionRegistry);
            Spatial.loadPropertyFunctions(propertyRegistry);
            Spatial.loadFilterFunctions(functionRegistry);
            IS_FUNCTIONS_REGISTERED = true;
        }
    }

    public static final Boolean isFunctionRegistered() {
        return IS_FUNCTIONS_REGISTERED;
    }

    public static final void reset() {
        IndexConfiguration.resetIndexesAndRegistries();
    }

    public static Boolean isQueryRewriteEnabled() {
        return IS_QUERY_REWRITE_ENABLED;
    }

    public static final void setupQueryRewriteIndex(Dataset dataset, String queryRewriteLabel, int maxSize, long expiryInterval) {
        QueryRewriteIndex.prepare(dataset, queryRewriteLabel, maxSize, expiryInterval);
    }

    public static final void setupSpatialIndex(Dataset dataset) throws SpatialIndexException {
        SpatialIndex.buildSpatialIndex(dataset);
    }

    public static final void setupSpatialIndex(Dataset dataset, File spatialIndexFile) throws SpatialIndexException {
        SpatialIndex.buildSpatialIndex(dataset, spatialIndexFile);
    }

    public static final void setupSpatialIndex(Dataset dataset, String srsURI, File spatialIndexFile) throws SpatialIndexException {
        SpatialIndex.buildSpatialIndex(dataset, srsURI, spatialIndexFile);
    }

    public static final void setCalculationPrecision(int decimalPlaces) {
        DECIMAL_PLACES_PRECISION = decimalPlaces;
    }

    public static final void setPrecisionModelScaleFactor(int scaleFactor) {
        PRECISION_MODEL_SCALE_FACTOR = scaleFactor;
    }
}

