/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jena.geosparql.configuration.SrsException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.geosparql.implementation.vocabulary.SpatialExtension;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;

public class ModeSRS {
    private final HashMap<String, Integer> srsMap = new HashMap();
    private List<Map.Entry<String, Integer>> srsList = new ArrayList<Map.Entry<String, Integer>>();

    public void search(Model model) {
        List geoList;
        NodeIterator nodeIter = model.listObjectsOfProperty(Geo.HAS_SERIALIZATION_PROP);
        boolean isGeometryLiteralsFound = nodeIter.hasNext();
        if (!isGeometryLiteralsFound) {
            NodeIterator wktNodeIter = model.listObjectsOfProperty(Geo.AS_WKT_PROP);
            NodeIterator gmlNodeIter = model.listObjectsOfProperty(Geo.AS_GML_PROP);
            nodeIter = wktNodeIter.andThen((Iterator)gmlNodeIter);
        }
        while (nodeIter.hasNext()) {
            Integer count;
            RDFNode node = (RDFNode)nodeIter.next();
            if (!node.isLiteral()) continue;
            GeometryWrapper geometryWrapper = GeometryWrapper.extract(node.asLiteral());
            String srsURI = geometryWrapper.getSrsURI();
            if (this.srsMap.containsKey(srsURI)) {
                Integer n = count = this.srsMap.get(srsURI);
                Integer n2 = count = Integer.valueOf(count + 1);
            } else {
                count = 1;
            }
            this.srsMap.put(srsURI, count);
        }
        if (!isGeometryLiteralsFound && !(geoList = model.listObjectsOfProperty(SpatialExtension.GEO_LAT_PROP).toList()).isEmpty()) {
            this.srsMap.put("http://www.opengis.net/def/crs/EPSG/0/4326", geoList.size());
        }
        this.srsList = this.srsMap.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toList());
    }

    public List<Map.Entry<String, Integer>> getSrsList() {
        return this.srsList;
    }

    public HashMap<String, Integer> getSrsMap() {
        return this.srsMap;
    }

    public String getModeURI() throws SrsException {
        if (!this.srsList.isEmpty()) {
            return this.srsList.get(0).getKey();
        }
        throw new SrsException("No SRS found. Check 'http://www.opengis.net/ont/geosparql#hasSerialization' or 'http://www.w3.org/2003/01/geo/wgs84_pos#lat'/'http://www.w3.org/2003/01/geo/wgs84_pos#lon' predicates are present in the source data. Hint: Inferencing with GeoSPARQL schema may be required.");
    }

    public String toString() {
        return "ModeSRS{srsMap=" + this.srsMap + ", srsList=" + this.srsList + "}";
    }
}

