/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.geo.topological;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.geosparql.geo.topological.SpatialObjectGeometryLiteral;
import org.apache.jena.geosparql.geof.topological.GenericFilterFunction;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.index.QueryRewriteIndex;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.geosparql.implementation.vocabulary.SpatialExtension;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PFuncSimple;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class GenericPropertyFunction
extends PFuncSimple {
    private final GenericFilterFunction filterFunction;

    public GenericPropertyFunction(GenericFilterFunction filterFunction) {
        this.filterFunction = filterFunction;
    }

    public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        if (object.isLiteral()) {
            return QueryIterNullIterator.create((ExecutionContext)execCxt);
        }
        if (subject.isConcrete() && object.isConcrete()) {
            return this.bothBound(binding, subject, predicate, object, execCxt);
        }
        if (subject.isVariable() && object.isVariable()) {
            return this.bothUnbound(binding, subject, predicate, object, execCxt);
        }
        return this.oneBound(binding, subject, predicate, object, execCxt);
    }

    private QueryIterator bothBound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        QueryRewriteIndex queryRewriteIndex;
        Graph graph = execCxt.getActiveGraph();
        Boolean isPositiveResult = this.queryRewrite(graph, subject, predicate, object, queryRewriteIndex = QueryRewriteIndex.retrieve(execCxt));
        if (isPositiveResult.booleanValue()) {
            return QueryIterSingleton.create((Binding)binding, (ExecutionContext)execCxt);
        }
        return QueryIterNullIterator.create((ExecutionContext)execCxt);
    }

    private QueryIterator bothUnbound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        ExtendedIterator subjectTriples;
        QueryIterConcat queryIterConcat = new QueryIterConcat(execCxt);
        Var subjectVar = Var.alloc((String)subject.getName());
        Graph graph = execCxt.getActiveGraph();
        if (graph.contains(null, RDF.type.asNode(), Geo.SPATIAL_OBJECT_NODE)) {
            subjectTriples = graph.find(null, RDF.type.asNode(), Geo.SPATIAL_OBJECT_NODE);
        } else if (graph.contains(null, RDF.type.asNode(), Geo.FEATURE_NODE) || graph.contains(null, RDF.type.asNode(), Geo.GEOMETRY_NODE)) {
            ExtendedIterator featureTriples = graph.find(null, RDF.type.asNode(), Geo.FEATURE_NODE);
            ExtendedIterator geometryTriples = graph.find(null, RDF.type.asNode(), Geo.GEOMETRY_NODE);
            subjectTriples = featureTriples.andThen((Iterator)geometryTriples);
        } else {
            subjectTriples = graph.find(null, SpatialExtension.GEO_LAT_NODE, null);
        }
        while (subjectTriples.hasNext()) {
            Triple subjectTriple = (Triple)subjectTriples.next();
            Node boundSubject = subjectTriple.getSubject();
            Binding subjectBind = BindingFactory.binding((Binding)binding, (Var)subjectVar, (Node)boundSubject);
            QueryIterator queryIter = this.oneBound(subjectBind, boundSubject, predicate, object, execCxt);
            queryIterConcat.add(queryIter);
        }
        return queryIterConcat;
    }

    private QueryIterator oneBound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        Boolean isSubjectBound;
        Node unboundNode;
        Node boundNode;
        Graph graph = execCxt.getActiveGraph();
        if (subject.isConcrete()) {
            boundNode = subject;
            unboundNode = object;
            isSubjectBound = true;
        } else {
            boundNode = object;
            unboundNode = subject;
            isSubjectBound = false;
        }
        if (!(graph.contains(boundNode, RDF.type.asNode(), Geo.SPATIAL_OBJECT_NODE) || graph.contains(boundNode, RDF.type.asNode(), Geo.FEATURE_NODE) || graph.contains(boundNode, RDF.type.asNode(), Geo.GEOMETRY_NODE) || graph.contains(boundNode, SpatialExtension.GEO_LAT_NODE, null))) {
            return QueryIterNullIterator.create((ExecutionContext)execCxt);
        }
        boolean isSpatialIndex = SpatialIndex.isDefined(execCxt);
        QueryIterConcat queryIterConcat = !isSpatialIndex || this.filterFunction.isDisjoint() || this.filterFunction.isDisconnected() ? this.findAll(graph, boundNode, unboundNode, binding, isSubjectBound, predicate, execCxt) : this.findIndex(graph, boundNode, unboundNode, binding, isSubjectBound, predicate, execCxt);
        return queryIterConcat;
    }

    private QueryIterConcat findAll(Graph graph, Node boundNode, Node unboundNode, Binding binding, boolean isSubjectBound, Node predicate, ExecutionContext execCxt) {
        ExtendedIterator spatialTriples;
        Var unboundVar = Var.alloc((String)unboundNode.getName());
        QueryIterConcat queryIterConcat = new QueryIterConcat(execCxt);
        if (graph.contains(null, RDF.type.asNode(), Geo.SPATIAL_OBJECT_NODE)) {
            spatialTriples = graph.find(null, RDF.type.asNode(), Geo.SPATIAL_OBJECT_NODE);
        } else if (graph.contains(null, RDF.type.asNode(), Geo.FEATURE_NODE) || graph.contains(null, RDF.type.asNode(), Geo.GEOMETRY_NODE)) {
            ExtendedIterator featureTriples = graph.find(null, RDF.type.asNode(), Geo.FEATURE_NODE);
            ExtendedIterator geometryTriples = graph.find(null, RDF.type.asNode(), Geo.GEOMETRY_NODE);
            spatialTriples = featureTriples.andThen((Iterator)geometryTriples);
        } else {
            spatialTriples = graph.find(null, SpatialExtension.GEO_LAT_NODE, null);
        }
        while (spatialTriples.hasNext()) {
            Triple spatialTriple = (Triple)spatialTriples.next();
            Node spatialNode = spatialTriple.getSubject();
            Binding newBind = BindingFactory.binding((Binding)binding, (Var)unboundVar, (Node)spatialNode);
            QueryIterator queryIter = isSubjectBound ? this.bothBound(newBind, boundNode, predicate, spatialNode, execCxt) : this.bothBound(newBind, spatialNode, predicate, boundNode, execCxt);
            queryIterConcat.add(queryIter);
        }
        return queryIterConcat;
    }

    private QueryIterConcat findIndex(Graph graph, Node boundNode, Node unboundNode, Binding binding, boolean isSubjectBound, Node predicate, ExecutionContext execCxt) throws ExprEvalException {
        try {
            Var unboundVar = Var.alloc((String)unboundNode.getName());
            QueryIterConcat queryIterConcat = new QueryIterConcat(execCxt);
            List<Node> assertedNodes = this.findAsserted(graph, boundNode, isSubjectBound, predicate);
            for (Node node : assertedNodes) {
                Binding newBind = BindingFactory.binding((Binding)binding, (Var)unboundVar, (Node)node);
                QueryIterSingleton queryIter = QueryIterSingleton.create((Binding)newBind, (ExecutionContext)execCxt);
                queryIterConcat.add((QueryIterator)queryIter);
            }
            SpatialObjectGeometryLiteral boundGeometryLiteral = SpatialObjectGeometryLiteral.retrieve(graph, boundNode);
            if (!boundGeometryLiteral.isValid()) {
                return queryIterConcat;
            }
            Node geometryLiteral = boundGeometryLiteral.getGeometryLiteral();
            SpatialIndex spatialIndex = SpatialIndex.retrieve(execCxt);
            GeometryWrapper geom = GeometryWrapper.extract(geometryLiteral);
            GeometryWrapper transformedGeom = geom.transform(spatialIndex.getSrsInfo());
            Envelope searchEnvelope = transformedGeom.getEnvelope();
            HashSet<Resource> features = spatialIndex.query(searchEnvelope);
            for (Resource feature : features) {
                Node featureNode = feature.asNode();
                if (!assertedNodes.contains(featureNode)) {
                    Binding newBind = BindingFactory.binding((Binding)binding, (Var)unboundVar, (Node)featureNode);
                    QueryIterator queryIter = isSubjectBound ? this.bothBound(newBind, boundNode, predicate, featureNode, execCxt) : this.bothBound(newBind, featureNode, predicate, boundNode, execCxt);
                    queryIterConcat.add(queryIter);
                }
                ExtendedIterator featureGeometryTriples = graph.find(feature.asNode(), Geo.HAS_GEOMETRY_NODE, null);
                while (featureGeometryTriples.hasNext()) {
                    Triple unboundTriple = (Triple)featureGeometryTriples.next();
                    Node geomNode = unboundTriple.getObject();
                    if (assertedNodes.contains(geomNode)) continue;
                    Binding newBind = BindingFactory.binding((Binding)binding, (Var)unboundVar, (Node)geomNode);
                    QueryIterator queryIter = isSubjectBound ? this.bothBound(newBind, boundNode, predicate, geomNode, execCxt) : this.bothBound(newBind, geomNode, predicate, boundNode, execCxt);
                    queryIterConcat.add(queryIter);
                }
            }
            return queryIterConcat;
        }
        catch (SpatialIndexException | MismatchedDimensionException | TransformException | FactoryException ex) {
            throw new ExprEvalException(ex.getMessage() + ": " + FmtUtils.stringForNode((Node)boundNode) + ", " + FmtUtils.stringForNode((Node)unboundNode) + ", " + FmtUtils.stringForNode((Node)predicate), ex);
        }
    }

    private List<Node> findAsserted(Graph graph, Node boundNode, boolean isSubjectBound, Node predicate) {
        ArrayList<Node> assertedNodes = new ArrayList<Node>();
        if (isSubjectBound) {
            ExtendedIterator assertedTriples = graph.find(boundNode, predicate, null);
            while (assertedTriples.hasNext()) {
                Node assertedNode = ((Triple)assertedTriples.next()).getObject();
                assertedNodes.add(assertedNode);
            }
        } else {
            ExtendedIterator assertedTriples = graph.find(null, predicate, boundNode);
            while (assertedTriples.hasNext()) {
                Node assertedNode = ((Triple)assertedTriples.next()).getSubject();
                assertedNodes.add(assertedNode);
            }
        }
        return assertedNodes;
    }

    protected final Boolean queryRewrite(Graph graph, Node subject, Node predicate, Node object, QueryRewriteIndex queryRewriteIndex) {
        if (graph.contains(subject, predicate, object)) {
            return true;
        }
        if (!queryRewriteIndex.isIndexActive()) {
            return false;
        }
        SpatialObjectGeometryLiteral subjectSpatialLiteral = SpatialObjectGeometryLiteral.retrieve(graph, subject);
        if (!subjectSpatialLiteral.isValid()) {
            return false;
        }
        SpatialObjectGeometryLiteral objectSpatialLiteral = SpatialObjectGeometryLiteral.retrieve(graph, object);
        if (!objectSpatialLiteral.isValid()) {
            return false;
        }
        Property predicateProp = ResourceFactory.createProperty((String)predicate.getURI());
        Boolean isPositive = queryRewriteIndex.test(subjectSpatialLiteral.getGeometryLiteral(), predicateProp, objectSpatialLiteral.getGeometryLiteral(), this);
        return isPositive;
    }

    public Boolean testFilterFunction(Node subjectGeometryLiteral, Node objectGeometryLiteral) {
        return this.filterFunction.exec(subjectGeometryLiteral, objectGeometryLiteral);
    }
}

