/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.geo.topological;

import java.util.Objects;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.geosparql.implementation.vocabulary.SpatialExtension;
import org.apache.jena.geosparql.spatial.ConvertLatLon;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public class SpatialObjectGeometryLiteral {
    private final Node spatialObject;
    private final Node geometryLiteral;
    private final boolean valid;

    public SpatialObjectGeometryLiteral(Node spatialObject, Node geometryLiteral) {
        this.spatialObject = spatialObject;
        this.geometryLiteral = geometryLiteral;
        this.valid = geometryLiteral != null && spatialObject != null;
    }

    public Node getSpatialObject() {
        return this.spatialObject;
    }

    public Node getGeometryLiteral() {
        return this.geometryLiteral;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.spatialObject);
        hash = 47 * hash + Objects.hashCode(this.geometryLiteral);
        hash = 47 * hash + (this.valid ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpatialObjectGeometryLiteral other = (SpatialObjectGeometryLiteral)obj;
        if (this.valid != other.valid) {
            return false;
        }
        if (!Objects.equals(this.spatialObject, other.spatialObject)) {
            return false;
        }
        return Objects.equals(this.geometryLiteral, other.geometryLiteral);
    }

    public String toString() {
        return "SpatialObjectGeometryLiteral{spatialObject=" + this.spatialObject + ", geometryLiteral=" + this.geometryLiteral + ", valid=" + this.valid + "}";
    }

    protected static final SpatialObjectGeometryLiteral retrieve(Graph graph, Node targetSpatialObject) {
        Node geometry = null;
        if (graph.contains(targetSpatialObject, RDF.type.asNode(), Geo.FEATURE_NODE)) {
            ExtendedIterator geomIter = graph.find(targetSpatialObject, Geo.HAS_DEFAULT_GEOMETRY_NODE, null);
            geometry = SpatialObjectGeometryLiteral.extractObject((ExtendedIterator<Triple>)geomIter);
        } else if (graph.contains(targetSpatialObject, RDF.type.asNode(), Geo.GEOMETRY_NODE)) {
            geometry = targetSpatialObject;
        }
        if (geometry != null) {
            ExtendedIterator iter = graph.find(geometry, Geo.HAS_SERIALIZATION_NODE, null);
            Node literalNode = SpatialObjectGeometryLiteral.extractObject((ExtendedIterator<Triple>)iter);
            if (literalNode == null) {
                iter = graph.find(geometry, Geo.AS_WKT_NODE, null);
                literalNode = SpatialObjectGeometryLiteral.extractObject((ExtendedIterator<Triple>)iter);
            }
            if (literalNode == null) {
                iter = graph.find(geometry, Geo.AS_GML_NODE, null);
                literalNode = SpatialObjectGeometryLiteral.extractObject((ExtendedIterator<Triple>)iter);
            }
            if (literalNode != null) {
                return new SpatialObjectGeometryLiteral(targetSpatialObject, literalNode);
            }
        } else if (graph.contains(targetSpatialObject, SpatialExtension.GEO_LAT_NODE, null) && graph.contains(targetSpatialObject, SpatialExtension.GEO_LON_NODE, null)) {
            ExtendedIterator latIter = graph.find(targetSpatialObject, SpatialExtension.GEO_LAT_NODE, null);
            Node lat = ((Triple)latIter.next()).getObject();
            ExtendedIterator lonIter = graph.find(targetSpatialObject, SpatialExtension.GEO_LON_NODE, null);
            Node lon = ((Triple)lonIter.next()).getObject();
            if (latIter.hasNext() || lonIter.hasNext()) {
                latIter.close();
                lonIter.close();
                throw new DatatypeFormatException(targetSpatialObject.getURI() + " has more than one geo:lat or geo:lon property.");
            }
            Node latLonGeometryLiteral = ConvertLatLon.toNode(lat, lon);
            return new SpatialObjectGeometryLiteral(targetSpatialObject, latLonGeometryLiteral);
        }
        return new SpatialObjectGeometryLiteral(null, null);
    }

    private static Node extractObject(ExtendedIterator<Triple> iter) {
        if (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            return triple.getObject();
        }
        return null;
    }
}

