/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.geof.nontopological.filter_functions;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase3;
import org.apache.jena.sparql.util.FmtUtils;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class BufferFF
extends FunctionBase3 {
    public NodeValue exec(NodeValue v1, NodeValue v2, NodeValue v3) {
        try {
            GeometryWrapper geometry = GeometryWrapper.extract(v1);
            if (!v2.isDouble()) {
                throw new ExprEvalException("Not a Double: " + FmtUtils.stringForNode((Node)v2.asNode()));
            }
            Node node2 = v2.asNode();
            double radius = Double.parseDouble(node2.getLiteralLexicalForm());
            if (!v3.isIRI()) {
                throw new ExprEvalException("Not a IRI: " + FmtUtils.stringForNode((Node)v3.asNode()));
            }
            String unitsURI = v3.getNode().getURI();
            GeometryWrapper buffer = geometry.buffer(radius, unitsURI);
            return buffer.asNodeValue();
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException(ex.getMessage(), (Throwable)ex);
        }
        catch (MismatchedDimensionException | TransformException | FactoryException ex) {
            throw new ExprEvalException(ex.getMessage() + ": " + FmtUtils.stringForNode((Node)v1.asNode()) + ", " + FmtUtils.stringForNode((Node)v2.asNode()) + ", " + FmtUtils.stringForNode((Node)v3.asNode()), ex);
        }
    }
}

