/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation;

import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.implementation.registry.SRSRegistry;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class GeometryReverse {
    public static final Geometry check(Geometry geometry, String srsURI) {
        Boolean isAxisXY = SRSRegistry.getAxisXY(srsURI);
        return GeometryReverse.check(geometry, isAxisXY);
    }

    public static final Geometry check(Geometry geometry, SRSInfo srsInfo) {
        return GeometryReverse.check(geometry, srsInfo.isAxisXY());
    }

    public static final Geometry check(Geometry geometry, Boolean isAxisXY) {
        Geometry finalGeometry = isAxisXY != false ? geometry : GeometryReverse.reverseGeometry(geometry);
        return finalGeometry;
    }

    public static Geometry reverseGeometry(Geometry geometry) {
        Geometry finalGeometry;
        String type;
        if (geometry.isEmpty()) {
            return geometry.copy();
        }
        GeometryFactory factory = geometry.getFactory();
        switch (type = geometry.getGeometryType()) {
            case "LineString": {
                Coordinate[] coordinates = GeometryReverse.getReversedCoordinates(geometry);
                finalGeometry = factory.createLineString(coordinates);
                break;
            }
            case "LinearRing": {
                Coordinate[] coordinates = GeometryReverse.getReversedCoordinates(geometry);
                finalGeometry = factory.createLinearRing(coordinates);
                break;
            }
            case "MultiPoint": {
                Coordinate[] coordinates = GeometryReverse.getReversedCoordinates(geometry);
                finalGeometry = factory.createMultiPointFromCoords(coordinates);
                break;
            }
            case "Polygon": {
                finalGeometry = GeometryReverse.reversePolygon(geometry, factory);
                break;
            }
            case "Point": {
                Coordinate[] coordinates = GeometryReverse.getReversedCoordinates(geometry);
                finalGeometry = factory.createPoint(coordinates[0]);
                break;
            }
            case "MultiPolygon": {
                Polygon[] polygons = GeometryReverse.unpackPolygons((GeometryCollection)geometry);
                finalGeometry = factory.createMultiPolygon(polygons);
                break;
            }
            case "MultiLineString": {
                LineString[] lineString = GeometryReverse.unpackLineStrings((GeometryCollection)geometry);
                finalGeometry = factory.createMultiLineString(lineString);
                break;
            }
            case "GeometryCollection": {
                Geometry[] geometries = GeometryReverse.unpackGeometryCollection((GeometryCollection)geometry);
                finalGeometry = factory.createGeometryCollection(geometries);
                break;
            }
            default: {
                finalGeometry = geometry;
            }
        }
        return finalGeometry;
    }

    private static Coordinate[] getReversedCoordinates(Geometry geometry) {
        Coordinate[] original = geometry.getCoordinates();
        Coordinate[] reversed = new Coordinate[original.length];
        for (int i = 0; i < original.length; ++i) {
            reversed[i] = new Coordinate(original[i].y, original[i].x);
        }
        return reversed;
    }

    private static Polygon reversePolygon(Geometry geometry, GeometryFactory factory) {
        Polygon finalGeometry;
        Polygon polygon = (Polygon)geometry;
        if (polygon.getNumInteriorRing() == 0) {
            Coordinate[] coordinates = GeometryReverse.getReversedCoordinates(geometry);
            finalGeometry = factory.createPolygon(coordinates);
        } else {
            LinearRing exteriorRing = polygon.getExteriorRing();
            Coordinate[] reversedExteriorCoordinates = GeometryReverse.getReversedCoordinates((Geometry)exteriorRing);
            LinearRing reversedExteriorRing = factory.createLinearRing(reversedExteriorCoordinates);
            LinearRing[] reversedInteriorRings = new LinearRing[polygon.getNumInteriorRing()];
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                LinearRing reversedInteriorRing;
                LinearRing interiorRing = polygon.getInteriorRingN(i);
                Coordinate[] reversedInteriorCoordinates = GeometryReverse.getReversedCoordinates((Geometry)interiorRing);
                reversedInteriorRings[i] = reversedInteriorRing = factory.createLinearRing(reversedInteriorCoordinates);
            }
            finalGeometry = factory.createPolygon(reversedExteriorRing, reversedInteriorRings);
        }
        return finalGeometry;
    }

    private static Polygon[] unpackPolygons(GeometryCollection geoCollection) {
        GeometryFactory factory = geoCollection.getFactory();
        int count = geoCollection.getNumGeometries();
        Polygon[] polygons = new Polygon[count];
        for (int i = 0; i < count; ++i) {
            Polygon polygon;
            Geometry geometry = geoCollection.getGeometryN(i);
            polygons[i] = polygon = GeometryReverse.reversePolygon(geometry, factory);
        }
        return polygons;
    }

    private static LineString[] unpackLineStrings(GeometryCollection geoCollection) {
        GeometryFactory factory = geoCollection.getFactory();
        int count = geoCollection.getNumGeometries();
        LineString[] lineStrings = new LineString[count];
        for (int i = 0; i < count; ++i) {
            LineString lineString;
            Geometry geometry = geoCollection.getGeometryN(i);
            Coordinate[] coordinates = GeometryReverse.getReversedCoordinates(geometry);
            lineStrings[i] = lineString = factory.createLineString(coordinates);
        }
        return lineStrings;
    }

    private static Geometry[] unpackGeometryCollection(GeometryCollection geoCollection) {
        int count = geoCollection.getNumGeometries();
        Geometry[] geometries = new Geometry[count];
        for (int i = 0; i < count; ++i) {
            Geometry geometry = geoCollection.getGeometryN(i);
            geometries[i] = GeometryReverse.reverseGeometry(geometry);
        }
        return geometries;
    }
}

