/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation;

import java.util.List;
import org.apache.jena.geosparql.implementation.DimensionInfo;
import org.apache.jena.geosparql.implementation.GeometryReverse;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.jts.CustomGeometryFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryWrapperFactory {
    private static final GeometryFactory GEOMETRY_FACTORY = CustomGeometryFactory.theInstance();

    public static final GeometryWrapper createPoint(Coordinate coordinate, String srsURI, String geometryDatatypeURI) {
        Point geometry = GEOMETRY_FACTORY.createPoint(coordinate);
        return GeometryWrapperFactory.createGeometry((Geometry)geometry, srsURI, geometryDatatypeURI);
    }

    public static final GeometryWrapper createLineString(List<Coordinate> coordinates, String srsURI, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createLineString(coordinates.toArray(new Coordinate[coordinates.size()]), srsURI, geometryDatatypeURI);
    }

    public static final GeometryWrapper createLineString(Coordinate[] coordinates, String srsURI, String geometryDatatypeURI) {
        LineString geometry = GEOMETRY_FACTORY.createLineString(coordinates);
        return GeometryWrapperFactory.createGeometry((Geometry)geometry, srsURI, geometryDatatypeURI);
    }

    public static final GeometryWrapper createLineString(LineString lineString, String srsURI, String geometryDatatypeURI) {
        LineString geometry = lineString;
        return GeometryWrapperFactory.createGeometry((Geometry)geometry, srsURI, geometryDatatypeURI);
    }

    public static final GeometryWrapper createPolygon(List<Coordinate> coordinates, String srsURI, String geometryDatatypeURI) {
        Polygon geometry = GEOMETRY_FACTORY.createPolygon(coordinates.toArray(new Coordinate[coordinates.size()]));
        return GeometryWrapperFactory.createGeometry((Geometry)geometry, srsURI, geometryDatatypeURI);
    }

    public static final GeometryWrapper createPolygon(LinearRing shell, LinearRing[] holes, String srsURI, String geometryDatatypeURI) {
        Polygon geometry = GEOMETRY_FACTORY.createPolygon(shell, holes);
        return GeometryWrapperFactory.createGeometry((Geometry)geometry, srsURI, geometryDatatypeURI);
    }

    public static final GeometryWrapper createPolygon(LinearRing shell, String srsURI, String geometryDatatypeURI) {
        Polygon geometry = GEOMETRY_FACTORY.createPolygon(shell);
        return GeometryWrapperFactory.createGeometry((Geometry)geometry, srsURI, geometryDatatypeURI);
    }

    public static final GeometryWrapper createPolygon(Envelope envelope, String srsURI, String geometryDatatypeURI) {
        LinearRing linearRing = GEOMETRY_FACTORY.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMinY())});
        return GeometryWrapperFactory.createPolygon(linearRing, srsURI, geometryDatatypeURI);
    }

    public static final GeometryWrapper createMultiPoint(List<Coordinate> coordinates, String srsURI, String geometryDatatypeURI) {
        MultiPoint geometry = GEOMETRY_FACTORY.createMultiPointFromCoords(coordinates.toArray(new Coordinate[coordinates.size()]));
        return GeometryWrapperFactory.createGeometry((Geometry)geometry, srsURI, geometryDatatypeURI);
    }

    public static final GeometryWrapper createMultiLineString(List<LineString> lineStrings, String srsURI, String geometryDatatypeURI) {
        MultiLineString geometry = GEOMETRY_FACTORY.createMultiLineString(lineStrings.toArray(new LineString[lineStrings.size()]));
        return GeometryWrapperFactory.createGeometry((Geometry)geometry, srsURI, geometryDatatypeURI);
    }

    public static final GeometryWrapper createMultiPolygon(List<Polygon> polygons, String srsURI, String geometryDatatypeURI) {
        MultiPolygon geometry = GEOMETRY_FACTORY.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
        return GeometryWrapperFactory.createGeometry((Geometry)geometry, srsURI, geometryDatatypeURI);
    }

    public static final GeometryWrapper createGeometryCollection(List<Geometry> geometries, String srsURI, String geometryDatatypeURI) {
        GeometryCollection geometry = GEOMETRY_FACTORY.createGeometryCollection(geometries.toArray(new Geometry[geometries.size()]));
        return GeometryWrapperFactory.createGeometry((Geometry)geometry, srsURI, geometryDatatypeURI);
    }

    public static final GeometryWrapper createGeometry(Geometry geometry, String srsURI, String geometryDatatypeURI) {
        Geometry xyGeometry = geometry;
        Geometry parsingGeometry = GeometryReverse.check(xyGeometry, srsURI);
        DimensionInfo dimsInfo = DimensionInfo.find(geometry.getCoordinate(), xyGeometry);
        return new GeometryWrapper(parsingGeometry, xyGeometry, srsURI, geometryDatatypeURI, dimsInfo);
    }

    public static final GeometryWrapper createPoint(Coordinate coordinate, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createPoint(coordinate, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", geometryDatatypeURI);
    }

    public static final GeometryWrapper createLineString(Coordinate[] coordinates, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createLineString(coordinates, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", geometryDatatypeURI);
    }

    public static final GeometryWrapper createLineString(List<Coordinate> coordinates, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createLineString(coordinates, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", geometryDatatypeURI);
    }

    public static final GeometryWrapper createLineString(LineString lineString, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createLineString(lineString, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", geometryDatatypeURI);
    }

    public static final GeometryWrapper createPolygon(List<Coordinate> coordinates, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createPolygon(coordinates, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", geometryDatatypeURI);
    }

    public static final GeometryWrapper createPolygon(LinearRing shell, LinearRing[] holes, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createPolygon(shell, holes, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", geometryDatatypeURI);
    }

    public static final GeometryWrapper createPolygon(LinearRing shell, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createPolygon(shell, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", geometryDatatypeURI);
    }

    public static final GeometryWrapper createPolygon(Envelope envelope, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createPolygon(envelope, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", geometryDatatypeURI);
    }

    public static final GeometryWrapper createMultiPoint(List<Coordinate> coordinates, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createMultiPoint(coordinates, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", geometryDatatypeURI);
    }

    public static final GeometryWrapper createMultiLineString(List<LineString> lineStrings, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createMultiLineString(lineStrings, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", geometryDatatypeURI);
    }

    public static final GeometryWrapper createMultiPolygon(List<Polygon> polygons, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createMultiPolygon(polygons, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", geometryDatatypeURI);
    }

    public static final GeometryWrapper createGeometry(Geometry geometry, String geometryDatatypeURI) {
        return GeometryWrapperFactory.createGeometry(geometry, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", geometryDatatypeURI);
    }
}

