/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.datatype;

import java.io.IOException;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.DimensionInfo;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;
import org.apache.jena.geosparql.implementation.parsers.gml.GMLReader;
import org.apache.jena.geosparql.implementation.parsers.gml.GMLWriter;
import org.jdom2.JDOMException;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMLDatatype
extends GeometryDatatype {
    private static final Logger LOGGER = LoggerFactory.getLogger(GMLDatatype.class);
    public static final String URI = "http://www.opengis.net/ont/geosparql#gmlLiteral";
    public static final GMLDatatype INSTANCE = new GMLDatatype();
    public static final String GML_PREFIX = "gml";

    public GMLDatatype() {
        super(URI);
    }

    public String unparse(Object geometry) {
        if (geometry instanceof GeometryWrapper) {
            GeometryWrapper geometryWrapper = (GeometryWrapper)geometry;
            return GMLWriter.write(geometryWrapper);
        }
        throw new DatatypeFormatException("Object to unparse GMLDatatype is not a GeometryWrapper: " + geometry);
    }

    @Override
    public GeometryWrapper read(String geometryLiteral) {
        try {
            GMLReader gmlReader = GMLReader.extract(geometryLiteral);
            Geometry geometry = gmlReader.getGeometry();
            String srsURI = gmlReader.getSrsURI();
            DimensionInfo dimensionInfo = gmlReader.getDimensionInfo();
            return new GeometryWrapper(geometry, srsURI, URI, dimensionInfo, geometryLiteral);
        }
        catch (IOException | JDOMException ex) {
            throw new DatatypeFormatException("Illegal GML literal:" + geometryLiteral + ". " + ex.getMessage());
        }
    }

    public String toString() {
        return "GMLDatatype{http://www.opengis.net/ont/geosparql#gmlLiteral}";
    }
}

