/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.index;

import io.github.galbiston.expiring_map.ExpiringMap;
import org.apache.jena.geosparql.implementation.DimensionInfo;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.jts.GeometryTransformation;
import org.apache.jena.geosparql.implementation.registry.MathTransformRegistry;
import org.apache.jena.geosparql.implementation.registry.SRSRegistry;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GeometryTransformIndex {
    private static boolean INDEX_ACTIVE = false;
    private static final String GEOMETRY_TRANSFORM_LABEL = "Geometry Transform";
    private static ExpiringMap<String, GeometryWrapper> GEOMETRY_TRANSFORM_INDEX = new ExpiringMap("Geometry Transform", -1, 5000L);

    public static final GeometryWrapper transform(GeometryWrapper sourceGeometryWrapper, String srsURI, Boolean storeSRSTransform) throws TransformException, FactoryException {
        String key = sourceGeometryWrapper.getLexicalForm() + "@" + srsURI;
        if (INDEX_ACTIVE && storeSRSTransform.booleanValue()) {
            try {
                GeometryWrapper transformedGeometryWrapper;
                if (GEOMETRY_TRANSFORM_INDEX.containsKey((Object)key)) {
                    transformedGeometryWrapper = (GeometryWrapper)GEOMETRY_TRANSFORM_INDEX.get((Object)key);
                } else {
                    transformedGeometryWrapper = GeometryTransformIndex.transform(sourceGeometryWrapper, srsURI);
                    GEOMETRY_TRANSFORM_INDEX.put((Object)key, (Object)transformedGeometryWrapper);
                }
                return transformedGeometryWrapper;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return GeometryTransformIndex.transform(sourceGeometryWrapper, srsURI);
    }

    private static GeometryWrapper transform(GeometryWrapper sourceGeometryWrapper, String srsURI) throws MismatchedDimensionException, FactoryException, TransformException {
        CoordinateReferenceSystem sourceCRS = sourceGeometryWrapper.getCRS();
        CoordinateReferenceSystem targetCRS = SRSRegistry.getCRS(srsURI);
        MathTransform transform = MathTransformRegistry.getMathTransform(sourceCRS, targetCRS);
        Geometry parsingGeometry = sourceGeometryWrapper.getParsingGeometry();
        Geometry transformedGeometry = GeometryTransformation.transform(parsingGeometry, transform);
        String geometryDatatypeURI = sourceGeometryWrapper.getGeometryDatatypeURI();
        DimensionInfo dimensionInfo = sourceGeometryWrapper.getDimensionInfo();
        return new GeometryWrapper(transformedGeometry, srsURI, geometryDatatypeURI, dimensionInfo);
    }

    public static final void clear() {
        GEOMETRY_TRANSFORM_INDEX.clear();
    }

    public static final void setMaxSize(int maxSize) {
        GEOMETRY_TRANSFORM_INDEX.setMaxSize((long)maxSize);
    }

    public static final void setExpiry(long expiryInterval) {
        GEOMETRY_TRANSFORM_INDEX.setExpiryInterval(expiryInterval);
    }

    public static final long getGeometryTransformIndexSize() {
        return GEOMETRY_TRANSFORM_INDEX.mappingCount();
    }

    public static boolean isIndexActive() {
        return INDEX_ACTIVE;
    }

    public static void setIndexActive(boolean indexActive) {
        INDEX_ACTIVE = indexActive;
        if (INDEX_ACTIVE) {
            GEOMETRY_TRANSFORM_INDEX.startExpiry();
        } else {
            GEOMETRY_TRANSFORM_INDEX.stopExpiry();
        }
    }

    public static void reset(int maxSize, long expiryInterval) {
        GEOMETRY_TRANSFORM_INDEX = new ExpiringMap(GEOMETRY_TRANSFORM_LABEL, maxSize, expiryInterval);
    }
}

