/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.index;

import io.github.galbiston.expiring_map.ExpiringMap;
import java.util.Map;
import org.apache.jena.geosparql.configuration.GeoSPARQLConfig;
import org.apache.jena.geosparql.geo.topological.GenericPropertyFunction;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class QueryRewriteIndex {
    private boolean indexActive;
    private final String queryRewriteLabel;
    private ExpiringMap<String, Boolean> index;
    private static String LABEL_DEFAULT = "Query Rewrite";
    private static int MAP_SIZE_DEFAULT = -1;
    private static long MAP_EXPIRY_INTERVAL_DEFAULT = 5000L;
    private static final String KEY_SEPARATOR = "@";
    public static final Symbol QUERY_REWRITE_INDEX_SYMBOL = Symbol.create((String)"http://jena.apache.org/spatial#query-index");

    public QueryRewriteIndex() {
        this.queryRewriteLabel = LABEL_DEFAULT;
        this.indexActive = GeoSPARQLConfig.isQueryRewriteEnabled();
        this.index = new ExpiringMap(this.queryRewriteLabel, MAP_SIZE_DEFAULT, MAP_EXPIRY_INTERVAL_DEFAULT);
        if (this.indexActive) {
            this.index.startExpiry();
        }
    }

    public QueryRewriteIndex(String queryRewriteLabel, int maxSize, long expiryInterval) {
        this.queryRewriteLabel = queryRewriteLabel;
        this.indexActive = true;
        this.index = new ExpiringMap(queryRewriteLabel, maxSize, expiryInterval);
        this.index.startExpiry();
    }

    public final Boolean test(Node subjectGeometryLiteral, Property predicate, Node objectGeometryLiteral, GenericPropertyFunction propertyFunction) {
        if (!subjectGeometryLiteral.isLiteral() || !objectGeometryLiteral.isLiteral()) {
            return false;
        }
        if (this.indexActive) {
            String key = subjectGeometryLiteral.getLiteralLexicalForm() + KEY_SEPARATOR + predicate.getURI() + KEY_SEPARATOR + objectGeometryLiteral.getLiteralLexicalForm();
            try {
                Boolean result;
                if (this.index.containsKey((Object)key)) {
                    result = (Boolean)this.index.get((Object)key);
                } else {
                    result = propertyFunction.testFilterFunction(subjectGeometryLiteral, objectGeometryLiteral);
                    this.index.put((Object)key, (Object)result);
                }
                return result;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return propertyFunction.testFilterFunction(subjectGeometryLiteral, objectGeometryLiteral);
    }

    public final void clear() {
        this.index.clear();
    }

    public final void setMapSize(int maxSize) {
        this.index.setMaxSize((long)maxSize);
    }

    public final void setMapExpiry(long expiryInterval) {
        this.index.setExpiryInterval(expiryInterval);
    }

    public boolean isIndexActive() {
        return this.indexActive;
    }

    public Model toModel() {
        Model model = ModelFactory.createDefaultModel();
        for (Map.Entry entry : this.index.entrySet()) {
            Boolean value = (Boolean)entry.getValue();
            if (!value.booleanValue()) continue;
            String[] parts = ((String)entry.getKey()).split(KEY_SEPARATOR);
            Resource subject = ResourceFactory.createResource((String)parts[0]);
            Property property = ResourceFactory.createProperty((String)parts[1]);
            Resource object = ResourceFactory.createResource((String)parts[2]);
            model.add(subject, property, (RDFNode)object);
        }
        return model;
    }

    public final void setActive(boolean indexActive) {
        this.indexActive = indexActive;
        if (indexActive) {
            this.index.startExpiry();
        } else {
            this.index.stopExpiry();
        }
    }

    public final long getIndexSize() {
        return this.index.mappingCount();
    }

    public void reset(int maxSize, long expiryInterval) {
        this.index = new ExpiringMap(this.queryRewriteLabel, maxSize, expiryInterval);
    }

    public static final void setMaxSize(int mapSizeDefault) {
        MAP_SIZE_DEFAULT = mapSizeDefault;
    }

    public static final void setExpiry(long mapExpiryIntervalDefault) {
        MAP_EXPIRY_INTERVAL_DEFAULT = mapExpiryIntervalDefault;
    }

    public static final QueryRewriteIndex createDefault() {
        return new QueryRewriteIndex();
    }

    public static final void prepare(Dataset dataset) {
        Context context = dataset.getContext();
        context.set(QUERY_REWRITE_INDEX_SYMBOL, (Object)QueryRewriteIndex.createDefault());
    }

    public static final void prepare(Dataset dataset, String queryRewriteLabel, int maxSize, long expiryInterval) {
        Context context = dataset.getContext();
        context.set(QUERY_REWRITE_INDEX_SYMBOL, (Object)new QueryRewriteIndex(queryRewriteLabel, maxSize, expiryInterval));
    }

    public static final QueryRewriteIndex retrieve(ExecutionContext execCxt) {
        Context context = execCxt.getContext();
        return QueryRewriteIndex.retrieve(context);
    }

    public static final QueryRewriteIndex retrieve(Dataset dataset) {
        Context context = dataset.getContext();
        return QueryRewriteIndex.retrieve(context);
    }

    public static final QueryRewriteIndex retrieve(Context context) {
        QueryRewriteIndex queryRewriteIndex = (QueryRewriteIndex)context.get(QUERY_REWRITE_INDEX_SYMBOL, null);
        if (queryRewriteIndex == null) {
            queryRewriteIndex = QueryRewriteIndex.createDefault();
            context.set(QUERY_REWRITE_INDEX_SYMBOL, (Object)queryRewriteIndex);
        }
        return queryRewriteIndex;
    }

    public static final Dataset wrapModel(Model model) {
        Dataset dataset = DatasetFactory.createTxnMem();
        dataset.setDefaultModel(model);
        QueryRewriteIndex.prepare(dataset);
        return dataset;
    }
}

