/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.SpatialIndexItem;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.locationtech.jts.geom.Envelope;

public class SpatialIndexStorage
implements Serializable {
    private final String srsURI;
    private final List<StorageItem> storageItems;

    public SpatialIndexStorage(Collection<SpatialIndexItem> spatialIndexItems, String srsURI) {
        this.srsURI = srsURI;
        this.storageItems = new ArrayList<StorageItem>(spatialIndexItems.size());
        for (SpatialIndexItem spatialIndexItem : spatialIndexItems) {
            StorageItem storageItem = new StorageItem(spatialIndexItem.getEnvelope(), spatialIndexItem.getItem());
            this.storageItems.add(storageItem);
        }
    }

    public String getSrsURI() {
        return this.srsURI;
    }

    public Collection<SpatialIndexItem> getIndexItems() {
        ArrayList<SpatialIndexItem> indexItems = new ArrayList<SpatialIndexItem>(this.storageItems.size());
        for (StorageItem storageItem : this.storageItems) {
            SpatialIndexItem indexItem = storageItem.getIndexItem();
            indexItems.add(indexItem);
        }
        return indexItems;
    }

    public SpatialIndex getSpatialIndex() throws SpatialIndexException {
        return new SpatialIndex(this.getIndexItems(), this.srsURI);
    }

    private class StorageItem
    implements Serializable {
        private final Envelope envelope;
        private final String uri;

        public StorageItem(Envelope envelope, Resource item) {
            this.envelope = envelope;
            this.uri = item.getURI();
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public String getUri() {
            return this.uri;
        }

        public Resource getItem() {
            return ResourceFactory.createResource((String)this.uri);
        }

        public SpatialIndexItem getIndexItem() {
            return new SpatialIndexItem(this.envelope, this.getItem());
        }

        public String toString() {
            return "StorageItem{envelope=" + this.envelope + ", uri=" + this.uri + "}";
        }
    }
}

