/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.property_functions.cardinal;

import java.util.List;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.spatial.ConvertLatLon;
import org.apache.jena.geosparql.spatial.SearchEnvelope;
import org.apache.jena.geosparql.spatial.property_functions.SpatialArguments;
import org.apache.jena.geosparql.spatial.property_functions.cardinal.GenericCardinalGeomPropertyFunction;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.FmtUtils;

public abstract class GenericCardinalPropertyFunction
extends GenericCardinalGeomPropertyFunction {
    private static final int LAT_POS = 0;
    private static final int LON_POS = 1;
    private static final int LIMIT_POS = 2;

    @Override
    protected SpatialArguments extractObjectArguments(Node predicate, PropFuncArg object, SRSInfo indexSRSInfo) {
        try {
            int limit;
            List objectArgs = object.getArgList();
            if (objectArgs.size() < 2) {
                throw new ExprEvalException(FmtUtils.stringForNode((Node)predicate) + ": Minimum of 2 arguments.");
            }
            if (objectArgs.size() > 3) {
                throw new ExprEvalException(FmtUtils.stringForNode((Node)predicate) + ": Maximum of 3 arguments.");
            }
            Node lat = (Node)objectArgs.get(0);
            Node lon = (Node)objectArgs.get(1);
            if (lat.isVariable() || lon.isVariable()) {
                throw new ExprEvalException("Arguments are not all concrete: " + FmtUtils.stringForNode((Node)lat) + ", " + FmtUtils.stringForNode((Node)lon));
            }
            if (objectArgs.size() > 2) {
                NodeValue limitNode = NodeValue.makeNode((Node)((Node)objectArgs.get(2)));
                if (!limitNode.isInteger()) {
                    throw new ExprEvalException("Not an integer: " + FmtUtils.stringForNode((Node)limitNode.getNode()));
                }
                limit = limitNode.getInteger().intValue();
            } else {
                limit = -1;
            }
            GeometryWrapper geometryWrapper = ConvertLatLon.toGeometryWrapper(lat, lon);
            SearchEnvelope searchEnvelope = this.buildSearchEnvelope(geometryWrapper, indexSRSInfo);
            return new SpatialArguments(limit, geometryWrapper, searchEnvelope);
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException(ex.getMessage(), (Throwable)ex);
        }
    }
}

