/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.assembler;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.geosparql.assembler.VocabGeoSPARQL;
import org.apache.jena.geosparql.configuration.GeoSPARQLConfig;
import org.apache.jena.geosparql.configuration.GeoSPARQLOperations;
import org.apache.jena.geosparql.configuration.SrsException;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoAssembler
extends DatasetAssembler {
    private static Logger LOG = LoggerFactory.getLogger(GeoAssembler.class);

    public DatasetGraph createDataset(Assembler a, Resource root) {
        DatasetGraph base = super.createBaseDataset(root, VocabGeoSPARQL.pDataset);
        Graph graph = root.getModel().getGraph();
        Node subj = root.asNode();
        boolean inference = true;
        if (root.hasProperty(VocabGeoSPARQL.pInference)) {
            inference = GraphUtils.getBooleanValue((Resource)root, (Property)VocabGeoSPARQL.pInference);
        }
        boolean applyDefaultGeometry = false;
        if (root.hasProperty(VocabGeoSPARQL.pApplyDefaultGeometry)) {
            applyDefaultGeometry = GraphUtils.getBooleanValue((Resource)root, (Property)VocabGeoSPARQL.pApplyDefaultGeometry);
        }
        boolean queryRewrite = true;
        if (root.hasProperty(VocabGeoSPARQL.pQueryRewrite)) {
            queryRewrite = GraphUtils.getBooleanValue((Resource)root, (Property)VocabGeoSPARQL.pQueryRewrite);
        }
        boolean indexEnabled = true;
        if (root.hasProperty(VocabGeoSPARQL.pIndexEnabled)) {
            indexEnabled = GraphUtils.getBooleanValue((Resource)root, (Property)VocabGeoSPARQL.pIndexEnabled);
        }
        List<Integer> indexSizes = Arrays.asList(-1, -1, -1);
        if (root.hasProperty(VocabGeoSPARQL.pIndexSizes)) {
            indexSizes = GeoAssembler.getListInteger(root, VocabGeoSPARQL.pIndexSizes, 3);
        }
        List<Integer> indexExpiries = Arrays.asList(5000, 5000, 5000);
        if (root.hasProperty(VocabGeoSPARQL.pIndexExpiries)) {
            indexExpiries = GeoAssembler.getListInteger(root, VocabGeoSPARQL.pIndexSizes, 3);
        }
        String spatialIndexFilename = null;
        if (root.hasProperty(VocabGeoSPARQL.pSpatialIndexFile)) {
            spatialIndexFilename = GraphUtils.getStringValue((Resource)root, (Property)VocabGeoSPARQL.pSpatialIndexFile);
        }
        Dataset dataset = DatasetFactory.wrap((DatasetGraph)base);
        if (applyDefaultGeometry) {
            GeoSPARQLOperations.applyDefaultGeometry(dataset);
        }
        if (inference) {
            GeoSPARQLOperations.applyInferencing(dataset);
        }
        if (indexEnabled) {
            GeoSPARQLConfig.setupMemoryIndex(indexSizes.get(0), indexSizes.get(1), indexSizes.get(2), (long)indexExpiries.get(0), (long)indexExpiries.get(1), (long)indexExpiries.get(2), queryRewrite);
        } else {
            GeoSPARQLConfig.setupNoIndex(queryRewrite);
        }
        GeoAssembler.prepareSpatialExtension(dataset, spatialIndexFilename);
        return base;
    }

    private static List<Integer> getListInteger(Resource r, Property p, int len) {
        String integers = GraphUtils.getStringValue((Resource)r, (Property)p);
        String[] values = integers.split(",");
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        for (String val : values) {
            val = val.trim();
            integerList.add(Integer.parseInt(val));
        }
        if (len >= 0 && integerList.size() != len) {
            throw new JenaException("Expected list of exactly " + len + " integers");
        }
        return integerList;
    }

    private static void prepareSpatialExtension(Dataset dataset, String spatialIndex) {
        boolean isEmpty = (Boolean)dataset.calculateRead(() -> dataset.isEmpty());
        if (isEmpty && spatialIndex != null) {
            LOG.warn("Dataset empty. Spatial Index not constructed. Server will require restarting after adding data and any updates to build Spatial Index.");
            return;
        }
        if (isEmpty) {
            return;
        }
        try {
            if (spatialIndex == null) {
                GeoSPARQLConfig.setupSpatialIndex(dataset);
                return;
            }
            Path spatialIndexPath = Path.of(spatialIndex, new String[0]);
            if (!Files.exists(spatialIndexPath, new LinkOption[0]) || Files.size(spatialIndexPath) == 0L) {
                GeoSPARQLConfig.setupSpatialIndex(dataset, spatialIndexPath.toFile());
                return;
            }
            GeoSPARQLConfig.setupPrecomputedSpatialIndex(dataset, spatialIndexPath.toFile());
        }
        catch (SrsException ex) {
            if (!ex.getMessage().startsWith("No SRS found")) {
                throw ex;
            }
            LOG.warn(ex.getMessage());
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
            return;
        }
        catch (SpatialIndexException ex) {
            String msg = "Failed to create spatial index: " + ex.getMessage();
            LOG.error(msg);
            throw new JenaException(msg, (Throwable)ex);
        }
    }
}

