/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.geosparql.configuration.GeoSPARQLConfig;
import org.apache.jena.geosparql.configuration.ModeSRS;
import org.apache.jena.geosparql.configuration.SrsException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.datatype.GMLDatatype;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;
import org.apache.jena.geosparql.implementation.datatype.WKTDatatype;
import org.apache.jena.geosparql.implementation.index.GeometryLiteralIndex;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.geosparql.implementation.vocabulary.GeoSPARQL_URI;
import org.apache.jena.geosparql.implementation.vocabulary.SpatialExtension;
import org.apache.jena.geosparql.spatial.ConvertLatLon;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerRegistry;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoSPARQLOperations {
    private static final String GEOSPARQL_SCHEMA_FILE = "schema/geosparql_vocab_all_v1_0_1_updated.rdf";
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static final void applySubPropertyDefaultGeometry(Model model) {
        try {
            ResIterator resIt = model.listResourcesWithProperty(RDFS.subPropertyOf, (RDFNode)Geo.HAS_GEOMETRY_PROP);
            while (resIt.hasNext()) {
                Resource res = resIt.nextResource();
                res.addProperty(RDFS.subPropertyOf, (RDFNode)Geo.HAS_DEFAULT_GEOMETRY_PROP);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Inserting GeoSPARQL predicates error: {}", (Object)ex.getMessage());
        }
    }

    public static final void applyDefaultGeometry(Dataset dataset) {
        dataset.executeWrite(() -> {
            try {
                Model defaultModel = dataset.getDefaultModel();
                GeoSPARQLOperations.applyDefaultGeometry(defaultModel);
                Iterator graphNames = dataset.listNames();
                while (graphNames.hasNext()) {
                    String graphName = (String)graphNames.next();
                    Model namedModel = dataset.getNamedModel(graphName);
                    GeoSPARQLOperations.applyDefaultGeometry(namedModel);
                }
                LOGGER.info("Applying hasDefaultGeometry - Completed");
            }
            catch (Exception ex) {
                LOGGER.error("Write Error: {}", (Object)ex.getMessage());
            }
        });
    }

    public static final void applyDefaultGeometry(Model model) {
        ResIterator featureIt = model.listResourcesWithProperty(Geo.HAS_GEOMETRY_PROP);
        while (featureIt.hasNext()) {
            List statement;
            Resource feature = featureIt.nextResource();
            if (feature.hasProperty(Geo.HAS_DEFAULT_GEOMETRY_PROP) || (statement = feature.listProperties(Geo.HAS_GEOMETRY_PROP).toList()).size() != 1) continue;
            try {
                Resource geometry = ((Statement)statement.get(0)).getResource();
                feature.addProperty(Geo.HAS_DEFAULT_GEOMETRY_PROP, (RDFNode)geometry);
            }
            catch (Exception ex) {
                LOGGER.error("Error creating default geometry: {}", (Object)ex.getMessage());
            }
        }
    }

    public static final void applyDefaultGeometry(File inputFile, Lang inputLang, File outputFile, Lang outputLang) {
        LOGGER.info("Applying Predicates from File: {} to {} - Started", (Object)inputFile.getAbsolutePath(), (Object)outputFile.getAbsolutePath());
        Model model = GeoSPARQLOperations.applyDefaultGeometry(inputFile, inputLang);
        GeoSPARQLOperations.writeOutputModel(model, outputFile, outputLang, inputFile);
        LOGGER.info("Applying Predicates from File: {} to {} - Completed", (Object)inputFile.getAbsolutePath(), (Object)outputFile.getAbsolutePath());
    }

    public static final Model applyDefaultGeometry(File inputFile, Lang inputLang) {
        Model model = ModelFactory.createDefaultModel();
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            RDFDataMgr.read((Model)model, (InputStream)inputStream, (Lang)inputLang);
            GeoSPARQLOperations.applyDefaultGeometry(model);
        }
        catch (IOException ex) {
            LOGGER.error("Input File IO Exception: {} - {}", (Object)inputFile.getAbsolutePath(), (Object)ex.getMessage());
        }
        return model;
    }

    public static final void applyDefaultGeometryFolder(File inputFolder, Lang inputLang, File outputFolder, Lang outputLang) {
        LOGGER.info("Applying Predicates from Folder {} to {} - Started", (Object)inputFolder.getAbsolutePath(), (Object)outputFolder.getAbsolutePath());
        if (inputFolder.exists()) {
            File[] inputFiles = inputFolder.listFiles();
            if (inputFiles.length > 0) {
                outputFolder.mkdir();
                for (File inputFile : inputFiles) {
                    File outputFile = new File(outputFolder, inputFile.getName());
                    try {
                        GeoSPARQLOperations.applyDefaultGeometry(inputFile, inputLang, outputFile, outputLang);
                    }
                    catch (Exception ex) {
                        LOGGER.error("{} for input {}. The output file {} may not be created.", new Object[]{ex.getMessage(), inputFile.getAbsolutePath(), outputFile.getAbsolutePath()});
                    }
                }
            } else {
                LOGGER.warn("{} is empty. {} is not created.", (Object)inputFolder.getAbsolutePath(), (Object)outputFolder.getAbsolutePath());
            }
        } else {
            LOGGER.warn("{} does not exist. {} is not created.", (Object)inputFolder.getAbsolutePath(), (Object)outputFolder.getAbsolutePath());
        }
        LOGGER.info("Applying Predicates from Folder {} to {} - Completed", (Object)inputFolder.getAbsolutePath(), (Object)outputFolder.getAbsolutePath());
    }

    public static final Model loadGeoSPARQLSchema() {
        Model geosparqlSchema = ModelFactory.createDefaultModel();
        InputStream inputStream = GeoSPARQLOperations.class.getClassLoader().getResourceAsStream(GEOSPARQL_SCHEMA_FILE);
        RDFDataMgr.read((Model)geosparqlSchema, (InputStream)inputStream, (Lang)Lang.RDFXML);
        return geosparqlSchema;
    }

    public static final void applyInferencing(Dataset dataset) {
        Model geosparqlSchema = GeoSPARQLOperations.loadGeoSPARQLSchema();
        GeoSPARQLOperations.applyInferencing(geosparqlSchema, dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void applyInferencing(Model geosparqlSchema, Dataset dataset) {
        LOGGER.info("Applying GeoSPARQL Schema - Started");
        try {
            dataset.begin(ReadWrite.WRITE);
            Model defaultModel = dataset.getDefaultModel();
            GeoSPARQLOperations.applyInferencing(geosparqlSchema, defaultModel, "default");
            Iterator graphNames = dataset.listNames();
            while (graphNames.hasNext()) {
                String graphName = (String)graphNames.next();
                Model namedModel = dataset.getNamedModel(graphName);
                GeoSPARQLOperations.applyInferencing(geosparqlSchema, namedModel, graphName);
            }
            dataset.commit();
            LOGGER.info("Applying GeoSPARQL Schema - Completed");
        }
        catch (Exception ex) {
            try {
                dataset.abort();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOGGER.error("Inferencing Error: {}", (Object)ex.getMessage());
        }
        finally {
            try {
                dataset.end();
            }
            catch (Throwable throwable) {}
        }
    }

    public static final void applyInferencing(Model dataModel) {
        Model geosparqlSchema = GeoSPARQLOperations.loadGeoSPARQLSchema();
        GeoSPARQLOperations.applyInferencing(geosparqlSchema, dataModel);
    }

    public static final void applyInferencing(Model geosparqlSchema, Model model) {
        GeoSPARQLOperations.applyInferencing(geosparqlSchema, model, "unnamed");
    }

    public static final void applyInferencing(Model geosparqlSchema, Model model, String graphName) {
        if (!model.isEmpty()) {
            InfModel infModel = ModelFactory.createRDFSModel((Model)geosparqlSchema, (Model)model);
            model.add((Model)infModel);
            LOGGER.info("GeoSPARQL schema applied to graph: {}", (Object)graphName);
        } else {
            LOGGER.info("GeoSPARQL schema not applied to empty graph: {}", (Object)graphName);
        }
    }

    public static final InfModel prepare() {
        return GeoSPARQLOperations.prepareRDFS(ModelFactory.createDefaultModel());
    }

    public static final InfModel prepareRDFS(Model model) {
        return GeoSPARQLOperations.prepare(model, ReasonerRegistry.getRDFSReasoner());
    }

    public static final InfModel prepare(Model model, Reasoner reasoner) {
        InputStream geosparqlSchemaInputStream = GeoSPARQLOperations.class.getClassLoader().getResourceAsStream(GEOSPARQL_SCHEMA_FILE);
        return GeoSPARQLOperations.prepare(geosparqlSchemaInputStream, model, reasoner);
    }

    public static final InfModel prepareRDFS(InputStream inputStream) {
        return GeoSPARQLOperations.prepare(inputStream, ReasonerRegistry.getRDFSReasoner());
    }

    public static final InfModel prepare(InputStream inputStream, Reasoner reasoner) {
        Model model = ModelFactory.createDefaultModel();
        model.read(inputStream, null);
        return GeoSPARQLOperations.prepare(model, reasoner);
    }

    public static final InfModel prepare(InputStream geosparqlSchemaInputStream, Model model, Reasoner reasoner) {
        Model schema = ModelFactory.createDefaultModel();
        schema.read(geosparqlSchemaInputStream, null);
        reasoner = reasoner.bindSchema(schema);
        InfModel infModel = ModelFactory.createInfModel((Reasoner)reasoner, (Model)model);
        return infModel;
    }

    public static final boolean validateGeometryLiteral(Dataset dataset) {
        boolean isValid = true;
        LOGGER.info("Validate Geometry Literal - Started");
        dataset.begin(ReadWrite.READ);
        Model defaultModel = dataset.getDefaultModel();
        GeoSPARQLOperations.validateGeometryLiteral(defaultModel);
        Iterator graphNames = dataset.listNames();
        while (graphNames.hasNext()) {
            String graphName = (String)graphNames.next();
            Model namedModel = dataset.getNamedModel(graphName);
            boolean isModelValid = GeoSPARQLOperations.validateGeometryLiteral(namedModel);
            if (isModelValid) continue;
            isValid = false;
        }
        LOGGER.info("Validate Geometry Literal - Completed");
        dataset.end();
        return isValid;
    }

    public static final boolean validateGeometryLiteral(Model model) {
        boolean isIndexActive = GeometryLiteralIndex.isIndexActive();
        GeometryLiteralIndex.setIndexActive(false);
        boolean isValid = true;
        NodeIterator nodeIt = model.listObjectsOfProperty(Geo.HAS_DEFAULT_GEOMETRY_PROP);
        while (nodeIt.hasNext()) {
            RDFNode node = nodeIt.nextNode();
            try {
                Literal geometryLiteral = node.asLiteral();
                GeometryWrapper.extract(geometryLiteral);
            }
            catch (DatatypeFormatException ex) {
                isValid = false;
            }
        }
        GeometryLiteralIndex.setIndexActive(isIndexActive);
        return isValid;
    }

    public static final String findModeSRS(Dataset dataset) throws SrsException {
        LOGGER.info("Find Mode SRS - Started");
        ModeSRS modeSRS = new ModeSRS();
        dataset.begin(ReadWrite.READ);
        Model defaultModel = dataset.getDefaultModel();
        modeSRS.search(defaultModel);
        Iterator graphNames = dataset.listNames();
        while (graphNames.hasNext()) {
            String graphName = (String)graphNames.next();
            Model namedModel = dataset.getNamedModel(graphName);
            modeSRS.search(namedModel);
        }
        LOGGER.info("Find Mode SRS - Completed");
        dataset.end();
        return modeSRS.getModeURI();
    }

    public static final String findModeSRS(Model model) throws SrsException {
        ModeSRS modeSRS = new ModeSRS();
        modeSRS.search(model);
        return modeSRS.getModeURI();
    }

    public static final void convertFile(File inputFile, Lang inputLang, File outputFile, Lang outputLang, String outputSrsURI) {
        GeoSPARQLOperations.convertFileSRSDatatype(inputFile, inputLang, outputFile, outputLang, outputSrsURI, null);
    }

    public static final void convertFile(File inputFile, Lang inputLang, File outputFile, Lang outputLang) {
        GeoSPARQLOperations.convertFileSRSDatatype(inputFile, inputLang, outputFile, outputLang, null, null);
    }

    public static final void convertFile(File inputFile, Lang inputLang, File outputFile, Lang outputLang, String outputSrsURI, GeometryDatatype outputDatatype) {
        GeoSPARQLOperations.convertFileSRSDatatype(inputFile, inputLang, outputFile, outputLang, outputSrsURI, outputDatatype);
    }

    public static final void convertFile(File inputFile, Lang inputLang, File outputFile, Lang outputLang, GeometryDatatype outputDatatype) {
        GeoSPARQLOperations.convertFileSRSDatatype(inputFile, inputLang, outputFile, outputLang, null, outputDatatype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Model convertSRSDatatype(Model inputModel, String outputSrsURI, GeometryDatatype outputDatatype) {
        if (outputSrsURI == null) {
            outputSrsURI = GeoSPARQLOperations.findModeSRS(inputModel);
        }
        if (outputDatatype == null || !GeometryDatatype.check((RDFDatatype)outputDatatype)) {
            LOGGER.warn("Output datatype {} is not a recognised for Geometry Literal. Defaulting to {}.", (Object)outputDatatype, (Object)"http://www.opengis.net/ont/geosparql#wktLiteral");
            outputDatatype = WKTDatatype.INSTANCE;
        }
        Model outputModel = ModelFactory.createDefaultModel();
        outputModel.setNsPrefixes(inputModel.getNsPrefixMap());
        try (StmtIterator statementIt = inputModel.listStatements();){
            while (statementIt.hasNext()) {
                Statement statement = (Statement)statementIt.next();
                RDFNode object = statement.getObject();
                if (object.isLiteral()) {
                    GeoSPARQLOperations.handleLiteral(statement, outputModel, outputSrsURI, outputDatatype);
                    continue;
                }
                outputModel.add(statement);
            }
        }
        return outputModel;
    }

    public static final List<String> convertGeometryLiterals(List<String> geometryLiterals, String outputSrsURI, GeometryDatatype outputDatatype) {
        ArrayList<String> outputGeometryLiterals = new ArrayList<String>(geometryLiterals.size());
        for (String geometryLiteral : geometryLiterals) {
            String convertedGeometryLiteral = GeoSPARQLOperations.convertGeometryLiteral(geometryLiteral, outputSrsURI, outputDatatype);
            outputGeometryLiterals.add(convertedGeometryLiteral);
        }
        return outputGeometryLiterals;
    }

    public static void writeOutputModel(Model outputModel, File outputFile, Lang outputLang, File inputFile) {
        if (!outputModel.isEmpty()) {
            try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                RDFDataMgr.write((OutputStream)outputStream, (Model)outputModel, (Lang)outputLang);
            }
            catch (IOException ex) {
                LOGGER.error("Output File IO Exception: {} - {}", (Object)outputFile.getAbsolutePath(), (Object)ex.getMessage());
            }
        } else {
            LOGGER.warn("Output Model is empty for {}: Did not create: {}", (Object)inputFile.getAbsolutePath(), (Object)outputFile.getAbsolutePath());
        }
    }

    private static void handleLiteral(Statement statement, Model outputModel, String outputSrsURI, GeometryDatatype outputDatatype) {
        Literal literal = statement.getLiteral();
        RDFDatatype datatype = literal.getDatatype();
        if (GeometryDatatype.check(datatype)) {
            GeometryWrapper convertedGeom;
            GeometryWrapper originalGeom = GeometryWrapper.extract(literal);
            try {
                convertedGeom = outputSrsURI != null ? originalGeom.convertSRS(outputSrsURI) : originalGeom;
            }
            catch (MismatchedDimensionException | TransformException | FactoryException ex) {
                LOGGER.error("SRS Conversion Exception: {} - Literal: {}, Output SRS URI: {}. Reusing original literal for output.", new Object[]{ex.getMessage(), literal, outputSrsURI});
                convertedGeom = originalGeom;
            }
            if (outputDatatype == null) {
                outputDatatype = GeometryDatatype.get(datatype);
            }
            Literal convertedGeometryLiteral = convertedGeom.asLiteral(outputDatatype);
            Property outputProperty = statement.getPredicate();
            if (outputProperty.equals(Geo.AS_GML_PROP) && ((Object)((Object)outputDatatype)).equals((Object)WKTDatatype.INSTANCE)) {
                outputProperty = Geo.AS_WKT_PROP;
            } else if (outputProperty.equals(Geo.AS_WKT_PROP) && ((Object)((Object)outputDatatype)).equals((Object)GMLDatatype.INSTANCE)) {
                outputProperty = Geo.AS_GML_PROP;
            }
            Statement outputStatement = ResourceFactory.createStatement((Resource)statement.getSubject(), (Property)outputProperty, (RDFNode)convertedGeometryLiteral);
            outputModel.add(outputStatement);
        } else {
            outputModel.add(statement);
        }
    }

    public static final void convertFolder(File inputFolder, Lang inputLang, File outputFolder, Lang outputLang, String outputSrsURI) {
        GeoSPARQLOperations.convertFolderSRSDatatype(inputFolder, inputLang, outputFolder, outputLang, outputSrsURI, null);
    }

    public static final void convertFolder(File inputFolder, Lang inputLang, File outputFolder, Lang outputLang) {
        GeoSPARQLOperations.convertFolderSRSDatatype(inputFolder, inputLang, outputFolder, outputLang, null, null);
    }

    public static final void convertFolder(File inputFolder, Lang inputLang, File outputFolder, Lang outputLang, String outputSrsURI, GeometryDatatype outputDatatype) {
        GeoSPARQLOperations.convertFolderSRSDatatype(inputFolder, inputLang, outputFolder, outputLang, outputSrsURI, outputDatatype);
    }

    public static final void convertFolder(File inputFolder, Lang inputLang, File outputFolder, Lang outputLang, GeometryDatatype outputDatatype) {
        GeoSPARQLOperations.convertFolderSRSDatatype(inputFolder, inputLang, outputFolder, outputLang, null, outputDatatype);
    }

    public static final Dataset convertGeoPredicates(Dataset dataset, boolean isRemoveGeoPredicate) {
        LOGGER.info("Convert Geo Predicates - Started");
        Dataset outputDataset = DatasetFactory.createTxnMem();
        outputDataset.begin(ReadWrite.WRITE);
        dataset.begin(ReadWrite.READ);
        Model defaultModel = dataset.getDefaultModel();
        Model convertedModel = GeoSPARQLOperations.convertGeoPredicates(defaultModel, isRemoveGeoPredicate);
        convertedModel.setNsPrefixes(defaultModel.getNsPrefixMap());
        outputDataset.setDefaultModel(convertedModel);
        Iterator graphNames = dataset.listNames();
        while (graphNames.hasNext()) {
            String graphName = (String)graphNames.next();
            Model namedModel = dataset.getNamedModel(graphName);
            Model convertedNamedModel = GeoSPARQLOperations.convertGeoPredicates(namedModel, isRemoveGeoPredicate);
            convertedNamedModel.setNsPrefixes(namedModel.getNsPrefixMap());
            outputDataset.addNamedModel(graphName, convertedNamedModel);
        }
        LOGGER.info("Convert Geo Predicates - Completed");
        dataset.end();
        outputDataset.commit();
        outputDataset.end();
        return outputDataset;
    }

    public static final Model convertGeoPredicates(Model model, boolean isRemoveGeoPredicates) {
        Model outputModel = ModelFactory.createDefaultModel();
        outputModel.add(model);
        outputModel.setNsPrefixes(model.getNsPrefixMap());
        if (outputModel.containsResource((RDFNode)SpatialExtension.GEO_LAT_PROP)) {
            ResIterator resIt = outputModel.listSubjectsWithProperty(SpatialExtension.GEO_LAT_PROP);
            while (resIt.hasNext()) {
                Resource feature = resIt.nextResource();
                if (!feature.hasProperty(SpatialExtension.GEO_LON_PROP) || !feature.hasProperty(SpatialExtension.GEO_LAT_PROP)) continue;
                Literal lat = feature.getProperty(SpatialExtension.GEO_LAT_PROP).getLiteral();
                Literal lon = feature.getProperty(SpatialExtension.GEO_LON_PROP).getLiteral();
                try {
                    Literal latLonPoint = ConvertLatLon.toLiteral(lat.getFloat(), lon.getFloat());
                    Resource geometry = GeoSPARQLOperations.createGeometry(feature);
                    outputModel.add(feature, Geo.HAS_GEOMETRY_PROP, (RDFNode)geometry);
                    outputModel.add(geometry, Geo.HAS_SERIALIZATION_PROP, (RDFNode)latLonPoint);
                    outputModel.add(geometry, Geo.AS_WKT_PROP, (RDFNode)latLonPoint);
                }
                catch (DatatypeFormatException ex) {
                    LOGGER.error("Feature: {} has geo lat/lon out of bounds. Lat: {}, Lon: {}", new Object[]{feature, lat, lon});
                }
            }
            if (isRemoveGeoPredicates) {
                outputModel.removeAll(null, SpatialExtension.GEO_LAT_PROP, null);
                outputModel.removeAll(null, SpatialExtension.GEO_LON_PROP, null);
            }
        }
        return outputModel;
    }

    private static Resource createGeometry(Resource feature) {
        String geometryURI = feature.isURIResource() ? feature.getURI() + "-Geom-" + UUID.randomUUID().toString() : "http://www.opengis.net/ont/geosparql#Geom-" + UUID.randomUUID().toString();
        Resource geometry = ResourceFactory.createResource((String)geometryURI);
        return geometry;
    }

    public static final Dataset convertGeometryStructure(Dataset dataset) {
        LOGGER.info("Convert Geometry Structure - Started");
        Dataset outputDataset = DatasetFactory.createTxnMem();
        outputDataset.begin(ReadWrite.WRITE);
        dataset.begin(ReadWrite.READ);
        Model defaultModel = dataset.getDefaultModel();
        Model convertedModel = GeoSPARQLOperations.convertGeometryStructure(defaultModel);
        convertedModel.setNsPrefixes(defaultModel.getNsPrefixMap());
        outputDataset.setDefaultModel(convertedModel);
        Iterator graphNames = dataset.listNames();
        while (graphNames.hasNext()) {
            String graphName = (String)graphNames.next();
            Model namedModel = dataset.getNamedModel(graphName);
            Model convertedNamedModel = GeoSPARQLOperations.convertGeometryStructure(namedModel);
            convertedNamedModel.setNsPrefixes(namedModel.getNsPrefixMap());
            outputDataset.addNamedModel(graphName, convertedNamedModel);
        }
        LOGGER.info("Convert Geometry Structure - Completed");
        dataset.end();
        outputDataset.commit();
        outputDataset.end();
        return outputDataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Model convertGeometryStructure(Model model) {
        Model outputModel = ModelFactory.createDefaultModel();
        outputModel.add(model);
        outputModel.setNsPrefixes(model.getNsPrefixMap());
        ArrayList<Statement> additionalStatements = new ArrayList<Statement>();
        try (StmtIterator stmtIter = outputModel.listStatements();){
            while (stmtIter.hasNext()) {
                Property property;
                Literal literal;
                RDFDatatype datatype;
                Statement stmt = stmtIter.nextStatement();
                RDFNode object = stmt.getObject();
                if (!object.isLiteral() || !GeometryDatatype.check(datatype = (literal = object.asLiteral()).getDatatype()) || (property = stmt.getPredicate()).equals(Geo.HAS_SERIALIZATION_PROP) || property.equals(Geo.AS_WKT_PROP) || property.equals(Geo.AS_GML_PROP) || outputModel.contains((Resource)property, RDFS.subPropertyOf, (RDFNode)Geo.HAS_SERIALIZATION_PROP)) continue;
                Resource feature = stmt.getSubject();
                Resource geometry = GeoSPARQLOperations.createGeometry(feature);
                additionalStatements.add(ResourceFactory.createStatement((Resource)feature, (Property)Geo.HAS_GEOMETRY_PROP, (RDFNode)geometry));
                additionalStatements.add(ResourceFactory.createStatement((Resource)geometry, (Property)Geo.HAS_SERIALIZATION_PROP, (RDFNode)literal));
                stmtIter.remove();
            }
        }
        outputModel.add(additionalStatements);
        return outputModel;
    }

    private static void convertFileSRSDatatype(File inputFile, Lang inputLang, File outputFile, Lang outputLang, String outputSrsURI, GeometryDatatype outputDatatype) {
        LOGGER.info("Converting File: {} to {} in srs URI: {} - Started", new Object[]{inputFile.getAbsolutePath(), outputFile.getAbsolutePath(), outputSrsURI});
        Model inputModel = ModelFactory.createDefaultModel();
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            RDFDataMgr.read((Model)inputModel, (InputStream)inputStream, (Lang)inputLang);
        }
        catch (IOException ex) {
            LOGGER.error("Input File IO Exception: {} - {}", (Object)inputFile.getAbsolutePath(), (Object)ex.getMessage());
        }
        Model outputModel = GeoSPARQLOperations.convertSRSDatatype(inputModel, outputSrsURI, outputDatatype);
        GeoSPARQLOperations.writeOutputModel(outputModel, outputFile, outputLang, inputFile);
        LOGGER.info("Converting File: {} to {} in srs URI: {} - Completed", new Object[]{inputFile.getAbsolutePath(), outputFile.getAbsolutePath(), outputSrsURI});
    }

    private static void convertFolderSRSDatatype(File inputFolder, Lang inputLang, File outputFolder, Lang outputLang, String outputSrsURI, GeometryDatatype outputDatatype) {
        LOGGER.info("Converting Folder {} to {} in srs URI: {} - Started", new Object[]{inputFolder.getAbsolutePath(), outputFolder.getAbsolutePath(), outputSrsURI});
        if (inputFolder.exists()) {
            File[] inputFiles = inputFolder.listFiles();
            if (inputFiles.length > 0) {
                outputFolder.mkdir();
                for (File inputFile : inputFiles) {
                    File outputFile = new File(outputFolder, inputFile.getName());
                    try {
                        GeoSPARQLOperations.convertFile(inputFile, inputLang, outputFile, outputLang, outputSrsURI, outputDatatype);
                    }
                    catch (Exception ex) {
                        LOGGER.error("{} for input {}. The output file {} may not be created.", new Object[]{ex.getMessage(), inputFile.getAbsolutePath(), outputFile.getAbsolutePath()});
                    }
                }
            } else {
                LOGGER.warn("{} is empty. {} is not created.", (Object)inputFolder.getAbsolutePath(), (Object)outputFolder.getAbsolutePath());
            }
        } else {
            LOGGER.warn("{} does not exist. {} is not created.", (Object)inputFolder.getAbsolutePath(), (Object)outputFolder.getAbsolutePath());
        }
        LOGGER.info("Converting Folder {} to {} in srs URI: {} - Completed", new Object[]{inputFolder.getAbsolutePath(), outputFolder.getAbsolutePath(), outputSrsURI});
    }

    public static final String convertGeometryLiteral(String geometryLiteral, String outputSrsURI, GeometryDatatype outputDatatype) {
        Literal lit = ResourceFactory.createTypedLiteral((String)geometryLiteral, (RDFDatatype)outputDatatype);
        GeometryWrapper geometryWrapper = GeometryWrapper.extract(lit);
        try {
            GeometryWrapper transformedGeometryWrapper = geometryWrapper.convertSRS(outputSrsURI);
            Literal transformedLit = transformedGeometryWrapper.asLiteral();
            return transformedLit.getLexicalForm();
        }
        catch (MismatchedDimensionException | TransformException | FactoryException ex) {
            LOGGER.error("{} : {} : {}", new Object[]{ex.getMessage(), geometryLiteral, outputSrsURI});
            return null;
        }
    }

    public static final Model convert(Model inputModel) {
        return GeoSPARQLOperations.convertSRSDatatype(inputModel, null, null);
    }

    public static final Model convert(Model inputModel, String outputSrsURI) {
        return GeoSPARQLOperations.convertSRSDatatype(inputModel, outputSrsURI, null);
    }

    public static final Model convert(Model inputModel, GeometryDatatype outputDatatype) {
        return GeoSPARQLOperations.convertSRSDatatype(inputModel, null, outputDatatype);
    }

    public static final Model convert(Model inputModel, String outputSrsURI, GeometryDatatype outputDatatype) {
        return GeoSPARQLOperations.convertSRSDatatype(inputModel, outputSrsURI, outputDatatype);
    }

    public static final Model convert(Model inputModel, String outputSrsURI, String outputDatatypeURI) {
        return GeoSPARQLOperations.convertSRSDatatype(inputModel, outputSrsURI, GeometryDatatype.get(outputDatatypeURI));
    }

    public static final Dataset convert(Dataset dataset) {
        return GeoSPARQLOperations.convert(dataset, null, null);
    }

    public static final Dataset convert(Dataset dataset, String outputSrsURI) {
        return GeoSPARQLOperations.convert(dataset, outputSrsURI, null);
    }

    public static final Dataset convert(Dataset dataset, GeometryDatatype outputDatatype) {
        return GeoSPARQLOperations.convert(dataset, null, outputDatatype);
    }

    public static final Dataset convert(Dataset inputDataset, String outputSrsURI, GeometryDatatype outputDatatype) {
        LOGGER.info("Convert Dataset - Started SRS: {}, Datatype: {}", (Object)outputSrsURI, (Object)outputDatatype);
        if (outputSrsURI == null) {
            outputSrsURI = GeoSPARQLOperations.findModeSRS(inputDataset);
            LOGGER.info("SRS URI not specified. Defaulting to most frequent SRS URI: {}", (Object)outputSrsURI);
        }
        if (outputDatatype == null || !GeometryDatatype.check((RDFDatatype)outputDatatype)) {
            LOGGER.warn("Output datatype {} is not a recognised for Geometry Literal. Defaulting to {}.", (Object)outputDatatype, (Object)"http://www.opengis.net/ont/geosparql#wktLiteral");
            outputDatatype = WKTDatatype.INSTANCE;
        }
        Dataset dataset = DatasetFactory.createTxnMem();
        dataset.begin(ReadWrite.WRITE);
        inputDataset.begin(ReadWrite.READ);
        Model defaultModel = inputDataset.getDefaultModel();
        Model convertedModel = GeoSPARQLOperations.convertSRSDatatype(defaultModel, outputSrsURI, outputDatatype);
        dataset.setDefaultModel(convertedModel);
        Iterator graphNames = inputDataset.listNames();
        while (graphNames.hasNext()) {
            String graphName = (String)graphNames.next();
            Model namedModel = inputDataset.getNamedModel(graphName);
            Model convertedNamedModel = GeoSPARQLOperations.convertSRSDatatype(namedModel, outputSrsURI, outputDatatype);
            dataset.addNamedModel(graphName, convertedNamedModel);
        }
        LOGGER.info("Convert Dataset - Completed SRS: {}, Datatype: {}", (Object)outputSrsURI, (Object)outputDatatype);
        dataset.commit();
        dataset.end();
        inputDataset.end();
        return dataset;
    }

    public static final int countGeometryLiterals(Model model, String graphName) {
        TreeSet<String> literalStrings = new TreeSet<String>();
        StmtIterator hasSerializationIterator = model.listStatements(null, Geo.HAS_SERIALIZATION_PROP, (RDFNode)null);
        StmtIterator asWKTIterator = model.listStatements(null, Geo.AS_WKT_PROP, (RDFNode)null);
        StmtIterator asGMLIterator = model.listStatements(null, Geo.AS_GML_PROP, (RDFNode)null);
        ExtendedIterator allIterator = hasSerializationIterator.andThen((Iterator)asWKTIterator).andThen((Iterator)asGMLIterator);
        int count = 0;
        while (allIterator.hasNext()) {
            Statement st = (Statement)allIterator.next();
            String literalString = st.getLiteral().getString();
            literalStrings.add(literalString);
            ++count;
        }
        LOGGER.info("Graph: {} has {} unique out of {} Geometry Literals.", new Object[]{graphName, literalStrings.size(), count});
        return count;
    }

    public static final int countGeometryLiterals(Dataset dataset) {
        dataset.begin(ReadWrite.READ);
        Model defaultModel = dataset.getDefaultModel();
        int count = GeoSPARQLOperations.countGeometryLiterals(defaultModel, "Default Model");
        Iterator iterator = dataset.listNames();
        while (iterator.hasNext()) {
            String graphName = (String)iterator.next();
            Model namedModel = dataset.getNamedModel(graphName);
            count += GeoSPARQLOperations.countGeometryLiterals(namedModel, graphName);
        }
        dataset.end();
        return count;
    }

    public static final void applyPrefixes(Model model) {
        HashMap<String, String> geoPrefixes = GeoSPARQL_URI.getPrefixes();
        model.setNsPrefixes(geoPrefixes);
    }

    public static final void applyPrefixes(Dataset dataset) {
        dataset.begin(ReadWrite.READ);
        Model defaultModel = dataset.getDefaultModel();
        GeoSPARQLOperations.applyPrefixes(defaultModel);
        Iterator iterator = dataset.listNames();
        while (iterator.hasNext()) {
            String graphName = (String)iterator.next();
            Model namedModel = dataset.getNamedModel(graphName);
            GeoSPARQLOperations.applyPrefixes(namedModel);
        }
        dataset.commit();
        dataset.end();
    }

    public static double cleanUpPrecision(double value) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(value));
        bigDecimal = bigDecimal.setScale(GeoSPARQLConfig.DECIMAL_PLACES_PRECISION, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }
}

