/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.registry;

import java.lang.invoke.MethodHandles;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.AbstractHashedMap;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.sis.referencing.CRS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathTransformRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final MultiKeyMap<CoordinateReferenceSystem, MathTransform> MATH_TRANSFORM_REGISTRY = MultiKeyMap.multiKeyMap((AbstractHashedMap)new HashedMap());

    public static final synchronized MathTransform getMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException, MismatchedDimensionException, TransformException {
        MathTransform transform;
        MultiKey key = new MultiKey((Object)sourceCRS, (Object)targetCRS);
        if (MATH_TRANSFORM_REGISTRY.containsKey((Object)key)) {
            transform = (MathTransform)MATH_TRANSFORM_REGISTRY.get((Object)key);
        } else {
            transform = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, null).getMathTransform();
            MATH_TRANSFORM_REGISTRY.put(key, (Object)transform);
        }
        return transform;
    }

    public static final synchronized void clear() {
        MATH_TRANSFORM_REGISTRY.clear();
    }
}

