/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.property_functions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.geosparql.implementation.vocabulary.SpatialExtension;
import org.apache.jena.geosparql.spatial.ConvertLatLon;
import org.apache.jena.geosparql.spatial.SearchEnvelope;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.property_functions.SpatialArguments;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PFuncSimpleAndList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;

public abstract class GenericSpatialPropertyFunction
extends PFuncSimpleAndList {
    public static final int DEFAULT_LIMIT = -1;
    private SpatialIndex spatialIndex;
    private SpatialArguments spatialArguments;

    public final QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
        try {
            this.spatialIndex = SpatialIndex.retrieve(execCxt);
            this.spatialArguments = this.extractObjectArguments(predicate, object, this.spatialIndex.getSrsInfo());
            return this.search(binding, execCxt, subject, this.spatialArguments.limit);
        }
        catch (SpatialIndexException ex) {
            throw new ExprEvalException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected abstract SpatialArguments extractObjectArguments(Node var1, PropFuncArg var2, SRSInfo var3);

    private QueryIterator search(Binding binding, ExecutionContext execCxt, Node subject, int limit) {
        if (subject.isURI() || subject.isBlank()) {
            boolean isMatched = this.checkBound(execCxt, subject);
            if (isMatched) {
                return QueryIterSingleton.create((Binding)binding, (ExecutionContext)execCxt);
            }
            return QueryIterNullIterator.create((ExecutionContext)execCxt);
        }
        if (subject.isVariable()) {
            return this.checkUnbound(binding, execCxt, subject, limit);
        }
        throw new ExprEvalException("Not a URI, Blank or variable: " + FmtUtils.stringForNode((Node)subject));
    }

    private boolean checkBound(ExecutionContext execCxt, Node subject) {
        try {
            Triple triple;
            Node geometryLiteral;
            GeometryWrapper targetGeometryWrapper;
            Graph graph = execCxt.getActiveGraph();
            IteratorChain spatialTriples = new IteratorChain();
            if (graph.contains(subject, Geo.HAS_GEOMETRY_NODE, null)) {
                List geometryNodes = G.listSP((Graph)graph, (Node)subject, (Node)Geo.HAS_GEOMETRY_NODE);
                geometryNodes.forEach(geometry -> {
                    ExtendedIterator iter = graph.find(geometry, Geo.HAS_SERIALIZATION_NODE, null);
                    if (!iter.hasNext()) {
                        iter = graph.find(geometry, Geo.AS_WKT_NODE, null);
                    }
                    if (!iter.hasNext()) {
                        iter = graph.find(geometry, Geo.AS_GML_NODE, null);
                    }
                    spatialTriples.addIterator((Iterator)iter);
                });
            } else if (graph.contains(subject, SpatialExtension.GEO_LAT_NODE, null) && graph.contains(subject, SpatialExtension.GEO_LON_NODE, null)) {
                Node lat = G.getOneSP((Graph)graph, (Node)subject, (Node)SpatialExtension.GEO_LAT_NODE);
                Node lon = G.getOneSP((Graph)graph, (Node)subject, (Node)SpatialExtension.GEO_LON_NODE);
                Node latLonGeometryLiteral = ConvertLatLon.toNode(lat, lon);
                Triple triple2 = Triple.create((Node)subject, (Node)Geo.HAS_GEOMETRY_NODE, (Node)latLonGeometryLiteral);
                spatialTriples.addIterator(Arrays.asList(triple2).iterator());
            }
            boolean isMatched = false;
            while (spatialTriples.hasNext() && !(isMatched = this.checkSecondFilter(this.spatialArguments, targetGeometryWrapper = GeometryWrapper.extract(geometryLiteral = (triple = (Triple)spatialTriples.next()).getObject())))) {
            }
            return isMatched;
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected abstract boolean checkSecondFilter(SpatialArguments var1, GeometryWrapper var2);

    protected abstract boolean requireSecondFilter();

    private QueryIterator checkUnbound(Binding binding, ExecutionContext execCxt, Node subject, int limit) {
        if (limit < 0) {
            limit = Integer.MAX_VALUE;
        }
        SearchEnvelope searchEnvelope = this.spatialArguments.searchEnvelope;
        HashSet<Resource> features = searchEnvelope.check(this.spatialIndex);
        Var subjectVar = Var.alloc((String)subject.getName());
        Stream<Object> stream = features.stream();
        if (this.requireSecondFilter()) {
            stream = stream.filter(feature -> this.checkBound(execCxt, feature.asNode()));
        }
        Iterator iterator = stream.map(feature -> BindingFactory.binding((Binding)binding, (Var)subjectVar, (Node)feature.asNode())).limit(limit).iterator();
        return QueryIterPlainWrapper.create(iterator, (ExecutionContext)execCxt);
    }
}

