/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.atlas.logging.LogCtlJUL;
import org.apache.jena.geosparql.assembler.GeoAssembler;
import org.apache.jena.geosparql.assembler.VocabGeoSPARQL;
import org.apache.jena.geosparql.configuration.GeoSPARQLConfig;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sys.JenaSubsystemLifecycle;
import org.apache.jena.sys.JenaSystem;

public class InitGeoSPARQL
implements JenaSubsystemLifecycle {
    private static volatile boolean initialized = false;
    private static Object initLock = new Object();

    public void start() {
        InitGeoSPARQL.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (initialized || System.getProperty("jena.geosparql.skip", "false").equalsIgnoreCase("true")) {
                JenaSystem.logLifecycle((String)"InitGeoSPARQL - skip", (Object[])new Object[0]);
                return;
            }
            initialized = true;
            LogCtlJUL.routeJULtoSLF4J();
            JenaSystem.logLifecycle((String)"InitGeoSPARQL - start", (Object[])new Object[0]);
            GeometryDatatype.registerDatatypes();
            GeoSPARQLConfig.loadFunctions();
            GeoAssembler assembler = new GeoAssembler();
            AssemblerUtils.registerDataset((Resource)VocabGeoSPARQL.tGeoDataset, (Assembler)assembler);
            AssemblerUtils.registerDataset((Resource)VocabGeoSPARQL.tGeoDatasetAlt, (Assembler)assembler);
            JenaSystem.logLifecycle((String)"InitGeoSPARQL - finish", (Object[])new Object[0]);
        }
    }

    public void stop() {
    }

    public int level() {
        return 100;
    }
}

