/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.assembler;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.geosparql.assembler.VocabGeoSPARQL;
import org.apache.jena.geosparql.configuration.GeoSPARQLConfig;
import org.apache.jena.geosparql.configuration.GeoSPARQLOperations;
import org.apache.jena.geosparql.configuration.SrsException;
import org.apache.jena.geosparql.spatial.SpatialIndexConstants;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoAssembler
extends DatasetAssembler {
    private static Logger LOG = LoggerFactory.getLogger(GeoAssembler.class);

    public DatasetGraph createDataset(Assembler a, Resource root) {
        DatasetGraph base = super.createBaseDataset(root, VocabGeoSPARQL.pDataset);
        boolean inference = true;
        if (root.hasProperty(VocabGeoSPARQL.pInference)) {
            inference = GraphUtils.getBooleanValue((Resource)root, (Property)VocabGeoSPARQL.pInference);
        }
        boolean applyDefaultGeometry = false;
        if (root.hasProperty(VocabGeoSPARQL.pApplyDefaultGeometry)) {
            applyDefaultGeometry = GraphUtils.getBooleanValue((Resource)root, (Property)VocabGeoSPARQL.pApplyDefaultGeometry);
        }
        boolean queryRewrite = true;
        if (root.hasProperty(VocabGeoSPARQL.pQueryRewrite)) {
            queryRewrite = GraphUtils.getBooleanValue((Resource)root, (Property)VocabGeoSPARQL.pQueryRewrite);
        }
        boolean indexEnabled = true;
        if (root.hasProperty(VocabGeoSPARQL.pIndexEnabled)) {
            indexEnabled = GraphUtils.getBooleanValue((Resource)root, (Property)VocabGeoSPARQL.pIndexEnabled);
        }
        List<Integer> indexSizes = Arrays.asList(-1, -1, -1);
        if (root.hasProperty(VocabGeoSPARQL.pIndexSizes)) {
            indexSizes = GeoAssembler.getListInteger(root, VocabGeoSPARQL.pIndexSizes, 3);
        }
        List<Integer> indexExpiries = Arrays.asList(5000, 5000, 5000);
        if (root.hasProperty(VocabGeoSPARQL.pIndexExpiries)) {
            indexExpiries = GeoAssembler.getListInteger(root, VocabGeoSPARQL.pIndexSizes, 3);
        }
        String spatialIndexFilename = null;
        if (root.hasProperty(VocabGeoSPARQL.pSpatialIndexFile)) {
            spatialIndexFilename = GraphUtils.getStringValue((Resource)root, (Property)VocabGeoSPARQL.pSpatialIndexFile);
        }
        if (spatialIndexFilename == null) {
            LOG.warn(String.valueOf(root) + ": No spatial index file location is specified via " + String.valueOf(VocabGeoSPARQL.pSpatialIndexFile) + ". Spatial index will not be persisted.");
        }
        String srsURI = null;
        if (root.hasProperty(VocabGeoSPARQL.pSrsUri)) {
            srsURI = GraphUtils.getResourceValue((Resource)root, (Property)VocabGeoSPARQL.pSrsUri).getURI();
        }
        if (srsURI == null) {
            LOG.warn(String.valueOf(root) + ": No preferred SRS is configured via " + String.valueOf(VocabGeoSPARQL.pSrsUri));
        }
        Dataset dataset = DatasetFactory.wrap((DatasetGraph)base);
        dataset.getContext().set(SpatialIndexConstants.symSrsUri, (Object)srsURI);
        if (applyDefaultGeometry) {
            GeoSPARQLOperations.applyDefaultGeometry(dataset);
        }
        if (inference) {
            GeoSPARQLOperations.applyInferencing(dataset);
        }
        if (indexEnabled) {
            GeoSPARQLConfig.setupMemoryIndex(indexSizes.get(0), indexSizes.get(1), indexSizes.get(2), (long)indexExpiries.get(0), (long)indexExpiries.get(1), (long)indexExpiries.get(2), queryRewrite);
        } else {
            GeoSPARQLConfig.setupNoIndex(queryRewrite);
        }
        GeoAssembler.prepareSpatialExtension(dataset, spatialIndexFilename);
        return base;
    }

    private static List<Integer> getListInteger(Resource r, Property p, int len) {
        String integers = GraphUtils.getStringValue((Resource)r, (Property)p);
        String[] values = integers.split(",");
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        for (String val : values) {
            val = val.trim();
            integerList.add(Integer.parseInt(val));
        }
        if (len >= 0 && integerList.size() != len) {
            throw new JenaException("Expected list of exactly " + len + " integers");
        }
        return integerList;
    }

    private static void prepareSpatialExtension(Dataset dataset, String spatialIndex) {
        boolean isEmpty = (Boolean)dataset.calculateRead(() -> ((Dataset)dataset).isEmpty());
        if (isEmpty) {
            LOG.warn("Dataset is empty. Constructing an empty spatial index that needs to be updated once data is added.");
        }
        try {
            if (spatialIndex == null) {
                GeoSPARQLConfig.setupSpatialIndex(dataset);
                return;
            }
            Path spatialIndexPath = Path.of(spatialIndex, new String[0]);
            if (!Files.exists(spatialIndexPath, new LinkOption[0]) || Files.size(spatialIndexPath) == 0L) {
                GeoSPARQLConfig.setupSpatialIndex(dataset, spatialIndexPath);
                return;
            }
            GeoSPARQLConfig.setupPrecomputedSpatialIndex(dataset, spatialIndexPath);
        }
        catch (SrsException ex) {
            if (!ex.getMessage().startsWith("No SRS found")) {
                throw ex;
            }
            LOG.warn(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
            return;
        }
        catch (SpatialIndexException ex) {
            String msg = "Failed to create spatial index: " + ex.getMessage();
            LOG.error(msg, (Throwable)ex);
            throw new JenaException(msg, (Throwable)ex);
        }
    }
}

