/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.geof.nontopological.filter_functions;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.datatype.GeoJSONDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase1;
import org.locationtech.jts.io.geojson.GeoJsonWriter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class AsGeoJSONFF
extends FunctionBase1 {
    private final GeoJsonWriter writer = new GeoJsonWriter();

    public AsGeoJSONFF() {
        this.writer.setForceCCW(true);
        this.writer.setEncodeCRS(false);
    }

    public NodeValue exec(NodeValue v) {
        try {
            GeometryWrapper gw = GeometryWrapper.extract(v);
            GeometryWrapper convertedGeom = gw.transform("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
            String json = this.writer.write(convertedGeom.getParsingGeometry());
            Node node = NodeFactory.createLiteralByValue((Object)json, (RDFDatatype)GeoJSONDatatype.INSTANCE);
            NodeValue result = NodeValue.makeNode((Node)node);
            return result;
        }
        catch (MismatchedDimensionException | TransformException | FactoryException ex) {
            throw new ExprEvalException(ex.getMessage(), ex);
        }
    }
}

