/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.geof.topological;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.DimensionInfo;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.index.GeometryLiteralIndex;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase2;
import org.apache.jena.sparql.util.FmtUtils;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class GenericFilterFunction
extends FunctionBase2 {
    public NodeValue exec(NodeValue v1, NodeValue v2) {
        boolean result = this.exec(v1.asNode(), v2.asNode());
        return NodeValue.makeBoolean((boolean)result);
    }

    public Boolean exec(Node v1, Node v2) {
        try {
            GeometryWrapper geometry1 = GeometryWrapper.extract(v1, GeometryLiteralIndex.GeometryIndex.PRIMARY);
            if (geometry1.isEmpty()) {
                return Boolean.FALSE;
            }
            GeometryWrapper geometry2 = GeometryWrapper.extract(v2, GeometryLiteralIndex.GeometryIndex.SECONDARY);
            if (geometry2.isEmpty()) {
                return Boolean.FALSE;
            }
            if (!this.permittedTopology(geometry1.getDimensionInfo(), geometry2.getDimensionInfo())) {
                return Boolean.FALSE;
            }
            boolean result = this.relate(geometry1, geometry2);
            return result;
        }
        catch (DatatypeFormatException | MismatchedDimensionException | TransformException | FactoryException ex) {
            throw new ExprEvalException(ex.getMessage() + ": " + FmtUtils.stringForNode((Node)v1) + ", " + FmtUtils.stringForNode((Node)v2), ex);
        }
    }

    protected abstract boolean permittedTopology(DimensionInfo var1, DimensionInfo var2);

    protected abstract boolean relate(GeometryWrapper var1, GeometryWrapper var2) throws FactoryException, MismatchedDimensionException, TransformException;

    public abstract boolean isDisjoint();

    public abstract boolean isDisconnected();
}

