/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation;

import java.io.Serializable;
import java.util.Objects;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.geosparql.configuration.GeoSPARQLConfig;
import org.apache.jena.geosparql.implementation.DimensionInfo;
import org.apache.jena.geosparql.implementation.GeometryReverse;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.implementation.UnitsConversionException;
import org.apache.jena.geosparql.implementation.UnitsOfMeasure;
import org.apache.jena.geosparql.implementation.datatype.GMLDatatype;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;
import org.apache.jena.geosparql.implementation.datatype.WKTDatatype;
import org.apache.jena.geosparql.implementation.great_circle.CoordinatePair;
import org.apache.jena.geosparql.implementation.great_circle.GreatCircleDistance;
import org.apache.jena.geosparql.implementation.index.GeometryLiteralIndex;
import org.apache.jena.geosparql.implementation.index.GeometryTransformIndex;
import org.apache.jena.geosparql.implementation.jts.CoordinateSequenceDimensions;
import org.apache.jena.geosparql.implementation.jts.CustomCoordinateSequence;
import org.apache.jena.geosparql.implementation.jts.CustomGeometryFactory;
import org.apache.jena.geosparql.implementation.registry.MathTransformRegistry;
import org.apache.jena.geosparql.implementation.registry.SRSRegistry;
import org.apache.jena.geosparql.implementation.registry.UnitsRegistry;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.sis.geometry.DirectPosition2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GeometryWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DimensionInfo dimensionInfo;
    private final SRSInfo srsInfo;
    private final Geometry xyGeometry;
    private final Geometry parsingGeometry;
    private PreparedGeometry preparedGeometry;
    private Envelope envelope;
    private Geometry translateXYGeometry;
    private final String geometryDatatypeURI;
    private GeometryDatatype geometryDatatype;
    private String lexicalForm;
    private String utmURI = null;
    private Double latitude = null;

    public GeometryWrapper(Geometry geometry, String srsURI, String geometryDatatypeURI, DimensionInfo dimensionInfo) {
        this(geometry, srsURI, geometryDatatypeURI, dimensionInfo, null);
    }

    public GeometryWrapper(Geometry geometry, String srsURI, String geometryDatatypeURI, DimensionInfo dimensionInfo, String geometryLiteral) {
        this(geometry, GeometryReverse.check(geometry, srsURI.isEmpty() ? "http://www.opengis.net/def/crs/OGC/1.3/CRS84" : srsURI), srsURI.isEmpty() ? "http://www.opengis.net/def/crs/OGC/1.3/CRS84" : srsURI, geometryDatatypeURI, dimensionInfo, geometryLiteral);
    }

    protected GeometryWrapper(Geometry parsingGeometry, Geometry xyGeometry, String srsURI, String geometryDatatypeURI, DimensionInfo dimensionInfo) {
        this(parsingGeometry, xyGeometry, srsURI, geometryDatatypeURI, dimensionInfo, null);
    }

    protected GeometryWrapper(Geometry parsingGeometry, Geometry xyGeometry, String srsURI, String geometryDatatypeURI, DimensionInfo dimensionInfo, String lexicalForm) {
        this.parsingGeometry = parsingGeometry;
        this.xyGeometry = xyGeometry;
        this.preparedGeometry = null;
        this.envelope = null;
        this.translateXYGeometry = null;
        this.geometryDatatypeURI = geometryDatatypeURI;
        this.geometryDatatype = null;
        if (srsURI.isEmpty()) {
            srsURI = "http://www.opengis.net/def/crs/OGC/1.3/CRS84";
        }
        this.srsInfo = SRSRegistry.getSRSInfo(srsURI);
        this.dimensionInfo = dimensionInfo;
        this.lexicalForm = lexicalForm;
    }

    public GeometryWrapper(Geometry geometry, String geometryDatatypeURI) {
        this(geometry, "", geometryDatatypeURI, DimensionInfo.XY_POINT);
    }

    public GeometryWrapper(Geometry geometry, String srsURI, String geometryDatatypeURI) {
        this(geometry, srsURI, geometryDatatypeURI, DimensionInfo.XY_POINT);
    }

    public GeometryWrapper(String srsURI, String geometryDatatypeURI) {
        this(new CustomCoordinateSequence(DimensionInfo.XY_POINT.getDimensions()), geometryDatatypeURI, srsURI);
    }

    public GeometryWrapper(CustomCoordinateSequence pointCoordinateSequence, String geometryDatatypeURI, String srsURI) {
        this((Geometry)CustomGeometryFactory.theInstance().createPoint((CoordinateSequence)pointCoordinateSequence), srsURI, geometryDatatypeURI, DimensionInfo.XY_POINT);
    }

    public GeometryWrapper(GeometryWrapper geometryWrapper) {
        this.xyGeometry = geometryWrapper.xyGeometry;
        this.parsingGeometry = geometryWrapper.parsingGeometry;
        this.preparedGeometry = geometryWrapper.preparedGeometry;
        this.envelope = geometryWrapper.envelope;
        this.translateXYGeometry = geometryWrapper.translateXYGeometry;
        this.utmURI = geometryWrapper.utmURI;
        this.latitude = geometryWrapper.latitude;
        this.geometryDatatypeURI = geometryWrapper.geometryDatatypeURI;
        this.geometryDatatype = geometryWrapper.geometryDatatype;
        this.srsInfo = geometryWrapper.srsInfo;
        this.dimensionInfo = geometryWrapper.dimensionInfo;
        this.lexicalForm = geometryWrapper.lexicalForm;
    }

    public GeometryWrapper checkTransformSRS(GeometryWrapper targetGeometryWrapper) throws FactoryException, MismatchedDimensionException, TransformException {
        GeometryWrapper transformedGeometryWrapper;
        String srsURI = this.srsInfo.getSrsURI();
        if (srsURI.equals(targetGeometryWrapper.srsInfo.getSrsURI())) {
            transformedGeometryWrapper = targetGeometryWrapper;
        } else {
            if (!GeoSPARQLConfig.ALLOW_GEOMETRY_SRS_TRANSFORMATION) {
                throw new TransformException("GeometryLiteral SRS transformation is disabled, see GeoSPARQLConfig.allowGeometrySRSTransformation(...).");
            }
            transformedGeometryWrapper = targetGeometryWrapper.transform(srsURI);
        }
        return transformedGeometryWrapper;
    }

    public GeometryWrapper transform(String srsURI) throws MismatchedDimensionException, TransformException, FactoryException {
        return this.transform(srsURI, true);
    }

    public GeometryWrapper transform(SRSInfo srsInfo) throws MismatchedDimensionException, TransformException, FactoryException {
        return this.transform(srsInfo.getSrsURI(), true);
    }

    protected GeometryWrapper transform(String srsURI, Boolean storeSRSTransform) throws MismatchedDimensionException, TransformException, FactoryException {
        if (this.srsInfo.getSrsURI().equals(srsURI)) {
            return this;
        }
        return GeometryTransformIndex.transform(this, srsURI, storeSRSTransform);
    }

    private void checkPreparedGeometry() {
        if (this.preparedGeometry == null) {
            this.preparedGeometry = PreparedGeometryFactory.prepare((Geometry)this.xyGeometry);
        }
    }

    public GeometryWrapper convertSRS(String srsURI) throws FactoryException, MismatchedDimensionException, TransformException {
        return this.transform(srsURI);
    }

    public CoordinateReferenceSystem getCRS() {
        return this.srsInfo.getCrs();
    }

    public Geometry getXYGeometry() {
        return this.xyGeometry;
    }

    public Geometry getParsingGeometry() {
        return this.parsingGeometry;
    }

    public Geometry translateXYGeometry() {
        if (this.translateXYGeometry == null) {
            if (this.srsInfo.isGeographic().booleanValue()) {
                double xTranslate = this.srsInfo.getDomainRangeX();
                AffineTransformation translation = AffineTransformation.translationInstance((double)xTranslate, (double)0.0);
                this.translateXYGeometry = translation.transform(this.xyGeometry);
            } else {
                this.translateXYGeometry = this.xyGeometry;
            }
        }
        return this.translateXYGeometry;
    }

    public String getSrsURI() {
        return this.srsInfo.getSrsURI();
    }

    public String getSRID() {
        return this.srsInfo.getSrsURI();
    }

    public SRSInfo getSrsInfo() {
        return this.srsInfo;
    }

    public Boolean isSRSRecognised() {
        return this.srsInfo.isSRSRecognised();
    }

    public String getGeometryDatatypeURI() {
        return this.geometryDatatypeURI;
    }

    public String getGeometryType() {
        return this.parsingGeometry.getGeometryType();
    }

    public GeometryDatatype getGeometryDatatype() {
        if (this.geometryDatatype == null) {
            this.geometryDatatype = GeometryDatatype.get(this.geometryDatatypeURI);
        }
        return this.geometryDatatype;
    }

    public GeometryWrapper buffer(double distance, String targetDistanceUnitsURI) throws FactoryException, MismatchedDimensionException, TransformException, UnitsConversionException {
        Boolean isTargetUnitsLinear = UnitsRegistry.isLinearUnits(targetDistanceUnitsURI);
        if (this.srsInfo.getUnitsOfMeasure().isLinearUnits() != isTargetUnitsLinear.booleanValue()) {
            throw new UnitsConversionException("Buffer does not support conversion between linear and non-linear units.");
        }
        double transformedDistance = UnitsOfMeasure.conversion(distance, targetDistanceUnitsURI, this.srsInfo.getUnitsOfMeasure().getUnitURI());
        Geometry xyGeo = this.xyGeometry.buffer(transformedDistance);
        DimensionInfo bufferedDimensionInfo = new DimensionInfo(this.dimensionInfo.getCoordinate(), this.dimensionInfo.getSpatial(), xyGeo.getDimension());
        Geometry parsingGeo = GeometryReverse.check(xyGeo, this.srsInfo);
        return new GeometryWrapper(parsingGeo, xyGeo, this.srsInfo.getSrsURI(), this.geometryDatatypeURI, bufferedDimensionInfo);
    }

    public String getUTMZoneURI() throws FactoryException, MismatchedDimensionException, TransformException {
        if (this.utmURI == null) {
            Point coord = this.parsingGeometry.getCentroid();
            DirectPosition2D point = new DirectPosition2D(coord.getX(), coord.getY());
            CoordinateReferenceSystem wgs84CRS = SRSRegistry.getCRS("http://www.opengis.net/def/crs/EPSG/0/4326");
            MathTransform transform = MathTransformRegistry.getMathTransform(this.srsInfo.getCrs(), wgs84CRS);
            DirectPosition wgs84Point = transform.transform((DirectPosition)point, null);
            this.utmURI = SRSRegistry.findUTMZoneURIFromWGS84(wgs84Point.getOrdinate(0), wgs84Point.getOrdinate(1));
        }
        return this.utmURI;
    }

    public Double getLatitude() throws FactoryException, MismatchedDimensionException, TransformException {
        if (this.latitude == null) {
            GeometryWrapper geoGeometryWrapper = this.srsInfo.isGeographic() != false ? this : this.convertSRS("http://www.opengis.net/def/crs/EPSG/0/4326");
            Geometry geometry = geoGeometryWrapper.getXYGeometry();
            Point point = geometry.getCentroid();
            this.latitude = point.getY();
        }
        return this.latitude;
    }

    public double distanceEuclidean(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException, UnitsConversionException {
        return this.distanceEuclidean(targetGeometry, "http://www.opengis.net/def/uom/OGC/1.0/metre");
    }

    public double distanceEuclidean(GeometryWrapper targetGeometry, UnitsOfMeasure unitsOfMeasure) throws FactoryException, MismatchedDimensionException, TransformException, UnitsConversionException {
        return this.distanceEuclidean(targetGeometry, unitsOfMeasure.getUnitURI());
    }

    public double distanceEuclidean(GeometryWrapper targetGeometry, String targetDistanceUnitsURI) throws FactoryException, MismatchedDimensionException, TransformException, UnitsConversionException {
        GeometryWrapper transformedTargetGeometry = this.checkTransformSRS(targetGeometry);
        double distance = this.xyGeometry.distance(transformedTargetGeometry.xyGeometry);
        String unitsURI = this.srsInfo.getUnitsOfMeasure().getUnitURI();
        return UnitsOfMeasure.conversion(distance, unitsURI, targetDistanceUnitsURI);
    }

    public double distanceGreatCircle(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException, UnitsConversionException {
        return this.distanceGreatCircle(targetGeometry, "http://www.opengis.net/def/uom/OGC/1.0/metre");
    }

    public double distanceGreatCircle(GeometryWrapper targetGeometry, UnitsOfMeasure unitsOfMeasure) throws FactoryException, MismatchedDimensionException, TransformException, UnitsConversionException {
        return this.distanceGreatCircle(targetGeometry, unitsOfMeasure.getUnitURI());
    }

    public double distanceGreatCircle(GeometryWrapper targetGeometry, String targetDistanceUnitsURI) throws FactoryException, MismatchedDimensionException, TransformException, UnitsConversionException {
        GeometryWrapper transformedSourceGeometry;
        if (!UnitsRegistry.isLinearUnits(targetDistanceUnitsURI).booleanValue()) {
            throw new UnitsConversionException("Great Circle distance units are metres and only linear conversion supported.");
        }
        if (this.srsInfo.isGeographic().booleanValue()) {
            transformedSourceGeometry = this;
        } else {
            if (!GeoSPARQLConfig.ALLOW_GEOMETRY_SRS_TRANSFORMATION) {
                throw new TransformException("GeometryLiteral SRS transformation is disabled, see GeoSPARQLConfig.allowGeometrySRSTransformation(...).");
            }
            transformedSourceGeometry = this.transform("http://www.opengis.net/def/crs/EPSG/0/4326");
        }
        GeometryWrapper transformedTargetGeometry = transformedSourceGeometry.checkTransformSRS(targetGeometry);
        CoordinatePair coordinatePair = CoordinatePair.findNearestPair(transformedSourceGeometry, transformedTargetGeometry);
        if (coordinatePair.isEqual()) {
            return 0.0;
        }
        Coordinate coord1 = coordinatePair.getCoord1();
        Coordinate coord2 = coordinatePair.getCoord2();
        double distance = GreatCircleDistance.haversineFormula(coord1.getY(), coord1.getX(), coord2.getY(), coord2.getX());
        return UnitsOfMeasure.conversion(distance, "http://www.opengis.net/def/uom/OGC/1.0/metre", targetDistanceUnitsURI);
    }

    public double distance(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException, UnitsConversionException {
        return this.distance(targetGeometry, "http://www.opengis.net/def/uom/OGC/1.0/metre");
    }

    public double distance(GeometryWrapper targetGeometry, UnitsOfMeasure unitsOfMeasure) throws FactoryException, MismatchedDimensionException, TransformException, UnitsConversionException {
        return this.distance(targetGeometry, unitsOfMeasure.getUnitURI());
    }

    public double distance(GeometryWrapper targetGeometry, String targetDistanceUnitsURI) throws FactoryException, MismatchedDimensionException, TransformException, UnitsConversionException {
        double targetDistance = this.srsInfo.isGeographic() != false ? this.distanceGreatCircle(targetGeometry, targetDistanceUnitsURI) : this.distanceEuclidean(targetGeometry, targetDistanceUnitsURI);
        return targetDistance;
    }

    public GeometryWrapper boundary() {
        Geometry xyGeo = this.xyGeometry.getBoundary();
        Geometry parsingGeo = GeometryReverse.check(xyGeo, this.srsInfo);
        return new GeometryWrapper(parsingGeo, xyGeo, this.srsInfo.getSrsURI(), this.geometryDatatypeURI, this.dimensionInfo);
    }

    public GeometryWrapper convexHull() {
        Geometry xyGeo = this.xyGeometry.convexHull();
        Geometry parsingGeo = GeometryReverse.check(xyGeo, this.srsInfo);
        return new GeometryWrapper(parsingGeo, xyGeo, this.srsInfo.getSrsURI(), this.geometryDatatypeURI, this.dimensionInfo);
    }

    public GeometryWrapper difference(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        Geometry xyGeo = this.xyGeometry.difference(transformedGeometry.xyGeometry);
        Geometry parsingGeo = GeometryReverse.check(xyGeo, this.srsInfo);
        return new GeometryWrapper(parsingGeo, xyGeo, this.srsInfo.getSrsURI(), this.geometryDatatypeURI, this.dimensionInfo);
    }

    public GeometryWrapper envelope() {
        GeometryFactory geometryFactory = this.xyGeometry.getFactory();
        Envelope xyEnvelope = this.getEnvelope();
        Geometry xyGeo = geometryFactory.toGeometry(xyEnvelope);
        Geometry parsingGeo = GeometryReverse.check(xyGeo, this.srsInfo);
        return new GeometryWrapper(parsingGeo, xyGeo, this.srsInfo.getSrsURI(), this.geometryDatatypeURI, this.dimensionInfo);
    }

    public Envelope getEnvelope() {
        if (this.envelope == null) {
            this.envelope = this.xyGeometry.getEnvelopeInternal();
        }
        return this.envelope;
    }

    public GeometryWrapper intersection(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        Geometry xyGeo = this.xyGeometry.intersection(transformedGeometry.xyGeometry);
        Geometry parsingGeo = GeometryReverse.check(xyGeo, this.srsInfo);
        return new GeometryWrapper(parsingGeo, xyGeo, this.srsInfo.getSrsURI(), this.geometryDatatypeURI, this.dimensionInfo);
    }

    public IntersectionMatrix relate(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        return this.xyGeometry.relate(transformedGeometry.xyGeometry);
    }

    public boolean relate(GeometryWrapper targetGeometry, String intersectionPattern) throws FactoryException, MismatchedDimensionException, TransformException {
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        return this.xyGeometry.relate(transformedGeometry.xyGeometry, intersectionPattern);
    }

    public GeometryWrapper symDifference(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        Geometry xyGeo = this.xyGeometry.symDifference(transformedGeometry.xyGeometry);
        Geometry parsingGeo = GeometryReverse.check(xyGeo, this.srsInfo);
        return new GeometryWrapper(parsingGeo, xyGeo, this.srsInfo.getSrsURI(), this.geometryDatatypeURI, this.dimensionInfo, null);
    }

    public GeometryWrapper union(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        Geometry xyGeo = this.xyGeometry.union(transformedGeometry.xyGeometry);
        Geometry parsingGeo = GeometryReverse.check(xyGeo, this.srsInfo);
        return new GeometryWrapper(parsingGeo, xyGeo, this.srsInfo.getSrsURI(), this.geometryDatatypeURI, this.dimensionInfo, null);
    }

    public boolean contains(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        this.checkPreparedGeometry();
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        return this.preparedGeometry.contains(transformedGeometry.xyGeometry);
    }

    public boolean crosses(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        this.checkPreparedGeometry();
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        return this.preparedGeometry.crosses(transformedGeometry.xyGeometry);
    }

    public boolean disjoint(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        this.checkPreparedGeometry();
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        return this.preparedGeometry.disjoint(transformedGeometry.xyGeometry);
    }

    public boolean equalsTopo(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        return this.xyGeometry.equalsTopo(transformedGeometry.xyGeometry);
    }

    public boolean equalsExact(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        return this.xyGeometry.equalsExact(transformedGeometry.xyGeometry);
    }

    public boolean equalsExact(GeometryWrapper targetGeometry, double tolerance) throws FactoryException, MismatchedDimensionException, TransformException {
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        return this.xyGeometry.equalsExact(transformedGeometry.xyGeometry, tolerance);
    }

    public boolean intersects(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        this.checkPreparedGeometry();
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        return this.preparedGeometry.intersects(transformedGeometry.xyGeometry);
    }

    public boolean overlaps(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        this.checkPreparedGeometry();
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        return this.preparedGeometry.overlaps(transformedGeometry.xyGeometry);
    }

    public boolean touches(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        this.checkPreparedGeometry();
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        return this.preparedGeometry.touches(transformedGeometry.xyGeometry);
    }

    public boolean within(GeometryWrapper targetGeometry) throws FactoryException, MismatchedDimensionException, TransformException {
        this.checkPreparedGeometry();
        GeometryWrapper transformedGeometry = this.checkTransformSRS(targetGeometry);
        return this.preparedGeometry.within(transformedGeometry.xyGeometry);
    }

    public NodeValue asNodeValue() throws DatatypeFormatException {
        Literal literal = this.asLiteral();
        return NodeValue.makeNode((String)literal.getLexicalForm(), (RDFDatatype)literal.getDatatype());
    }

    public Node asNode() throws DatatypeFormatException {
        return this.asNodeValue().asNode();
    }

    public Literal asLiteral() throws DatatypeFormatException {
        GeometryDatatype datatype = this.getGeometryDatatype();
        if (this.lexicalForm != null) {
            return ResourceFactory.createTypedLiteral((String)this.lexicalForm, (RDFDatatype)datatype);
        }
        Literal literal = this.asLiteral(datatype);
        this.lexicalForm = literal.getLexicalForm();
        return literal;
    }

    public Literal asLiteral(String outputGeometryDatatypeURI) throws DatatypeFormatException {
        GeometryDatatype datatype = GeometryDatatype.get(outputGeometryDatatypeURI);
        return this.asLiteral(datatype);
    }

    public Literal asLiteral(GeometryDatatype datatype) {
        String tempLexicalForm = datatype.unparse(this);
        return ResourceFactory.createTypedLiteral((String)tempLexicalForm, (RDFDatatype)datatype);
    }

    public int getCoordinateDimension() {
        return this.dimensionInfo.getCoordinate();
    }

    public int getSpatialDimension() {
        return this.dimensionInfo.getSpatial();
    }

    public int getTopologicalDimension() {
        return this.dimensionInfo.getTopological();
    }

    public CoordinateSequenceDimensions getCoordinateSequenceDimensions() {
        return this.dimensionInfo.getDimensions();
    }

    public UnitsOfMeasure getUnitsOfMeasure() {
        return this.srsInfo.getUnitsOfMeasure();
    }

    public DimensionInfo getDimensionInfo() {
        return this.dimensionInfo;
    }

    public String getLexicalForm() {
        if (this.lexicalForm != null) {
            return this.lexicalForm;
        }
        Literal literal = this.asLiteral();
        return literal.getLexicalForm();
    }

    public boolean isEmpty() {
        return this.xyGeometry.isEmpty();
    }

    public boolean isSimple() {
        return this.xyGeometry.isSimple();
    }

    public boolean isValid() {
        return this.xyGeometry.isValid();
    }

    public static final GeometryWrapper extract(NodeValue geometryLiteral, GeometryLiteralIndex.GeometryIndex targetIndex) {
        Node node = geometryLiteral.asNode();
        return GeometryWrapper.extract(node, targetIndex);
    }

    public static final GeometryWrapper extract(Node geometryLiteral, GeometryLiteralIndex.GeometryIndex targetIndex) throws DatatypeFormatException {
        if (!geometryLiteral.isLiteral()) {
            throw new DatatypeFormatException("Not a Literal: " + String.valueOf(geometryLiteral));
        }
        String datatypeURI = geometryLiteral.getLiteralDatatypeURI();
        String lexicalForm = geometryLiteral.getLiteralLexicalForm();
        return GeometryWrapper.extract(lexicalForm, datatypeURI, targetIndex);
    }

    public static final GeometryWrapper extract(NodeValue geometryLiteral) {
        return GeometryWrapper.extract(geometryLiteral, GeometryLiteralIndex.GeometryIndex.PRIMARY);
    }

    public static final GeometryWrapper extract(Node geometryLiteral) {
        return GeometryWrapper.extract(geometryLiteral, GeometryLiteralIndex.GeometryIndex.PRIMARY);
    }

    public static final GeometryWrapper extract(Literal geometryLiteral, GeometryLiteralIndex.GeometryIndex targetIndex) {
        return GeometryWrapper.extract(geometryLiteral.getLexicalForm(), geometryLiteral.getDatatypeURI(), targetIndex);
    }

    public static final GeometryWrapper extract(Literal geometryLiteral) {
        return GeometryWrapper.extract(geometryLiteral, GeometryLiteralIndex.GeometryIndex.PRIMARY);
    }

    public static GeometryWrapper extract(String lexicalForm, String datatypeURI) {
        return GeometryWrapper.extract(lexicalForm, datatypeURI, GeometryLiteralIndex.GeometryIndex.PRIMARY);
    }

    public static GeometryWrapper extract(String lexicalForm, String datatypeURI, GeometryLiteralIndex.GeometryIndex targetIndex) throws DatatypeFormatException {
        if (lexicalForm == null || datatypeURI == null) {
            throw new DatatypeFormatException("GeometryWrapper extraction: arguments cannot be null - " + lexicalForm + ", " + datatypeURI);
        }
        GeometryDatatype datatype = GeometryDatatype.get(datatypeURI);
        GeometryWrapper geometry = datatype.parse(lexicalForm, targetIndex);
        return geometry;
    }

    public static final GeometryWrapper fromPoint(double x, double y, String srsURI) {
        CustomCoordinateSequence coordSequence = CustomCoordinateSequence.createPoint(x, y);
        GeometryWrapper geometryWrapper = new GeometryWrapper(coordSequence, "http://www.opengis.net/ont/geosparql#wktLiteral", srsURI);
        return geometryWrapper;
    }

    public static final GeometryWrapper getEmptyWKT() {
        return WKTDatatype.INSTANCE.read("");
    }

    public static final GeometryWrapper getEmptyGML() {
        return GMLDatatype.INSTANCE.read("");
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(this.dimensionInfo);
        hash = 23 * hash + Objects.hashCode(this.srsInfo);
        hash = 23 * hash + Objects.hashCode(this.xyGeometry);
        hash = 23 * hash + Objects.hashCode(this.geometryDatatypeURI);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeometryWrapper other = (GeometryWrapper)obj;
        if (!Objects.equals(this.geometryDatatypeURI, other.geometryDatatypeURI)) {
            return false;
        }
        if (!Objects.equals(this.dimensionInfo, other.dimensionInfo)) {
            return false;
        }
        if (!Objects.equals(this.srsInfo, other.srsInfo)) {
            return false;
        }
        return Objects.equals(this.xyGeometry, other.xyGeometry);
    }

    public String toString() {
        return "GeometryWrapper{dimensionInfo=" + String.valueOf(this.dimensionInfo) + ", geometryDatatypeURI=" + this.geometryDatatypeURI + ", lexicalForm=" + this.lexicalForm + ", utmURI=" + this.utmURI + ", latitude=" + this.latitude + ", xyGeometry=" + String.valueOf(this.xyGeometry) + ", parsingGeometry=" + String.valueOf(this.parsingGeometry) + ", preparedGeometry=" + String.valueOf(this.preparedGeometry) + ", srsInfo=" + String.valueOf(this.srsInfo) + "}";
    }
}

