/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.jena.geosparql.implementation.SRSInfoException;
import org.apache.jena.geosparql.implementation.UnitsOfMeasure;
import org.apache.sis.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.util.FactoryException;

public class SRSInfo {
    private final String srsURI;
    private final CoordinateReferenceSystem crs;
    private final UnitsOfMeasure unitsOfMeasure;
    private final Boolean isAxisXY;
    private final Boolean isGeographic;
    private final Boolean isSRSRecognised;
    private final Boolean isWktDefault;
    private final org.locationtech.jts.geom.Envelope domainEnvelope;
    private final double domainRangeX;
    public static final String DEFAULT_WKT_CRS84_CODE = "CRS:84";
    public static final SRSInfo DEFAULT_WKT_CRS84 = SRSInfo.getDefaultWktCRS84("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
    private static final List<AxisDirection> OTHER_Y_AXIS_DIRECTIONS = Arrays.asList(AxisDirection.NORTH_EAST, AxisDirection.NORTH_WEST, AxisDirection.SOUTH_EAST, AxisDirection.SOUTH_WEST, AxisDirection.NORTH_NORTH_EAST, AxisDirection.NORTH_NORTH_WEST, AxisDirection.SOUTH_SOUTH_EAST, AxisDirection.SOUTH_SOUTH_WEST);

    public SRSInfo(String srsURI) throws SRSInfoException {
        this.srsURI = srsURI;
        try {
            this.crs = CRS.forCode((String)srsURI);
            this.isAxisXY = SRSInfo.checkAxisXY(this.crs);
            this.unitsOfMeasure = new UnitsOfMeasure(this.crs);
            this.isSRSRecognised = true;
            this.isGeographic = this.crs instanceof GeographicCRS;
            this.isWktDefault = srsURI.equals("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
            this.domainEnvelope = SRSInfo.buildDomainEnvelope(this.crs, this.isAxisXY);
            this.domainRangeX = Math.abs(this.domainEnvelope.getMinX()) + Math.abs(this.domainEnvelope.getMaxX());
        }
        catch (FactoryException ex) {
            throw new SRSInfoException("Unrecognised SRS URI code: " + srsURI + " - " + ex.getMessage(), ex);
        }
    }

    public SRSInfo(int srid) throws SRSInfoException {
        this(SRSInfo.convertSRID(srid));
    }

    private SRSInfo(String srsURI, CoordinateReferenceSystem crs, boolean isSRSRecognised) {
        this.srsURI = srsURI;
        this.crs = crs;
        this.isAxisXY = SRSInfo.checkAxisXY(crs);
        this.unitsOfMeasure = new UnitsOfMeasure(crs);
        this.isSRSRecognised = isSRSRecognised;
        this.isGeographic = crs instanceof GeographicCRS;
        this.isWktDefault = srsURI.equals("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
        this.domainEnvelope = SRSInfo.buildDomainEnvelope(crs, this.isAxisXY);
        this.domainRangeX = Math.abs(this.domainEnvelope.getMinX()) + Math.abs(this.domainEnvelope.getMaxX());
    }

    public static final Boolean checkAxisXY(CoordinateReferenceSystem crs) {
        AxisDirection axisDirection = crs.getCoordinateSystem().getAxis(0).getDirection();
        if (axisDirection.equals((Object)AxisDirection.NORTH) || axisDirection.equals((Object)AxisDirection.SOUTH)) {
            return false;
        }
        if (axisDirection.equals((Object)AxisDirection.EAST) || axisDirection.equals((Object)AxisDirection.WEST)) {
            return true;
        }
        return !OTHER_Y_AXIS_DIRECTIONS.contains(axisDirection);
    }

    public static final org.locationtech.jts.geom.Envelope buildDomainEnvelope(CoordinateReferenceSystem crs, Boolean isAxisXY) {
        int yAxis;
        int xAxis;
        Envelope crsDomain = CRS.getDomainOfValidity((CoordinateReferenceSystem)crs);
        DirectPosition lowerCorner = crsDomain.getLowerCorner();
        DirectPosition upperCorner = crsDomain.getUpperCorner();
        if (isAxisXY.booleanValue()) {
            xAxis = 0;
            yAxis = 1;
        } else {
            xAxis = 1;
            yAxis = 0;
        }
        double x1 = lowerCorner.getOrdinate(xAxis);
        double y1 = lowerCorner.getOrdinate(yAxis);
        double x2 = upperCorner.getOrdinate(xAxis);
        double y2 = upperCorner.getOrdinate(yAxis);
        org.locationtech.jts.geom.Envelope envelope = new org.locationtech.jts.geom.Envelope(x1, x2, y1, y2);
        return envelope;
    }

    public static final String convertSRID(BigInteger srid) {
        return SRSInfo.convertSRID(srid.intValue());
    }

    public static final String convertSRID(int srid) {
        return "http://www.opengis.net/def/crs/EPSG/0/" + srid;
    }

    public String getSrsURI() {
        return this.srsURI;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public UnitsOfMeasure getUnitsOfMeasure() {
        return this.unitsOfMeasure;
    }

    public Boolean isAxisXY() {
        return this.isAxisXY;
    }

    public Boolean isSRSRecognised() {
        return this.isSRSRecognised;
    }

    public Boolean isGeographic() {
        return this.isGeographic;
    }

    public Boolean isWktDefault() {
        return this.isWktDefault;
    }

    public org.locationtech.jts.geom.Envelope getDomainEnvelope() {
        return this.domainEnvelope;
    }

    public double getDomainRangeX() {
        return this.domainRangeX;
    }

    public static final SRSInfo getDefaultWktCRS84(String srsURI) throws SRSInfoException {
        try {
            CoordinateReferenceSystem crs = CRS.forCode((String)DEFAULT_WKT_CRS84_CODE);
            return new SRSInfo(srsURI, crs, true);
        }
        catch (FactoryException ex) {
            throw new SRSInfoException("Unrecognised SRS code: CRS:84 - " + ex.getMessage(), ex);
        }
    }

    public static final SRSInfo getUnrecognised(String srsURI) throws SRSInfoException {
        try {
            CoordinateReferenceSystem crs = CRS.forCode((String)DEFAULT_WKT_CRS84_CODE);
            return new SRSInfo(srsURI, crs, false);
        }
        catch (FactoryException ex) {
            throw new SRSInfoException("Unrecognised SRS URI code: " + srsURI + " - " + ex.getMessage(), ex);
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.srsURI);
        hash = 59 * hash + Objects.hashCode(this.crs);
        hash = 59 * hash + Objects.hashCode(this.unitsOfMeasure);
        hash = 59 * hash + Objects.hashCode(this.isAxisXY);
        hash = 59 * hash + Objects.hashCode(this.isGeographic);
        hash = 59 * hash + Objects.hashCode(this.isSRSRecognised);
        hash = 59 * hash + Objects.hashCode(this.isWktDefault);
        hash = 59 * hash + Objects.hashCode(this.domainEnvelope);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.domainRangeX) ^ Double.doubleToLongBits(this.domainRangeX) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SRSInfo other = (SRSInfo)obj;
        if (Double.doubleToLongBits(this.domainRangeX) != Double.doubleToLongBits(other.domainRangeX)) {
            return false;
        }
        if (!Objects.equals(this.srsURI, other.srsURI)) {
            return false;
        }
        if (!Objects.equals(this.crs, other.crs)) {
            return false;
        }
        if (!Objects.equals(this.unitsOfMeasure, other.unitsOfMeasure)) {
            return false;
        }
        if (!Objects.equals(this.isAxisXY, other.isAxisXY)) {
            return false;
        }
        if (!Objects.equals(this.isGeographic, other.isGeographic)) {
            return false;
        }
        if (!Objects.equals(this.isSRSRecognised, other.isSRSRecognised)) {
            return false;
        }
        if (!Objects.equals(this.isWktDefault, other.isWktDefault)) {
            return false;
        }
        return Objects.equals(this.domainEnvelope, other.domainEnvelope);
    }

    public String toString() {
        return "SRSInfo{srsURI=" + this.srsURI + ", crs=" + String.valueOf(this.crs) + ", unitsOfMeasure=" + String.valueOf(this.unitsOfMeasure) + ", isAxisXY=" + this.isAxisXY + ", isGeographic=" + this.isGeographic + ", isSRSRecognised=" + this.isSRSRecognised + ", isWktDefault=" + this.isWktDefault + ", domainEnvelope=" + String.valueOf(this.domainEnvelope) + ", domainRangeX=" + this.domainRangeX + "}";
    }
}

