/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation;

import java.io.Serializable;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.jena.geosparql.configuration.GeoSPARQLOperations;
import org.apache.jena.geosparql.implementation.UnitsConversionException;
import org.apache.jena.geosparql.implementation.registry.UnitsRegistry;
import org.apache.sis.measure.Quantities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class UnitsOfMeasure
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Unit<Length> unit;
    private final String unitURI;
    private final boolean isLinearUnits;
    public static final UnitsOfMeasure METRE_UNITS = new UnitsOfMeasure("http://www.opengis.net/def/uom/OGC/1.0/metre");
    public static final UnitsOfMeasure DEGREE_UNITS = new UnitsOfMeasure("http://www.opengis.net/def/uom/OGC/1.0/degree");
    public static final double EQUATORIAL_DEGREE_TO_METRES = 111319.8922;
    public static final double EARTH_MEAN_RADIUS = 6371008.7714;

    public UnitsOfMeasure(CoordinateReferenceSystem crs) {
        this.unit = crs.getCoordinateSystem().getAxis(0).getUnit();
        this.unitURI = UnitsRegistry.getUnitURI(this.unit);
        this.isLinearUnits = UnitsRegistry.isLinearUnits(this.unitURI);
    }

    public UnitsOfMeasure(String unitURI) {
        this.unit = UnitsRegistry.getUnit(unitURI);
        this.unitURI = UnitsRegistry.getUnitURI(this.unit);
        this.isLinearUnits = UnitsRegistry.isLinearUnits(unitURI);
    }

    public Unit<Length> getUnit() {
        return this.unit;
    }

    public String getUnitURI() {
        return this.unitURI;
    }

    public boolean isLinearUnits() {
        return this.isLinearUnits;
    }

    public static final Double conversion(double sourceDistance, String sourceDistanceUnitsURI, String targetDistanceUnitsURI) throws UnitsConversionException {
        return UnitsOfMeasure.conversion(sourceDistance, new UnitsOfMeasure(sourceDistanceUnitsURI), new UnitsOfMeasure(targetDistanceUnitsURI));
    }

    public static final Double conversion(double sourceDistance, UnitsOfMeasure sourceUnits, UnitsOfMeasure targetUnits) throws UnitsConversionException {
        Boolean isTargetUnitsLinear;
        Boolean isSourceUnitsLinear = sourceUnits.isLinearUnits();
        if (!isSourceUnitsLinear.equals(isTargetUnitsLinear = Boolean.valueOf(targetUnits.isLinearUnits()))) {
            throw new UnitsConversionException("Conversion between linear and non-linear units not supported: " + sourceUnits.unitURI + " and " + targetUnits.unitURI);
        }
        if (sourceUnits.unitURI.equals(targetUnits.unitURI)) {
            return sourceDistance;
        }
        Unit<Length> sourceUnit = sourceUnits.getUnit();
        Unit<Length> targetUnit = targetUnits.getUnit();
        Quantity distance = Quantities.create((double)sourceDistance, sourceUnit);
        Quantity targetDistance = distance.to(targetUnit);
        double convertedDistance = GeoSPARQLOperations.cleanUpPrecision(targetDistance.getValue().doubleValue());
        return convertedDistance;
    }

    public static final double convertToDegrees(double distance, String unitsURI, double latitude) {
        UnitsOfMeasure units = new UnitsOfMeasure(unitsURI);
        if (units.isLinearUnits()) {
            double latitudeRadians = Math.toRadians(latitude);
            double longitudeRatio = Math.cos(latitudeRadians) * 111319.8922;
            double metreDistance = UnitsOfMeasure.conversion(distance, units, METRE_UNITS);
            return GeoSPARQLOperations.cleanUpPrecision(metreDistance / longitudeRatio);
        }
        return UnitsOfMeasure.conversion(distance, units, DEGREE_UNITS);
    }

    public static final double convertToMetres(double distance, String unitsURI, double latitude) {
        UnitsOfMeasure units = new UnitsOfMeasure(unitsURI);
        if (!units.isLinearUnits()) {
            double latitudeRadians = Math.toRadians(latitude);
            double longitudeRatio = Math.cos(latitudeRadians) * 111319.8922;
            double degreeDistance = UnitsOfMeasure.conversion(distance, units, DEGREE_UNITS);
            return GeoSPARQLOperations.cleanUpPrecision(degreeDistance * longitudeRatio);
        }
        return UnitsOfMeasure.conversion(distance, units, METRE_UNITS);
    }

    public String toString() {
        return "UnitsOfMeasure{unit=" + String.valueOf(this.unit) + ", unitURI=" + this.unitURI + ", isLinearUnits=" + this.isLinearUnits + "}";
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.unit);
        hash = 71 * hash + Objects.hashCode(this.unitURI);
        hash = 71 * hash + (this.isLinearUnits ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnitsOfMeasure other = (UnitsOfMeasure)obj;
        if (this.isLinearUnits != other.isLinearUnits) {
            return false;
        }
        if (!Objects.equals(this.unitURI, other.unitURI)) {
            return false;
        }
        return Objects.equals(this.unit, other.unit);
    }
}

