/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.index;

import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;
import org.apache.jena.geosparql.implementation.index.CacheConfiguration;

public class GeometryLiteralIndex {
    private static boolean INDEX_ACTIVE = false;
    private static Cache<String, GeometryWrapper> PRIMARY_INDEX = CacheConfiguration.create(-1L, 5000L);
    private static Cache<String, GeometryWrapper> SECONDARY_INDEX = CacheConfiguration.create(-1L, 5000L);

    public static final GeometryWrapper retrieve(String geometryLiteral, GeometryDatatype geometryDatatype, GeometryIndex targetIndex) {
        return switch (targetIndex) {
            case GeometryIndex.SECONDARY -> GeometryLiteralIndex.retrieveMemoryIndex(geometryLiteral, geometryDatatype, SECONDARY_INDEX, PRIMARY_INDEX);
            default -> GeometryLiteralIndex.retrieveMemoryIndex(geometryLiteral, geometryDatatype, PRIMARY_INDEX, SECONDARY_INDEX);
        };
    }

    private static GeometryWrapper retrieveMemoryIndex(String geometryLiteral, GeometryDatatype geometryDatatype, Cache<String, GeometryWrapper> index, Cache<String, GeometryWrapper> otherIndex) {
        if (INDEX_ACTIVE) {
            GeometryWrapper geometryWrapper = (GeometryWrapper)index.getIfPresent((Object)geometryLiteral);
            if (geometryWrapper == null) {
                geometryWrapper = (GeometryWrapper)otherIndex.getIfPresent((Object)geometryLiteral);
                if (geometryWrapper == null) {
                    geometryWrapper = geometryDatatype.read(geometryLiteral);
                }
                index.put((Object)geometryLiteral, (Object)geometryWrapper);
            }
            return geometryWrapper;
        }
        return geometryDatatype.read(geometryLiteral);
    }

    public static final void clear() {
        PRIMARY_INDEX.clear();
        SECONDARY_INDEX.clear();
    }

    public static final long getPrimaryIndexSize() {
        return PRIMARY_INDEX.size();
    }

    public static final long getSecondaryIndexSize() {
        return SECONDARY_INDEX.size();
    }

    public static boolean isIndexActive() {
        return INDEX_ACTIVE;
    }

    public static void setIndexActive(boolean indexActive) {
        INDEX_ACTIVE = indexActive;
    }

    public static void reset(int maxSize, long expiryInterval) {
        PRIMARY_INDEX = CacheConfiguration.create(maxSize, expiryInterval);
        SECONDARY_INDEX = CacheConfiguration.create(maxSize, expiryInterval);
    }

    public static enum GeometryIndex {
        PRIMARY,
        SECONDARY;

    }
}

