/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.index;

import java.util.Objects;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.geosparql.implementation.DimensionInfo;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.index.CacheConfiguration;
import org.apache.jena.geosparql.implementation.jts.GeometryTransformation;
import org.apache.jena.geosparql.implementation.registry.MathTransformRegistry;
import org.apache.jena.geosparql.implementation.registry.SRSRegistry;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GeometryTransformIndex {
    private static boolean INDEX_ACTIVE = false;
    private static Cache<IndexKey, GeometryWrapper> GEOMETRY_TRANSFORM_INDEX = CacheConfiguration.create(-1L, 5000L);

    public static final GeometryWrapper transform(GeometryWrapper sourceGeometryWrapper, String srsURI, Boolean storeSRSTransform) throws TransformException, FactoryException {
        GeometryWrapper transformedGeometryWrapper;
        IndexKey key = new IndexKey(sourceGeometryWrapper.getLexicalForm(), srsURI);
        if (INDEX_ACTIVE && storeSRSTransform.booleanValue()) {
            transformedGeometryWrapper = (GeometryWrapper)GEOMETRY_TRANSFORM_INDEX.getIfPresent((Object)key);
            if (transformedGeometryWrapper == null) {
                transformedGeometryWrapper = GeometryTransformIndex.transform(sourceGeometryWrapper, srsURI);
                GEOMETRY_TRANSFORM_INDEX.put((Object)key, (Object)transformedGeometryWrapper);
            }
        } else {
            transformedGeometryWrapper = GeometryTransformIndex.transform(sourceGeometryWrapper, srsURI);
        }
        return transformedGeometryWrapper;
    }

    private static GeometryWrapper transform(GeometryWrapper sourceGeometryWrapper, String srsURI) throws MismatchedDimensionException, FactoryException, TransformException {
        CoordinateReferenceSystem sourceCRS = sourceGeometryWrapper.getCRS();
        CoordinateReferenceSystem targetCRS = SRSRegistry.getCRS(srsURI);
        MathTransform transform = MathTransformRegistry.getMathTransform(sourceCRS, targetCRS);
        Geometry parsingGeometry = sourceGeometryWrapper.getParsingGeometry();
        Geometry transformedGeometry = GeometryTransformation.transform(parsingGeometry, transform);
        String geometryDatatypeURI = sourceGeometryWrapper.getGeometryDatatypeURI();
        DimensionInfo dimensionInfo = sourceGeometryWrapper.getDimensionInfo();
        return new GeometryWrapper(transformedGeometry, srsURI, geometryDatatypeURI, dimensionInfo);
    }

    public static final void clear() {
        GEOMETRY_TRANSFORM_INDEX.clear();
    }

    public static final long getGeometryTransformIndexSize() {
        return GEOMETRY_TRANSFORM_INDEX.size();
    }

    public static boolean isIndexActive() {
        return INDEX_ACTIVE;
    }

    public static void setIndexActive(boolean indexActive) {
        INDEX_ACTIVE = indexActive;
    }

    public static void reset(int maxSize, long expiryInterval) {
        GEOMETRY_TRANSFORM_INDEX = CacheConfiguration.create(maxSize, expiryInterval);
    }

    private static class IndexKey {
        private final String sourceGeometryLiteral;
        private final String srsURI;

        public IndexKey(String sourceGeometryLiteral, String srsURI) {
            this.sourceGeometryLiteral = sourceGeometryLiteral;
            this.srsURI = srsURI;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + Objects.hashCode(this.sourceGeometryLiteral);
            hash = 47 * hash + Objects.hashCode(this.srsURI);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexKey other = (IndexKey)obj;
            if (!Objects.equals(this.sourceGeometryLiteral, other.sourceGeometryLiteral)) {
                return false;
            }
            return Objects.equals(this.srsURI, other.srsURI);
        }
    }
}

