/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;

public class GeometrySerializerJtsWkb
extends Serializer<Geometry> {
    private transient WKBReader reader;
    private transient WKBWriter writer;

    public GeometrySerializerJtsWkb() {
        this(new GeometryFactory());
    }

    public GeometrySerializerJtsWkb(GeometryFactory geometryFactory) {
        this(new WKBReader(geometryFactory), new WKBWriter());
    }

    public GeometrySerializerJtsWkb(WKBReader reader, WKBWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public void write(Kryo kryo, Output output, Geometry geometry) {
        byte[] data = this.writer.write(geometry);
        output.write(data, 0, data.length);
        kryo.writeClassAndObject(output, geometry.getUserData());
    }

    public Geometry read(Kryo kryo, Input input, Class<Geometry> type) {
        Geometry geometry;
        byte[] bytes = (byte[])kryo.readObject(input, byte[].class);
        try {
            geometry = this.reader.read(bytes);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        Object userData = kryo.readClassAndObject(input);
        geometry.setUserData(userData);
        return geometry;
    }
}

