/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Node_ANY;
import org.apache.jena.graph.Node_Blank;
import org.apache.jena.graph.Node_Graph;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Node_URI;
import org.apache.jena.graph.Node_Variable;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class NodeSerializer
extends Serializer<Node> {
    protected static final byte TYPE_MASK = -16;
    protected static final byte TYPE_IRI = 16;
    protected static final byte TYPE_BNODE = 32;
    protected static final byte TYPE_LITERAL = 48;
    protected static final byte TYPE_TRIPLE = 64;
    protected static final byte TYPE_GRAPH = 80;
    protected static final byte TYPE_VAR = -128;
    protected static final byte TYPE_SVAR = -112;
    protected static final byte TYPE_ANY = -96;
    protected static final byte TYPE_EXT = -80;
    protected static final byte LITERAL_MASK = 3;
    protected static final byte LITERAL_STRING = 0;
    protected static final byte LITERAL_LANG = 1;
    protected static final byte LITERAL_DTYPE = 2;
    protected static final byte LITERAL_LANG_MASK = 12;
    protected static final byte LITERAL_LANG_LTR = 4;
    protected static final byte LITERAL_LANG_RTL = 8;
    protected static final byte ABBREV_IRI = 8;
    private static Map<String, String> globalPrefixToIri = new HashMap<String, String>();
    private Map<String, String> prefixToIri = new HashMap<String, String>();
    private Map<String, String> iriToPrefix = new HashMap<String, String>();
    protected TypeMapper typeMapper;

    public static void register(Kryo kryo) {
        NodeSerializer.register(kryo, new NodeSerializer());
    }

    public static void register(Kryo kryo, Serializer<Node> nodeSerializer) {
        kryo.register(Node.class, nodeSerializer);
        kryo.register(Node_Blank.class, nodeSerializer);
        kryo.register(Node_URI.class, nodeSerializer);
        kryo.register(Node_Literal.class, nodeSerializer);
        kryo.register(Node_Triple.class, nodeSerializer);
        kryo.register(Node_Variable.class, nodeSerializer);
        kryo.register(Var.class, nodeSerializer);
        kryo.register(Node_ANY.class, nodeSerializer);
        kryo.register(Node_Graph.class, nodeSerializer);
    }

    private static String getCandidateNamespaceIri(String iriString) {
        int i;
        int n = iriString.length();
        block3: for (i = n - 1; i >= 0; --i) {
            char c = iriString.charAt(i);
            switch (c) {
                case '#': 
                case '.': 
                case '/': 
                case ':': {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        String result = i >= 0 ? iriString.substring(0, i + 1) : null;
        return result;
    }

    private static String encode(Map<String, String> iriToPrefix, String iri) {
        String prefix;
        String nsIri;
        Object result = iriToPrefix.get(iri);
        if (result == null && (nsIri = NodeSerializer.getCandidateNamespaceIri(iri)) != null && (prefix = iriToPrefix.get(nsIri)) != null) {
            result = prefix + ":" + iri.substring(nsIri.length());
        }
        return result;
    }

    private static String decode(Map<String, String> prefixToIri, String curie) {
        Object result;
        int idx = curie.indexOf(58);
        if (idx < 0) {
            result = prefixToIri.get(curie);
        } else {
            String prefix = curie.substring(0, idx);
            String iri = prefixToIri.get(prefix);
            result = iri + curie.substring(idx + 1);
        }
        return result;
    }

    public NodeSerializer() {
        this(TypeMapper.getInstance());
    }

    public NodeSerializer(TypeMapper typeMapper) {
        this(typeMapper, globalPrefixToIri);
    }

    public NodeSerializer(TypeMapper typeMapper, Map<String, String> prefixToIri) {
        this.typeMapper = typeMapper;
        this.prefixToIri = new HashMap<String, String>(prefixToIri);
        this.iriToPrefix = prefixToIri.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public void write(Kryo kryo, Output output, Node node) {
        if (node.isURI()) {
            String uri = node.getURI();
            String curie = NodeSerializer.encode(this.iriToPrefix, uri);
            if (curie != null) {
                output.writeByte(24);
                output.writeString(curie);
            } else {
                output.writeByte((byte)16);
                output.writeString(uri);
            }
        } else if (node.isLiteral()) {
            String lex = node.getLiteralLexicalForm();
            String lang = node.getLiteralLanguage();
            String dt = node.getLiteralDatatypeURI();
            TextDirection dir = node.getLiteralBaseDirection();
            if (lang != null && !lang.isEmpty()) {
                int n;
                if (dir == null) {
                    n = 0;
                } else {
                    switch (dir) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case LTR: {
                            n = 4;
                            break;
                        }
                        case RTL: {
                            n = 8;
                        }
                    }
                }
                int langDirBits = n;
                output.writeByte(0x31 | langDirBits);
                output.writeString(lex);
                output.writeString(lang);
            } else if (dt != null && !dt.isEmpty() && !dt.equals(XSD.xstring.getURI())) {
                String dtCurie = NodeSerializer.encode(this.iriToPrefix, dt);
                if (dtCurie != null) {
                    output.writeByte(58);
                    output.writeString(lex);
                    output.writeString(dtCurie);
                } else {
                    output.writeByte(50);
                    output.writeString(lex);
                    output.writeString(dt);
                }
            } else {
                output.writeByte((byte)48);
                output.writeString(lex);
            }
        } else if (node.isBlank()) {
            output.writeByte((byte)32);
            output.writeString(node.getBlankNodeLabel());
        } else if (Node.ANY.equals((Object)node)) {
            output.writeByte((byte)-96);
        } else if (node.isVariable()) {
            if (node instanceof Var) {
                output.writeByte((byte)-112);
            } else {
                output.writeByte((byte)-128);
            }
            output.writeString(node.getName());
        } else if (node.isTripleTerm()) {
            output.writeByte((byte)64);
            kryo.writeObject(output, (Object)node.getTriple());
        } else if (node.isNodeGraph()) {
            output.writeByte((byte)80);
            kryo.writeObject(output, (Object)node.getGraph());
        } else if (node.isExt()) {
            output.writeByte((byte)-80);
            kryo.writeClassAndObject(output, (Object)node);
        } else {
            throw new RuntimeException("Unknown node type: " + String.valueOf(node));
        }
    }

    public Node read(Kryo kryo, Input input, Class<Node> cls) {
        byte type = input.readByte();
        int typeVal = type & 0xFFFFFFF0;
        return switch (typeVal) {
            case 16 -> {
                String v1 = input.readString();
                if ((type & 8) != 0) {
                    v1 = NodeSerializer.decode(this.prefixToIri, v1);
                }
                yield NodeFactory.createURI((String)v1);
            }
            case 48 -> {
                int subTypeVal = type & 3;
                switch (subTypeVal) {
                    case 0: {
                        String v1 = input.readString();
                        yield NodeFactory.createLiteralString((String)v1);
                    }
                    case 1: {
                        int langDirBits = type & 0xC;
                        TextDirection v0 = switch (langDirBits) {
                            case 4 -> TextDirection.LTR;
                            case 8 -> TextDirection.RTL;
                            default -> Node.noTextDirection;
                        };
                        TextDirection textDir = v0;
                        String v1 = input.readString();
                        String v2 = input.readString();
                        yield NodeFactory.createLiteralDirLang((String)v1, (String)v2, (TextDirection)textDir);
                    }
                    case 2: {
                        String v1 = input.readString();
                        String v2 = input.readString();
                        if ((type & 8) != 0) {
                            v2 = NodeSerializer.decode(this.prefixToIri, v2);
                        }
                        RDFDatatype dtype = this.typeMapper.getSafeTypeByName(v2);
                        yield NodeFactory.createLiteralDT((String)v1, (RDFDatatype)dtype);
                    }
                }
                throw new RuntimeException("Unknown literal sub-type: " + subTypeVal);
            }
            case 32 -> {
                String v1 = input.readString();
                yield NodeFactory.createBlankNode((String)v1);
            }
            case 64 -> {
                Triple t = (Triple)kryo.readObject(input, Triple.class);
                yield NodeFactory.createTripleTerm((Triple)t);
            }
            case 80 -> {
                Graph graph = (Graph)kryo.readObject(input, Graph.class);
                yield new Node_Graph(graph);
            }
            case -96 -> Node.ANY;
            case -112 -> {
                String v1 = input.readString();
                yield Var.alloc((String)v1);
            }
            case -128 -> {
                String v1 = input.readString();
                yield NodeFactory.createVariable((String)v1);
            }
            case -80 -> {
                Object o = kryo.readClassAndObject(input);
                yield (Node)o;
            }
            default -> throw new RuntimeException("Unknown node type: " + typeVal);
        };
    }

    static {
        globalPrefixToIri.put("a", RDF.type.getURI());
        globalPrefixToIri.put("d", Quad.defaultGraphIRI.getURI());
        globalPrefixToIri.put("g", Quad.defaultGraphNodeGenerated.getURI());
        globalPrefixToIri.put("x", "http://www.w3.org/2001/XMLSchema#");
        globalPrefixToIri.put("r", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        globalPrefixToIri.put("s", "http://www.w3.org/2000/01/rdf-schema#");
        globalPrefixToIri.put("o", "http://www.w3.org/2002/07/owl#");
    }
}

