/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.geosparql.implementation.vocabulary.SpatialExtension;
import org.apache.jena.geosparql.spatial.ConvertLatLon;
import org.apache.jena.geosparql.spatial.SpatialIndexItem;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexFindUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static IteratorCloseable<SpatialIndexItem> findSpatialIndexItems(DatasetGraph datasetGraph, String srsURI) {
        Graph defaultGraph = datasetGraph.getDefaultGraph();
        Iter itemsIter = SpatialIndexFindUtils.findSpatialIndexItems(defaultGraph, srsURI);
        try {
            Iterator graphNodeIt = datasetGraph.listGraphNodes();
            Iter namedGraphItemsIt = Iter.iter((Iterator)graphNodeIt).flatMap(graphNode -> {
                Graph namedGraph = datasetGraph.getGraph(graphNode);
                IteratorCloseable<SpatialIndexItem> graphItems = SpatialIndexFindUtils.findSpatialIndexItems(namedGraph, srsURI);
                return graphItems;
            });
            itemsIter = Iter.iter(itemsIter).append((Iterator)namedGraphItemsIt);
        }
        catch (Throwable t) {
            t.addSuppressed(new RuntimeException("Failure during findSpatialIndexItems.", t));
            Iter.close(itemsIter);
            throw t;
        }
        return itemsIter;
    }

    public static final IteratorCloseable<SpatialIndexItem> findSpatialIndexItems(Graph graph, String srsURI) {
        IteratorCloseable<SpatialIndexItem> result = graph.contains(null, Geo.HAS_GEOMETRY_NODE, null) ? SpatialIndexFindUtils.findGeometryIndexItems(graph, srsURI) : (graph.contains(null, SpatialExtension.GEO_LAT_NODE, null) ? SpatialIndexFindUtils.findGeoPredicateIndexItems(graph, srsURI) : Iter.empty());
        return result;
    }

    public static final void checkSpatialIndexItems(Graph graph) {
        if (graph.contains(null, Geo.HAS_GEOMETRY_NODE, null)) {
            LOGGER.info("Feature-hasGeometry-Geometry statements found.");
            if (graph.contains(null, SpatialExtension.GEO_LAT_NODE, null)) {
                LOGGER.warn("Lat/Lon Geo predicates also found but will not be added to index.");
            }
        } else if (graph.contains(null, SpatialExtension.GEO_LAT_NODE, null)) {
            LOGGER.info("Geo predicate statements found.");
        }
    }

    public static IteratorCloseable<SpatialIndexItem> findGeometryIndexItems(Graph graph, String srsURI) {
        ExtendedIterator stmtIter = graph.find(null, Geo.HAS_GEOMETRY_NODE, null);
        Iter result = Iter.iter((Iterator)stmtIter).flatMap(stmt -> {
            Node feature = stmt.getSubject();
            Node geometry = stmt.getObject();
            Object nodeIter = G.iterSP((Graph)graph, (Node)geometry, (Node)Geo.HAS_SERIALIZATION_NODE);
            try {
                if (!nodeIter.hasNext()) {
                    ExtendedIterator wktNodeIter;
                    Iter.close((Iterator)nodeIter);
                    nodeIter = wktNodeIter = G.iterSP((Graph)graph, (Node)geometry, (Node)Geo.AS_WKT_NODE);
                    ExtendedIterator gmlNodeIter = G.iterSP((Graph)graph, (Node)geometry, (Node)Geo.AS_GML_NODE);
                    nodeIter = Iter.append((Iterator)wktNodeIter, (Iterator)gmlNodeIter);
                }
            }
            catch (Throwable t) {
                t.addSuppressed(new RuntimeException("Error encountered.", t));
                Iter.close((Iterator)nodeIter);
                throw t;
            }
            Iterator itemIter = Iter.map((Iterator)nodeIter, geometryNode -> {
                GeometryWrapper geometryWrapper = GeometryWrapper.extract(geometryNode);
                SpatialIndexItem item = SpatialIndexFindUtils.makeSpatialIndexItem(feature, geometryWrapper, srsURI);
                return item;
            });
            return itemIter;
        });
        return result;
    }

    public static IteratorCloseable<SpatialIndexItem> findGeoPredicateIndexItems(Graph graph, String srsURI) {
        boolean enableWarnings = false;
        boolean[] loggedMultipleLatLons = new boolean[]{false};
        ExtendedIterator latIt = graph.find(Node.ANY, SpatialExtension.GEO_LAT_NODE, Node.ANY);
        Iter result = Iter.iter((Iterator)latIt).flatMap(triple -> {
            Node feature = triple.getSubject();
            Node lat = triple.getObject();
            ExtendedIterator lons = G.iterSP((Graph)graph, (Node)feature, (Node)SpatialExtension.GEO_LON_NODE);
            int[] lonCounter = new int[]{0};
            Iter r = Iter.iter((Iterator)lons).map(lon -> {
                if (enableWarnings) {
                    if (lonCounter[0] == 1 && !loggedMultipleLatLons[0]) {
                        LOGGER.warn("Geo predicates: multiple longitudes detected on feature " + String.valueOf(feature) + ". Further warnings will be omitted.");
                        loggedMultipleLatLons[0] = true;
                    }
                    lonCounter[0] = lonCounter[0] + 1;
                }
                GeometryWrapper geometryWrapper = ConvertLatLon.toGeometryWrapper(lat, lon);
                SpatialIndexItem item = SpatialIndexFindUtils.makeSpatialIndexItem(feature, geometryWrapper, srsURI);
                return item;
            });
            return r;
        });
        return result;
    }

    public static SpatialIndexItem makeSpatialIndexItem(Node feature, GeometryWrapper geometryWrapper, String srsURI) {
        GeometryWrapper transformedGeometryWrapper = SpatialIndexFindUtils.unsafeConvert(geometryWrapper, srsURI);
        Envelope envelope = transformedGeometryWrapper.getEnvelope();
        SpatialIndexItem item = new SpatialIndexItem(envelope, feature);
        return item;
    }

    public static GeometryWrapper unsafeConvert(GeometryWrapper geometryWrapper, String srsURI) {
        GeometryWrapper result;
        try {
            result = geometryWrapper.convertSRS(srsURI);
        }
        catch (MismatchedDimensionException | TransformException | FactoryException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

