/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.SpatialIndexItem;
import org.apache.jena.geosparql.spatial.index.v1.SpatialIndexV1;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.locationtech.jts.geom.Envelope;

@Deprecated
public class SpatialIndexStorage
implements Serializable {
    private final String srsURI;
    private final List<StorageItem> storageItems;

    public SpatialIndexStorage(Collection<SpatialIndexItem> spatialIndexItems, String srsURI) {
        this.srsURI = srsURI;
        this.storageItems = new ArrayList<StorageItem>(spatialIndexItems.size());
        for (SpatialIndexItem spatialIndexItem : spatialIndexItems) {
            StorageItem storageItem = new StorageItem(spatialIndexItem.getEnvelope(), spatialIndexItem.getItem().getURI());
            this.storageItems.add(storageItem);
        }
    }

    public String getSrsURI() {
        return this.srsURI;
    }

    public Collection<SpatialIndexItem> getIndexItems() {
        ArrayList<SpatialIndexItem> indexItems = new ArrayList<SpatialIndexItem>(this.storageItems.size());
        for (StorageItem storageItem : this.storageItems) {
            SpatialIndexItem indexItem = storageItem.getIndexItem();
            indexItems.add(indexItem);
        }
        return indexItems;
    }

    public SpatialIndexV1 getSpatialIndex() throws SpatialIndexException {
        return new SpatialIndexV1(this.getIndexItems(), this.srsURI);
    }

    private class StorageItem
    implements Serializable {
        private final Envelope envelope;
        private final String uri;

        public StorageItem(Envelope envelope, Resource item) {
            this.envelope = envelope;
            this.uri = item.getURI();
        }

        public StorageItem(Envelope envelope, String uri) {
            this.envelope = envelope;
            this.uri = uri;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public String getUri() {
            return this.uri;
        }

        public Resource getItem() {
            return ResourceFactory.createResource((String)this.uri);
        }

        public SpatialIndexItem getIndexItem() {
            return new SpatialIndexItem(this.envelope, (RDFNode)this.getItem());
        }

        public String toString() {
            return "StorageItem{envelope=" + String.valueOf(this.envelope) + ", uri=" + this.uri + "}";
        }
    }
}

