/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.filter_functions;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.UnitsConversionException;
import org.apache.jena.geosparql.implementation.UnitsOfMeasure;
import org.apache.jena.geosparql.implementation.great_circle.GreatCircleDistance;
import org.apache.jena.geosparql.implementation.registry.UnitsRegistry;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase5;
import org.apache.jena.sparql.util.FmtUtils;

public class GreatCircleFF
extends FunctionBase5 {
    public NodeValue exec(NodeValue v1, NodeValue v2, NodeValue v3, NodeValue v4, NodeValue v5) {
        try {
            if (!v1.isNumber()) {
                throw new ExprEvalException("Not a Number: " + FmtUtils.stringForNode((Node)v1.asNode()));
            }
            if (!v2.isNumber()) {
                throw new ExprEvalException("Not a Number: " + FmtUtils.stringForNode((Node)v2.asNode()));
            }
            if (!v3.isNumber()) {
                throw new ExprEvalException("Not a Number: " + FmtUtils.stringForNode((Node)v3.asNode()));
            }
            if (!v4.isNumber()) {
                throw new ExprEvalException("Not a Number: " + FmtUtils.stringForNode((Node)v4.asNode()));
            }
            if (!v5.isIRI() && !v5.isString()) {
                throw new ExprEvalException("Not an IRI or String: " + FmtUtils.stringForNode((Node)v5.asNode()));
            }
            double lat1 = v1.getDouble();
            double lon1 = v2.getDouble();
            double lat2 = v3.getDouble();
            double lon2 = v4.getDouble();
            String unitsURI = v5.isIRI() ? v5.asNode().getURI() : v5.asString();
            double distanceMetres = GreatCircleDistance.haversineFormula(lat1, lon1, lat2, lon2);
            if (!UnitsRegistry.isLinearUnits(unitsURI).booleanValue()) {
                throw new ExprEvalException("Great Circle distance units are metres and only linear conversion supported.");
            }
            double distance = UnitsOfMeasure.conversion(distanceMetres, "http://www.opengis.net/def/uom/OGC/1.0/metre", unitsURI);
            return NodeValue.makeDouble((double)distance);
        }
        catch (DatatypeFormatException | UnitsConversionException ex) {
            throw new ExprEvalException(ex.getMessage(), ex);
        }
    }
}

