/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.filter_functions;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.UnitsConversionException;
import org.apache.jena.geosparql.implementation.index.GeometryLiteralIndex;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase4;
import org.apache.jena.sparql.util.FmtUtils;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class NearbyFF
extends FunctionBase4 {
    public NodeValue exec(NodeValue v1, NodeValue v2, NodeValue v3, NodeValue v4) {
        try {
            GeometryWrapper geometry1 = GeometryWrapper.extract(v1, GeometryLiteralIndex.GeometryIndex.PRIMARY);
            GeometryWrapper geometry2 = GeometryWrapper.extract(v2, GeometryLiteralIndex.GeometryIndex.SECONDARY);
            if (!v3.isNumber()) {
                throw new ExprEvalException("Not a number: " + FmtUtils.stringForNode((Node)v3.asNode()));
            }
            if (!v4.isIRI() && !v4.isString()) {
                throw new ExprEvalException("Not an IRI or String: " + FmtUtils.stringForNode((Node)v4.asNode()));
            }
            double radius = v3.getDouble();
            String unitsURI = v4.isIRI() ? v4.asNode().getURI() : v4.asString();
            boolean result = NearbyFF.relate(geometry1, geometry2, radius, unitsURI);
            return NodeValue.makeBoolean((boolean)result);
        }
        catch (DatatypeFormatException | UnitsConversionException ex) {
            throw new ExprEvalException(ex.getMessage(), ex);
        }
    }

    public static final boolean relate(GeometryWrapper geometry1, GeometryWrapper geometry2, double radius, String unitsURI) {
        try {
            double distance = geometry1.distance(geometry2, unitsURI);
            return distance < radius;
        }
        catch (UnitsConversionException | MismatchedDimensionException | TransformException | FactoryException ex) {
            throw new ExprEvalException(ex.getMessage() + ": " + String.valueOf(geometry1.asLiteral()) + ", " + String.valueOf(geometry2.asLiteral()) + ", " + Double.toString(radius) + ", " + unitsURI, ex);
        }
    }
}

