/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.index.v2;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.jts.CustomGeometryFactory;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public class GeometryGenerator {
    public static Coordinate[] createCircle(GeometryFactory geometryFactory, Coordinate center, double radius, int numPoints, boolean closed) {
        Coordinate[] coords = new Coordinate[numPoints + (closed ? 1 : 0)];
        for (int i = 0; i < numPoints; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)numPoints;
            double x = center.x + radius * Math.cos(angle);
            double y = center.y + radius * Math.sin(angle);
            coords[i] = new Coordinate(x, y);
        }
        if (closed) {
            coords[numPoints] = coords[0];
        }
        return coords;
    }

    public static Geometry createGeom(GeometryType type, GeometryFactory f, Coordinate center, double radius, int numPoints) {
        return switch (type) {
            case GeometryType.POINT -> f.createPoint(center);
            default -> {
                Coordinate[] c1 = GeometryGenerator.createCircle(f, center, radius, numPoints, true);
                switch (type) {
                    case MULTIPOINT: {
                        yield f.createMultiPointFromCoords(c1);
                    }
                    case LINESTRING: {
                        yield f.createLineString(c1);
                    }
                    case LINEARRING: {
                        yield f.createLinearRing(c1);
                    }
                    case POLYGON: {
                        yield f.createPolygon(c1);
                    }
                }
                Coordinate[] c2 = GeometryGenerator.createCircle(f, center, radius * 0.5, (int)Math.max(3.0, (double)numPoints * 0.8), true);
                switch (type) {
                    case MULTILINESTRING: {
                        yield f.createMultiLineString(new LineString[]{f.createLineString(c1), f.createLineString(c2)});
                    }
                    case MULTIPOLYGON: {
                        yield f.createMultiPolygon(new Polygon[]{f.createPolygon(c1), f.createPolygon(c2)});
                    }
                    case GEOMETRYCOLLECTION: {
                        yield f.createGeometryCollection(new Geometry[]{f.createPoint(center), f.createLinearRing(c2)});
                    }
                }
                throw new RuntimeException("Unsupported geometry type: " + String.valueOf((Object)type));
            }
        };
    }

    public static Map<GeometryType, Number> createConfig(long amount) {
        LinkedHashMap<GeometryType, Number> config = new LinkedHashMap<GeometryType, Number>();
        config.put(GeometryType.POINT, amount);
        config.put(GeometryType.LINESTRING, amount);
        config.put(GeometryType.LINEARRING, amount);
        config.put(GeometryType.POLYGON, amount);
        config.put(GeometryType.MULTIPOINT, amount);
        config.put(GeometryType.MULTILINESTRING, amount);
        config.put(GeometryType.MULTIPOLYGON, amount);
        config.put(GeometryType.GEOMETRYCOLLECTION, amount);
        return config;
    }

    public static long generateGraph(Graph graph, Envelope envelope, Map<GeometryType, Number> config) {
        GeometryFactory geometryFactory = CustomGeometryFactory.theInstance();
        float maxRadius = 1.0f;
        int minNumPoints = 3;
        int maxNumPoints = 30;
        Random rand = new Random(0L);
        float minX = (float)envelope.getMinX();
        float maxX = (float)envelope.getMaxX();
        float minY = (float)envelope.getMinY();
        float maxY = (float)envelope.getMaxY();
        float dX = maxX - minX;
        float dY = maxY - minY;
        int dNumPoints = maxNumPoints - minNumPoints;
        long generatedItemCount = 0L;
        long nextFeatureId = 0L;
        for (Map.Entry<GeometryType, Number> e : config.entrySet()) {
            GeometryType geometryType = e.getKey();
            long count = e.getValue().longValue();
            for (long i = 0L; i < count; ++i) {
                long featureId;
                float x = minX + rand.nextFloat(dX);
                float y = minY + rand.nextFloat(dY);
                int numPoints = minNumPoints + (int)rand.nextFloat(dNumPoints);
                Coordinate c = new Coordinate((double)x, (double)y);
                Geometry g = GeometryGenerator.createGeom(geometryType, geometryFactory, c, maxRadius, numPoints);
                ++nextFeatureId;
                Node feature = NodeFactory.createURI((String)("http://www.example.org/feature" + featureId));
                Node geometry = NodeFactory.createURI((String)("http://www.example.org/geometry" + featureId));
                Node geom = new GeometryWrapper(g, "http://www.opengis.net/ont/geosparql#wktLiteral").asNode();
                graph.add(feature, Geo.HAS_GEOMETRY_NODE, geometry);
                graph.add(geometry, Geo.AS_WKT_NODE, geom);
                ++generatedItemCount;
            }
        }
        return generatedItemCount;
    }

    public static enum GeometryType {
        POINT,
        LINESTRING,
        LINEARRING,
        POLYGON,
        MULTIPOINT,
        MULTILINESTRING,
        MULTIPOLYGON,
        GEOMETRYCOLLECTION;

    }
}

