/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.index.v2;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.SpatialIndexFindUtils;
import org.apache.jena.geosparql.spatial.SpatialIndexItem;
import org.apache.jena.geosparql.spatial.index.v2.STRtreePerGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.locationtech.jts.index.strtree.STRtree;

public class STRtreeUtils {
    static final int MINIMUM_CAPACITY = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static STRtree buildSpatialIndexTree(Graph graph, String srsURI) throws SpatialIndexException {
        try {
            STRtree tree;
            try (IteratorCloseable<SpatialIndexItem> it = SpatialIndexFindUtils.findSpatialIndexItems(graph, srsURI);){
                tree = STRtreeUtils.buildSpatialIndexTree(it);
            }
            return tree;
        }
        catch (Throwable e) {
            throw new SpatialIndexException("Spatial index construction failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static STRtreePerGraph buildSpatialIndexTree(DatasetGraph datasetGraph, String srsURI) throws SpatialIndexException {
        LinkedHashMap<Node, STRtree> treeMap = new LinkedHashMap<Node, STRtree>();
        Graph defaultGraph = datasetGraph.getDefaultGraph();
        STRtree defaultGraphTree = STRtreeUtils.buildSpatialIndexTree(defaultGraph, srsURI);
        treeMap.put(Quad.defaultGraphIRI, defaultGraphTree);
        Iterator graphIter = datasetGraph.listGraphNodes();
        try {
            while (graphIter.hasNext()) {
                Node graphNode = (Node)graphIter.next();
                Graph namedGraph = datasetGraph.getGraph(graphNode);
                treeMap.put(graphNode, STRtreeUtils.buildSpatialIndexTree(namedGraph, srsURI));
            }
        }
        finally {
            Iter.close((Iterator)graphIter);
        }
        return new STRtreePerGraph(treeMap);
    }

    public static STRtree buildSpatialIndexTree(Iterator<SpatialIndexItem> it) throws SpatialIndexException {
        List items = Iter.toList(it);
        STRtree tree = STRtreeUtils.buildSpatialIndexTree(items);
        return tree;
    }

    public static STRtree buildSpatialIndexTree(Collection<SpatialIndexItem> items) throws SpatialIndexException {
        STRtree tree = new STRtree(Math.max(2, items.size()));
        STRtreeUtils.addToTree(tree, items.iterator());
        tree.build();
        return tree;
    }

    public static void addToTree(STRtree treeAcc, Iterator<SpatialIndexItem> it) throws SpatialIndexException {
        it.forEachRemaining(item -> treeAcc.insert(item.getEnvelope(), (Object)item.getItem()));
    }
}

