/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.index.v2;

import com.google.gson.JsonObject;
import java.util.Objects;

public class SpatialIndexHeader {
    public static final String TYPE_KEY = "type";
    public static final String VERSION_KEY = "version";
    public static final String SRS_KEY = "srs";
    public static final String GEOMETRY_SERIALIZER_KEY = "geometrySerializer";
    public static final String TYPE_VALUE = "jena-spatial-index";
    protected JsonObject json;

    public SpatialIndexHeader() {
        this(new JsonObject());
    }

    public SpatialIndexHeader(JsonObject json) {
        this.json = Objects.requireNonNull(json);
    }

    public JsonObject getJson() {
        return this.json;
    }

    public void setType(String type) {
        this.getJson().addProperty(TYPE_KEY, type);
    }

    public String getType() {
        return this.getJson().get(TYPE_KEY).getAsString();
    }

    public void setVersion(String version) {
        this.getJson().addProperty(VERSION_KEY, version);
    }

    public String getVersion() {
        return this.getJson().get(VERSION_KEY).getAsString();
    }

    public void setSrsUri(String type) {
        this.getJson().addProperty(SRS_KEY, type);
    }

    public String getSrsUri() {
        return this.getJson().get(SRS_KEY).getAsString();
    }

    public void setGeometrySerializerClass(String className) {
        this.getJson().addProperty(GEOMETRY_SERIALIZER_KEY, className);
    }

    public String getGeometrySerializerClass() {
        return this.getJson().get(GEOMETRY_SERIALIZER_KEY).getAsString();
    }
}

