/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.index.v2;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.implementation.registry.SRSRegistry;
import org.apache.jena.geosparql.kryo.GeometrySerializerJtsWkb;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.index.v2.KryoRegistratorSpatialIndexV2;
import org.apache.jena.geosparql.spatial.index.v2.STRtreePerGraph;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexHeader;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexLib;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexPerGraph;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexIoKryo {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static boolean enableGeometrySerde = false;

    public static SpatialIndex loadOrBuildSpatialIndex(Dataset dataset, Path spatialIndexFile) throws SpatialIndexException {
        SpatialIndex spatialIndex = SpatialIndexIoKryo.loadOrBuildSpatialIndex(dataset, null, spatialIndexFile);
        return spatialIndex;
    }

    private static boolean isNonEmptyFile(Path path) {
        boolean result = false;
        if (path != null && Files.exists(path, new LinkOption[0])) {
            try {
                result = Files.size(path) > 0L;
            }
            catch (IOException e) {
                throw IOX.exception((IOException)e);
            }
        }
        return result;
    }

    public static SpatialIndex loadOrBuildSpatialIndex(Dataset dataset, String srsURI, Path spatialIndexFile) throws SpatialIndexException {
        SpatialIndexPerGraph spatialIndex = null;
        if (SpatialIndexIoKryo.isNonEmptyFile(spatialIndexFile)) {
            spatialIndex = SpatialIndexIoKryo.load(spatialIndexFile);
            SpatialIndexLib.setSpatialIndex(dataset, (SpatialIndex)spatialIndex);
        } else {
            spatialIndex = SpatialIndexIoKryo.buildSpatialIndex(dataset, srsURI, spatialIndexFile);
        }
        return spatialIndex;
    }

    public static SpatialIndexPerGraph buildSpatialIndex(Dataset dataset, String srsURI, Path spatialIndexFile) throws SpatialIndexException {
        SpatialIndexPerGraph spatialIndex = SpatialIndexLib.buildSpatialIndex(dataset.asDatasetGraph(), srsURI);
        if (spatialIndexFile != null) {
            spatialIndex.setLocation(spatialIndexFile);
            SpatialIndexIoKryo.save(spatialIndexFile, spatialIndex);
        }
        return spatialIndex;
    }

    public static final void save(Path spatialIndexFile, SpatialIndexPerGraph index) throws SpatialIndexException {
        Path originalFile = spatialIndexFile.toAbsolutePath();
        LOGGER.info("Saving Spatial Index - Started: " + String.valueOf(originalFile));
        Path tmpFile = IOX.uniqueDerivedPath((Path)originalFile, null);
        Path originalBackup = IOX.uniqueDerivedPath((Path)originalFile, baseName -> baseName + ".bak");
        if (Files.exists(originalFile, new LinkOption[0])) {
            IOX.moveAllowCopy((Path)originalFile, (Path)originalBackup);
        }
        try {
            IOX.safeWriteOrCopy((Path)originalFile, (Path)tmpFile, out -> SpatialIndexIoKryo.writeToOutputStream(out, index));
            LOGGER.info("Saving Spatial Index - Success: " + String.valueOf(originalFile));
        }
        catch (RuntimeIOException ex) {
            LOGGER.info("Failure writing spatial index: " + String.valueOf(originalFile), (Throwable)ex);
            try {
                IOX.moveAllowCopy((Path)originalBackup, (Path)originalFile);
            }
            catch (RuntimeException ex2) {
                LOGGER.warn("Failed to restore " + String.valueOf(originalFile) + " + from backup file " + String.valueOf(originalBackup), (Throwable)ex2);
            }
            throw new SpatialIndexException("Save Exception: " + String.valueOf(originalFile) + " (via temp file: " + String.valueOf(tmpFile) + ")", ex);
        }
        try {
            Files.deleteIfExists(originalBackup);
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to remove no longer needed backup: " + String.valueOf(originalBackup), (Throwable)ex);
        }
    }

    public static void writeToOutputStream(OutputStream os, SpatialIndexPerGraph index) {
        SpatialIndexHeader header = new SpatialIndexHeader();
        header.setType("jena-spatial-index");
        header.setVersion("2.0.0");
        header.setSrsUri(index.getSrsInfo().getSrsURI());
        GeometrySerializerJtsWkb geometrySerializer = null;
        if (enableGeometrySerde) {
            geometrySerializer = new GeometrySerializerJtsWkb();
            header.setGeometrySerializerClass(((Object)((Object)geometrySerializer)).getClass().getName());
        }
        Kryo kryo = new Kryo();
        KryoRegistratorSpatialIndexV2.registerClasses(kryo, geometrySerializer);
        try (Output output = new Output(os);){
            SpatialIndexIoKryo.writeHeader(output, header);
            STRtreePerGraph trees = index.getIndex();
            kryo.writeObject(output, (Object)trees);
            output.flush();
        }
    }

    public static void writeHeader(Output output, SpatialIndexHeader header) {
        Gson gson = new Gson();
        String headerStr = gson.toJson((JsonElement)header.getJson());
        output.writeString(headerStr);
    }

    public static SpatialIndexHeader readHeader(Input input) {
        String headerStr = input.readString();
        Gson gson = new Gson();
        JsonObject obj = (JsonObject)gson.fromJson(headerStr, JsonObject.class);
        return new SpatialIndexHeader(obj);
    }

    public static final SpatialIndexPerGraph load(Path spatialIndexFile) throws SpatialIndexException {
        STRtreePerGraph index;
        String srsUri;
        spatialIndexFile = spatialIndexFile.toAbsolutePath();
        LOGGER.info("Loading Spatial Index - Started: {}", (Object)spatialIndexFile);
        try (Input input = new Input(Files.newInputStream(spatialIndexFile, new OpenOption[0]));){
            SpatialIndexHeader header = SpatialIndexIoKryo.readHeader(input);
            String type = header.getType();
            if (!"jena-spatial-index".equals(type)) {
                throw new RuntimeException("Type does not indicate a spatial index file.");
            }
            String version = header.getVersion();
            if (!"2.0.0".equals(version)) {
                throw new SpatialIndexException("The version of the spatial index does not match the version of this loader class.");
            }
            srsUri = header.getSrsUri();
            Serializer geometrySerializer = null;
            if (enableGeometrySerde) {
                String geometrySerdeName = header.getGeometrySerializerClass();
                Objects.requireNonNull(geometrySerdeName, "Field 'geometrySerde' not set.");
                try {
                    Class<?> geometrySerdeClass = Class.forName(geometrySerdeName);
                    geometrySerializer = (Serializer)geometrySerdeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new SpatialIndexException("Failed to load index", e);
                }
            }
            Kryo kryo = new Kryo();
            KryoRegistratorSpatialIndexV2.registerClasses(kryo, geometrySerializer);
            index = (STRtreePerGraph)kryo.readObject(input, STRtreePerGraph.class);
            LOGGER.info("Loading Spatial Index - Completed: {}", (Object)spatialIndexFile);
        }
        catch (IOException ex) {
            throw new SpatialIndexException("Loading Exception: " + ex.getMessage(), ex);
        }
        SRSInfo srsInfo = SRSRegistry.getSRSInfo(srsUri);
        SpatialIndexPerGraph spatialIndex = new SpatialIndexPerGraph(srsInfo, index, spatialIndexFile);
        spatialIndex.setLocation(spatialIndexFile);
        return spatialIndex;
    }
}

