/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.index.v2;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.implementation.registry.SRSRegistry;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.index.v2.STRtreePerGraph;
import org.apache.jena.geosparql.spatial.index.v2.STRtreeUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.AutoTxn;
import org.apache.jena.system.Txn;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.STRtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexPerGraph
implements SpatialIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final transient SRSInfo srsInfo;
    private STRtreePerGraph index;
    private Path location;

    public SpatialIndexPerGraph(STRtreePerGraph index) {
        this("http://www.opengis.net/def/crs/OGC/1.3/CRS84", index, null);
    }

    public SpatialIndexPerGraph(String srsUri, STRtreePerGraph index, Path location) {
        this(SRSRegistry.getSRSInfo(srsUri), index, null);
    }

    public SpatialIndexPerGraph(SRSInfo srsInfo, STRtreePerGraph index, Path location) {
        this.srsInfo = Objects.requireNonNull(srsInfo);
        this.index = Objects.requireNonNull(index);
        this.location = location;
    }

    public STRtreePerGraph getIndex() {
        return this.index;
    }

    @Override
    public SRSInfo getSrsInfo() {
        return this.srsInfo;
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public long getSize() {
        return this.index.size();
    }

    @Override
    public Collection<Node> query(Envelope searchEnvelope, Node graph) {
        return this.index.queryOneGraph(searchEnvelope, graph);
    }

    @Override
    public Path getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Path location) {
        this.location = location;
    }

    public String toString() {
        return "SpatialIndex{srsInfo=" + String.valueOf(this.srsInfo) + ", index=" + String.valueOf(this.index) + ", file=" + String.valueOf(this.location) + "}";
    }

    public static void recomputeIndexForGraphs(SpatialIndexPerGraph index, DatasetGraph datasetGraph, Set<String> graphNames) throws SpatialIndexException {
        STRtreePerGraph trees = index.getIndex();
        try (AutoTxn txn = Txn.autoTxn((Transactional)datasetGraph, (TxnType)TxnType.READ);){
            for (String graphName : graphNames) {
                Node g;
                Node node = g = graphName == null ? null : NodeFactory.createURI((String)graphName);
                if (trees.contains(g)) {
                    LOGGER.info("recomputing spatial index for graph: {}", (Object)graphName);
                } else {
                    LOGGER.info("computing spatial index for graph: {}", (Object)graphName);
                }
                Graph namedGraph = datasetGraph.getGraph(g);
                STRtree indexTree = STRtreeUtils.buildSpatialIndexTree(namedGraph, index.getSrsInfo().getSrsURI());
                STRtree oldIndexTree = trees.setTree(g, indexTree);
                if (oldIndexTree != null) {
                    LOGGER.info("replaced spatial index for graph: {}", (Object)graphName);
                    continue;
                }
                LOGGER.info("added spatial index for graph: {}", (Object)graphName);
            }
            txn.commit();
        }
    }
}

