/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.index.v2;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.index.v2.STRtreePerGraph;
import org.apache.jena.geosparql.spatial.index.v2.STRtreeUtils;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexPerGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.engine.iterator.Abortable;
import org.apache.jena.system.AutoTxn;
import org.apache.jena.system.Txn;
import org.locationtech.jts.index.strtree.STRtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexerComputation
implements Callable<SpatialIndexPerGraph>,
Abortable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private DatasetGraph datasetGraph;
    private List<Node> graphNodes;
    private ExecutorService executorService;
    private String srsURI;
    private int threadCount;
    private final AtomicBoolean requestingCancel = new AtomicBoolean();
    private volatile boolean cancelOnce = false;
    private Object cancelLock = new Object();
    private List<Future<Map.Entry<Node, STRtree>>> futures = new ArrayList<Future<Map.Entry<Node, STRtree>>>();
    private static boolean logProgress = false;

    public SpatialIndexerComputation(DatasetGraph datasetGraph, String srsURI, List<Node> graphNodes, int threadCount) {
        this.datasetGraph = datasetGraph;
        this.graphNodes = graphNodes;
        this.srsURI = srsURI;
        this.threadCount = threadCount;
        if (threadCount <= 0) {
            throw new IllegalArgumentException("Thread count must be greater than 0.");
        }
    }

    public String getSrsURI() {
        return this.srsURI;
    }

    public List<Node> getGraphNodes() {
        return this.graphNodes;
    }

    private Map.Entry<Node, STRtree> indexOneGraph(Node graphNode) throws SpatialIndexException {
        if (logProgress) {
            LOGGER.info("Started spatial index build for graph {} ...", (Object)graphNode);
        }
        STRtree tree = null;
        try (AutoTxn txn = Txn.autoTxn((Transactional)this.datasetGraph, (TxnType)TxnType.READ);){
            Graph graph;
            Graph graph2 = graph = Quad.isDefaultGraph((Node)graphNode) ? this.datasetGraph.getDefaultGraph() : this.datasetGraph.getGraph(graphNode);
            if (graph != null) {
                tree = STRtreeUtils.buildSpatialIndexTree(graph, this.srsURI);
            }
            txn.commit();
        }
        if (logProgress) {
            LOGGER.info("Completed spatial index for graph {}", (Object)graphNode);
        }
        return Map.entry(graphNode, tree);
    }

    @Override
    public SpatialIndexPerGraph call() throws InterruptedException, ExecutionException {
        try {
            SpatialIndexPerGraph spatialIndexPerGraph = this.callActual();
            return spatialIndexPerGraph;
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SpatialIndexPerGraph callActual() throws InterruptedException, ExecutionException {
        Iterator<Node> iterator = this.cancelLock;
        synchronized (iterator) {
            if (this.executorService != null) {
                throw new IllegalStateException("Task already running.");
            }
            this.executorService = Executors.newFixedThreadPool(this.threadCount);
        }
        for (Node node : this.graphNodes) {
            this.checkRequestingCancel();
            Future<Map.Entry> future = this.executorService.submit(() -> this.indexOneGraph(node));
            this.futures.add(future);
        }
        LinkedHashMap<Node, STRtree> treeMap = new LinkedHashMap<Node, STRtree>();
        for (Future<Map.Entry<Node, STRtree>> future : this.futures) {
            Map.Entry<Node, STRtree> entry = future.get();
            Node graphNode = entry.getKey();
            STRtree tree = entry.getValue();
            if (tree == null) continue;
            treeMap.put(graphNode, tree);
        }
        STRtreePerGraph sTRtreePerGraph = new STRtreePerGraph();
        sTRtreePerGraph.setTrees(treeMap);
        SpatialIndexPerGraph spatialIndexPerGraph = new SpatialIndexPerGraph(sTRtreePerGraph);
        return spatialIndexPerGraph;
    }

    protected void cleanUp() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            try {
                this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Abandoning an executor service that failed to stop.", (Throwable)e);
            }
        }
    }

    protected void checkRequestingCancel() {
        boolean isCancelled = this.requestingCancel();
        if (isCancelled) {
            throw new CancellationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Object object = this.cancelLock;
        synchronized (object) {
            this.requestingCancel.set(true);
            if (!this.cancelOnce) {
                this.requestCancel();
                this.cancelOnce = true;
            }
        }
    }

    protected void requestCancel() {
    }

    private boolean requestingCancel() {
        return this.requestingCancel != null && this.requestingCancel.get() || Thread.interrupted();
    }

    protected void performRequestingCancel() {
    }
}

