/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri;

import org.apache.jena.iri.IRIComponents;
import org.apache.jena.iri.impl.Force;
import org.apache.jena.iri.impl.SchemeSpecification;
import org.apache.jena.iri.impl.Specification;
import org.apache.jena.iri.impl.ViolationCodeInfo;

public interface ViolationCodes {
    public static final int ILLEGAL_CHARACTER = 0;
    public static final int PERCENT_ENCODING_SHOULD_BE_UPPERCASE = 1;
    public static final int SUPERFLUOUS_NON_ASCII_PERCENT_ENCODING = 2;
    public static final int SUPERFLUOUS_ASCII_PERCENT_ENCODING = 3;
    public static final int UNWISE_CHARACTER = 4;
    public static final int CONTROL_CHARACTER = 5;
    public static final int NON_XML_CHARACTER = 6;
    public static final int DISCOURAGED_XML_CHARACTER = 7;
    public static final int NON_INITIAL_DOT_SEGMENT = 8;
    public static final int EMPTY_SCHEME = 9;
    public static final int SCHEME_MUST_START_WITH_LETTER = 10;
    public static final int LOWERCASE_PREFERRED = 11;
    public static final int PORT_SHOULD_NOT_BE_EMPTY = 12;
    public static final int DEFAULT_PORT_SHOULD_BE_OMITTED = 13;
    public static final int PORT_SHOULD_NOT_BE_WELL_KNOWN = 14;
    public static final int PORT_SHOULD_NOT_START_IN_ZERO = 15;
    public static final int BIDI_FORMATTING_CHARACTER = 16;
    public static final int WHITESPACE = 17;
    public static final int DOUBLE_WHITESPACE = 18;
    public static final int NOT_XML_SCHEMA_WHITESPACE = 19;
    public static final int DOUBLE_DASH_IN_REG_NAME = 20;
    public static final int SCHEME_INCLUDES_DASH = 21;
    public static final int NON_URI_CHARACTER = 22;
    public static final int PERCENT_20 = 23;
    public static final int PERCENT = 24;
    public static final int IP_V6_OR_FUTURE_ADDRESS_SYNTAX = 25;
    public static final int IPv6ADDRESS_SHOULD_BE_LOWERCASE = 26;
    public static final int IP_V4_OCTET_RANGE = 27;
    public static final int NOT_DNS_NAME = 28;
    public static final int USE_PUNYCODE_NOT_PERCENTS = 29;
    public static final int ILLEGAL_PERCENT_ENCODING = 30;
    public static final int ACE_PREFIX = 31;
    public static final int LONE_SURROGATE = 32;
    public static final int DNS_LABEL_DASH_START_OR_END = 33;
    public static final int BAD_IDN_UNASSIGNED_CHARS = 34;
    public static final int BAD_IDN = 35;
    public static final int HAS_PASSWORD = 36;
    public static final int DISCOURAGED_IRI_CHARACTER = 37;
    public static final int BAD_BIDI_SUBCOMPONENT = 38;
    public static final int DNS_LENGTH_LIMIT = 39;
    public static final int DNS_LABEL_LENGTH_LIMIT = 40;
    public static final int NOT_UTF8_ESCAPE = 41;
    public static final int NOT_UTF8_ESCAPE_IN_HOST = 42;
    public static final int BAD_DOT_IN_IDN = 43;
    public static final int UNREGISTERED_IANA_SCHEME = 44;
    public static final int UNREGISTERED_NONIETF_SCHEME_TREE = 45;
    public static final int NOT_NFC = 46;
    public static final int NOT_NFKC = 47;
    public static final int DEPRECATED_UNICODE_CHARACTER = 48;
    public static final int UNDEFINED_UNICODE_CHARACTER = 49;
    public static final int PRIVATE_USE_CHARACTER = 50;
    public static final int UNICODE_CONTROL_CHARACTER = 51;
    public static final int UNASSIGNED_UNICODE_CHARACTER = 52;
    public static final int MAYBE_NOT_NFC = 53;
    public static final int MAYBE_NOT_NFKC = 54;
    public static final int UNICODE_WHITESPACE = 55;
    public static final int COMPATIBILITY_CHARACTER = 56;
    public static final int REQUIRED_COMPONENT_MISSING = 57;
    public static final int PROHIBITED_COMPONENT_PRESENT = 58;
    public static final int SCHEME_REQUIRES_LOWERCASE = 59;
    public static final int SCHEME_PREFERS_LOWERCASE = 60;
    public static final int SCHEME_PATTERN_MATCH_FAILED = 61;
    public static final int QUERY_IN_LEGACY_SCHEME = 62;

    public static class Initialize
    implements IRIComponents,
    Force {
        static {
            Specification spec = new Specification("RDF", "iri", "", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref", "Resource Description Framework (RDF): Concepts and Abstract Syntax", "RDF URI References", new String[]{"foo/bar", "#frag", "//example.org/foo/bar#frag"}, new String[0]);
            spec.require(2);
            spec = new Specification("URI", "iri", "3986", "http://www.apps.ietf.org/rfc/rfc3986.html", "Uniform Resource Identifier (URI): Generic Syntax", "", new String[0], new String[0]);
            spec = new Specification("Unicode", "iri", "", "http://www.unicode.org/", "Unicode", "", new String[0], new String[0]);
            spec = new Specification("IRI", "iri", "3987", "http://www.apps.ietf.org/rfc/rfc3987.html", "Internationalized Resource Identifiers (IRIs)", "", new String[0], new String[0]);
            spec = new Specification("XML", "iri", "", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid", "Extensible Markup Language (XML) 1.0 (Third Edition)", "system identifier", new String[0], new String[0]);
            spec.prohibit(15);
            spec = new Specification("XLink", "iri", "", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators", "XML Linking Language (XLink) Version 1.0", "Locator Attribute (href)", new String[0], new String[0]);
            spec = new Specification("Schema", "iri", "", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI", "XML Schema Part 2: Datatypes Second Edition", "anyURI", new String[0], new String[0]);
            spec = new Specification("URL_Registratrion", "other", "2717", "http://www.apps.ietf.org/rfc/rfc2717.html", "Registration Procedures for URL Scheme Names", "", new String[0], new String[0]);
            spec = new SchemeSpecification("http", "2616", "http://www.apps.ietf.org/rfc/rfc2616.html", "Hypertext Transfer Protocol -- HTTP/1.1", "", new String[]{"http://www.example.org:80/foo/bar", "http:foo/bar", "http://user@www.example.org/foo/bar"}, new String[]{"http://www.example.org/foo/bar"});
            spec.addDefinition("http://www.apps.ietf.org/rfc/rfc2616.html#sec-3.2.2", "\nhttp_URL = \"http:\" \"//\" host [ \":\" port ] [ abs_path [ \"?\" query ]]\n", "</p><pre>\nhttp_URL = \"http:\" \"//\" host [ \":\" port ] [ abs_path [ \"?\" query ]]\n</pre><p>");
            spec.setDNS(true);
            spec.port(80);
            spec.prohibit(6);
            spec.require(7);
            spec = new SchemeSpecification("https", "2818", "http://www.apps.ietf.org/rfc/rfc2818.html", "Hypertext Transfer Protocol Secure", "", new String[]{"https://www.example.org:443/foo/bar", "https:foo/bar", "https://user@www.example.org/foo/bar"}, new String[]{"https://www.example.org/foo/bar"});
            spec.addDefinition("http://www.apps.ietf.org/rfc/rfc2818.html#sec-2.4", "HTTP/TLS is differentiated from HTTP URIs by using the 'https' protocol identifier in place of the 'http' protocol identifier.", "HTTP/TLS is differentiated from HTTP URIs by using the 'https' protocol identifier in place of the 'http' protocol identifier.");
            spec.addDefinition("http://www.apps.ietf.org/rfc/rfc2818.html#sec-3.2.2", "\nhttp_URL = \"http:\" \"//\" host [ \":\" port ] [ abs_path [ \"?\" query ]]\n", "</p><pre>\nhttp_URL = \"http:\" \"//\" host [ \":\" port ] [ abs_path [ \"?\" query ]]\n</pre><p>");
            spec.setDNS(true);
            spec.port(443);
            spec.prohibit(6);
            spec.require(7);
            spec = new SchemeSpecification("ftp", "1738", "http://www.apps.ietf.org/rfc/rfc1738.html#sec-3.2", "File Transfer Protocol", "3.2", new String[]{"ftp:///foo/bar", "ftp://user@example.org/foo/bar;type=z", "ftp://user@example.org/foo/b;ar;type=d"}, new String[]{"ftp://user@example.org/foo/bar;type=d"});
            spec.addDefinition("http://www.apps.ietf.org/rfc/rfc1738.html#sec-5", "\nftpurl = \"ftp://\" login [ \"/\" fpath [ \";type=\" ftptype ]]\nfpath = fsegment *[ \"/\" fsegment ]\nfsegment = *[ uchar | \"?\" | \":\" | \"@\" | \"&amp;\" | \"=\" ]\nftptype = \"A\" | \"I\" | \"D\" | \"a\" | \"i\" | \"d\"\n\nlogin = [ user [ \":\" password ] \"@\" ] hostport\n\nsafe = \"$\" | \"-\" | \"_\" | \".\" | \"+\"\nextra = \"!\" | \"*\" | \"'\" | \"(\" | \")\" | \",\"\nescape = \"%\" hex hex\nunreserved = alpha | digit | safe | extra\nuchar = unreserved | escape\n", "</p><pre>\nftpurl = \"ftp://\" login [ \"/\" fpath [ \";type=\" ftptype ]]\nfpath = fsegment *[ \"/\" fsegment ]\nfsegment = *[ uchar | \"?\" | \":\" | \"@\" | \"&amp;\" | \"=\" ]\nftptype = \"A\" | \"I\" | \"D\" | \"a\" | \"i\" | \"d\"\n</pre><p></p><pre>\nlogin = [ user [ \":\" password ] \"@\" ] hostport\n</pre><p></p><pre>\nsafe = \"$\" | \"-\" | \"_\" | \".\" | \"+\"\nextra = \"!\" | \"*\" | \"'\" | \"(\" | \")\" | \",\"\nescape = \"%\" hex hex\nunreserved = alpha | digit | safe | extra\nuchar = unreserved | escape\n</pre><p>");
            spec.setDNS(true);
            spec.port(21);
            spec.require(7);
            spec.setPattern(31, "[^;~]*(;@{mustLowerCase(type)}=@{shouldLowerCase([aid])}|)");
            spec.setReserved(31, "~;");
            spec = new SchemeSpecification("mailto", "2368", "http://www.apps.ietf.org/rfc/rfc2368.html", "Electronic mail address", "", new String[0], new String[0]);
            spec.prohibit(4);
            spec = new SchemeSpecification("news", "1738", "http://www.apps.ietf.org/rfc/rfc1738.html#sec-3.6", "USENET news", "3.6", new String[]{"news:arbitrary@news.exampl\u00e7.org", "news:arbitr?ary@news.exampl\u00e7.org", "news:///foo/bar", "news://user@example.org/foo"}, new String[]{"news:*", "news:group.it", "news:arb?itrary@news.example.org", "news:arbitrary@news.example.org"});
            spec.addDefinition("http://www.apps.ietf.org/rfc/rfc1738.html#sec-5", "\nnewsurl = \"news:\" grouppart\ngrouppart = \"*\" | group | article\ngroup = alpha *[ alpha | digit | \"-\" | \".\" | \"+\" | \"_\" ]\narticle = 1*[ uchar | \";\" | \"/\" | \"?\" | \":\" | \"&amp;\" | \"=\" ] \"@\" host\n\nsafe = \"$\" | \"-\" | \"_\" | \".\" | \"+\"\nextra = \"!\" | \"*\" | \"'\" | \"(\" | \")\" | \",\"\nescape = \"%\" hex hex\nunreserved = alpha | digit | safe | extra\nuchar = unreserved | escape\n", "</p><pre>\nnewsurl = \"news:\" grouppart\ngrouppart = \"*\" | group | article\ngroup = alpha *[ alpha | digit | \"-\" | \".\" | \"+\" | \"_\" ]\narticle = 1*[ uchar | \";\" | \"/\" | \"?\" | \":\" | \"&amp;\" | \"=\" ] \"@\" host\n</pre><p></p><pre>\nsafe = \"$\" | \"-\" | \"_\" | \".\" | \"+\"\nextra = \"!\" | \"*\" | \"'\" | \"(\" | \")\" | \",\"\nescape = \"%\" hex hex\nunreserved = alpha | digit | safe | extra\nuchar = unreserved | escape\n</pre><p>");
            spec.prohibit(4);
            spec.require(11);
            spec.setPattern(31, "[^@]+@@{host}|[*]|[a-zA-Z][-a-zA-Z0-9.+_]*");
            spec.setReserved(31, "~@");
            spec = new SchemeSpecification("nntp", "1738", "http://www.apps.ietf.org/rfc/rfc1738.html#sec-3.7", "USENET news using NNTP access", "3.7", new String[]{"nntp://user@example.org/foo", "nntp:/foo", "nntp:///foo", "nntp://example.org/foo/4/3", "nntp://example.org/", "nntp://example.org/foo/", "nntp://example.org/*"}, new String[]{"nntp://example.org/foo4", "nntp://example.org/foo/4"});
            spec.addDefinition("http://www.apps.ietf.org/rfc/rfc1738.html#sec-5", "\nnntpurl = \"nntp://\" hostport \"/\" group [ \"/\" digits ]\n\ngroup = alpha *[ alpha | digit | \"-\" | \".\" | \"+\" | \"_\" ]\n", "</p><pre>\nnntpurl = \"nntp://\" hostport \"/\" group [ \"/\" digits ]\n</pre><p></p><pre>\ngroup = alpha *[ alpha | digit | \"-\" | \".\" | \"+\" | \"_\" ]\n</pre><p>");
            spec.setDNS(true);
            spec.port(119);
            spec.prohibit(13);
            spec.prohibit(6);
            spec.require(7);
            spec.setPattern(11, "/[a-zA-Z][-a-zA-Z0-9.+_]*(/[0-9]+)?");
            spec = new SchemeSpecification("telnet", "4248", "http://www.ietf.org/rfc/rfc4248.txt", "Reference to interactive sessions", "", new String[0], new String[0]);
            spec = new SchemeSpecification("wais", "4156", "http://www.ietf.org/rfc/rfc4156.txt", "Wide Area Information Servers", "", new String[0], new String[0]);
            spec = new SchemeSpecification("file", "8089", "https://tools.ietf.org/html/rfc8089", "The \"file\" URI Scheme", "", new String[]{"file://user@example.org/foo/bar", "file://eg:4029/foo/bar", "file:/foo/bar", "file://example.org"}, new String[]{"file:///foo/b", "file:///foo/b?ar/yuk"});
            spec.addDefinition("https://tools.ietf.org/html/rfc8089", "", "");
            spec.setDNS(true);
            spec.prohibit(6);
            spec.prohibit(10);
            spec.require(11);
            spec.require(4);
            spec.setPattern(31, "[^;~]*");
            spec.setReserved(31, "~;");
            spec = new SchemeSpecification("prospero", "4157", "http://www.ietf.org/rfc/rfc4157.txt", "Prospero Directory Service", "", new String[0], new String[0]);
            spec = new SchemeSpecification("gopher", "4266", "http://www.ietf.org/rfc/rfc4266.txt", "The gopher URI scheme", "", new String[0], new String[0]);
            spec = new SchemeSpecification("z39.50s", "2056", "http://www.apps.ietf.org/rfc/rfc2056.html", "Z39.50 Session", "", new String[0], new String[0]);
            spec = new SchemeSpecification("z39.50r", "2056", "http://www.apps.ietf.org/rfc/rfc2056.html", "Z39.50 Retrieval", "", new String[0], new String[0]);
            spec = new SchemeSpecification("cid", "2392", "http://www.apps.ietf.org/rfc/rfc2392.html", "content identifier", "", new String[0], new String[0]);
            spec = new SchemeSpecification("mid", "2392", "http://www.apps.ietf.org/rfc/rfc2392.html", "message identifier", "", new String[0], new String[0]);
            spec = new SchemeSpecification("vemmi", "2122", "http://www.apps.ietf.org/rfc/rfc2122.html", "versatile multimedia interface", "", new String[0], new String[0]);
            spec = new SchemeSpecification("service", "2609", "http://www.apps.ietf.org/rfc/rfc2609.html", "service location", "", new String[0], new String[0]);
            spec = new SchemeSpecification("imap", "2192", "http://www.apps.ietf.org/rfc/rfc2192.html", "internet message access protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("nfs", "2224", "http://www.apps.ietf.org/rfc/rfc2224.html", "network file system protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("acap", "2244", "http://www.apps.ietf.org/rfc/rfc2244.html", "application configuration access protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("rtsp", "2326", "http://www.apps.ietf.org/rfc/rfc2326.html", "real time streaming protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("tip", "2371", "http://www.apps.ietf.org/rfc/rfc2371.html", "Transaction Internet Protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("pop", "2384", "http://www.apps.ietf.org/rfc/rfc2384.html", "Post Office Protocol v3", "", new String[0], new String[0]);
            spec = new SchemeSpecification("data", "2397", "http://www.apps.ietf.org/rfc/rfc2397.html", "data", "", new String[0], new String[0]);
            spec = new SchemeSpecification("dav", "2518", "http://www.apps.ietf.org/rfc/rfc2518.html", "dav", "", new String[0], new String[0]);
            spec = new SchemeSpecification("opaquelocktoken", "2518", "http://www.apps.ietf.org/rfc/rfc2518.html", "opaquelocktoken", "", new String[0], new String[0]);
            spec = new SchemeSpecification("sip", "3261", "http://www.apps.ietf.org/rfc/rfc3261.html", "session initiation protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("sips", "3261", "http://www.apps.ietf.org/rfc/rfc3261.html", "secure session intitiaion protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("tel", "2806", "http://www.apps.ietf.org/rfc/rfc2806.html", "telephone", "", new String[0], new String[0]);
            spec = new SchemeSpecification("fax", "2806", "http://www.apps.ietf.org/rfc/rfc2806.html", "fax", "", new String[0], new String[0]);
            spec = new SchemeSpecification("modem", "2806", "http://www.apps.ietf.org/rfc/rfc2806.html", "modem", "", new String[0], new String[0]);
            spec = new SchemeSpecification("soap.beep", "3288", "http://www.apps.ietf.org/rfc/rfc3288.html", "soap.beep", "", new String[0], new String[0]);
            spec = new SchemeSpecification("soap.beeps", "3288", "http://www.apps.ietf.org/rfc/rfc3288.html", "soap.beeps", "", new String[0], new String[0]);
            spec = new SchemeSpecification("xmlrpc.beep", "3529", "http://www.apps.ietf.org/rfc/rfc3529.html", "xmlrpc.beep", "", new String[0], new String[0]);
            spec = new SchemeSpecification("xmlrpc.beeps", "3529", "http://www.apps.ietf.org/rfc/rfc3529.html", "xmlrpc.beeps", "", new String[0], new String[0]);
            spec = new SchemeSpecification("urn", "2141", "http://www.apps.ietf.org/rfc/rfc2141.html", "Uniform Resource Names", "", new String[]{"urn:urn:foo", "urn://foo", "urn:foo:bar?query"}, new String[]{"urn:x-hp:foo\u00e9", "urn:urn-1:foo", "urn:urn-1:a/b/c"});
            spec.addDefinition("http://www.apps.ietf.org/rfc/rfc2141.html#sec-2", "All URNs have the following syntax (phrases enclosed in quotes are REQUIRED):\n<URN&gt; ::= \"urn:\" <NID&gt; \":\" <NSS&gt;\n", "All URNs have the following syntax (phrases enclosed in quotes are REQUIRED):</p><pre>\n&lt;URN&gt; ::= \"urn:\" &lt;NID&gt; \":\" &lt;NSS&gt;\n</pre><p>");
            spec.addDefinition("http://www.apps.ietf.org/rfc/rfc2141.html#sec-2.1", "\n<NID&gt;         ::= <let-num&gt; [ 1,31<let-num-hyp&gt; ]\n\n<let-num-hyp&gt; ::= <upper&gt; | <lower&gt; | <number&gt; | \"-\"\n\n<let-num&gt;     ::= <upper&gt; | <lower&gt; | <number&gt;\n", "</p><pre>\n&lt;NID&gt;         ::= &lt;let-num&gt; [ 1,31&lt;let-num-hyp&gt; ]\n\n&lt;let-num-hyp&gt; ::= &lt;upper&gt; | &lt;lower&gt; | &lt;number&gt; | \"-\"\n\n&lt;let-num&gt;     ::= &lt;upper&gt; | &lt;lower&gt; | &lt;number&gt;\n</pre><p>");
            spec.addDefinition("http://www.apps.ietf.org/rfc/rfc2141.html#sec-2.2", "\n<NSS&gt;         ::= 1*<URN chars&gt;\n\n<URN chars&gt;   ::= <trans&gt; | \"%\" <hex&gt; <hex&gt;\n\n<trans&gt;       ::= <upper&gt; | <lower&gt; | <number&gt; | <other&gt; | <reserved&gt;\n\n<other&gt;       ::= \"(\" | \")\" | \"+\" | \",\" | \"-\" | \".\" |\n                  \":\" | \"=\" | \"@\" | \";\" | \"$\" |\n                  \"_\" | \"!\" | \"*\" | \"'\"\n", "</p><pre>\n&lt;NSS&gt;         ::= 1*&lt;URN chars&gt;\n\n&lt;URN chars&gt;   ::= &lt;trans&gt; | \"%\" &lt;hex&gt; &lt;hex&gt;\n\n&lt;trans&gt;       ::= &lt;upper&gt; | &lt;lower&gt; | &lt;number&gt; | &lt;other&gt; | &lt;reserved&gt;\n\n&lt;other&gt;       ::= \"(\" | \")\" | \"+\" | \",\" | \"-\" | \".\" |\n                  \":\" | \"=\" | \"@\" | \";\" | \"$\" |\n                  \"_\" | \"!\" | \"*\" | \"'\"\n</pre><p>");
            spec.addDefinition("http://www.apps.ietf.org/rfc/rfc2141.html#sec-2.3.2", "RFC 1630 [2] reserves the characters \"/\", \"?\", and \"#\" for particular purposes. The URN-WG has not yet debated the applicability and precise semantics of those purposes as applied to URNs. Therefore, these characters are RESERVED for future developments. Namespace developers SHOULD NOT use these characters in unencoded form, but rather use the appropriate %-encoding for each character.", "RFC 1630 [2] reserves the characters \"/\", \"?\", and \"#\" for particular purposes. The URN-WG has not yet debated the applicability and precise semantics of those purposes as applied to URNs. Therefore, these characters are RESERVED for future developments. Namespace developers SHOULD NOT use these characters in unencoded form, but rather use the appropriate %-encoding for each character.");
            spec.prohibit(4);
            spec.require(11);
            spec.setPattern(13, "[+=].*");
            spec.setPattern(11, "(?![uU][rR][nN]:)[a-zA-Z0-9][-a-zA-Z0-9]{0,30}[a-zA-Z0-9]:.+");
            spec.setReserved(11, "/~");
            spec = new SchemeSpecification("go", "3368", "http://www.apps.ietf.org/rfc/rfc3368.html", "go", "", new String[0], new String[0]);
            spec = new SchemeSpecification("h323", "3508", "http://www.apps.ietf.org/rfc/rfc3508.html", "H.323", "", new String[0], new String[0]);
            spec = new SchemeSpecification("ipp", "3510", "http://www.apps.ietf.org/rfc/rfc3510.html", "Internet Printing Protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("tftp", "3617", "http://www.apps.ietf.org/rfc/rfc3617.html", "Trivial File Transfer Protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("mupdate", "3656", "http://www.apps.ietf.org/rfc/rfc3656.html", "Mailbox Update (MUPDATE) Protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("pres", "3859", "http://www.apps.ietf.org/rfc/rfc3859.html", "Presence", "", new String[0], new String[0]);
            spec = new SchemeSpecification("im", "3860", "http://www.apps.ietf.org/rfc/rfc3860.html", "Instant Messaging", "", new String[0], new String[0]);
            spec = new SchemeSpecification("mtqp", "3887", "http://www.apps.ietf.org/rfc/rfc3887.html", "Message Tracking Query Protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("iris.beep", "3983", "http://www.apps.ietf.org/rfc/rfc3983.html", "iris.beep", "", new String[0], new String[0]);
            spec = new SchemeSpecification("dict", "2229", "http://www.apps.ietf.org/rfc/rfc2229.html", "dictionary service protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("snmp", "4088", "http://www.ietf.org/rfc/rfc4088.txt", "Simple Network Management Protocol", "", new String[0], new String[0]);
            spec = new SchemeSpecification("crid", "4078", "http://www.ietf.org/rfc/rfc4078.txt", "TV-Anytime Content Reference Identifier", "", new String[0], new String[0]);
            spec = new SchemeSpecification("tag", "4151", "http://www.ietf.org/rfc/rfc4151.txt", "tag", "", new String[0], new String[0]);
            spec = new SchemeSpecification("afs", "", "http://www.iana.org/assignments/uri-schemes", "Andrew File System global file names", "", new String[0], new String[0]);
            spec = new SchemeSpecification("tn3270", "", "http://www.iana.org/assignments/uri-schemes", "Interactive 3270 emulation sessions", "", new String[0], new String[0]);
            spec = new SchemeSpecification("mailserver", "", "http://www.iana.org/assignments/uri-schemes", "Access to data available from mail servers", "", new String[0], new String[0]);
            spec = new SchemeSpecification("dns", "", "http://www.iana.org/assignments/uri-schemes", "Domain Name System", "", new String[0], new String[0]);
            spec = new SchemeSpecification("info", "", "http://www.iana.org/assignments/uri-schemes", "Information Assets with Identifiers in Public Namespaces", "", new String[0], new String[0]);
            spec = new SchemeSpecification("ldap", "", "http://www.iana.org/assignments/uri-schemes", "Lightweight Directory Access Protocol", "", new String[0], new String[0]);
            new ViolationCodeInfo(0, "ILLEGAL_CHARACTER", "The character violates the grammar rules for URIs/IRIs.", "<p>The character violates the grammar rules for URIs/IRIs.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromAlso("URI", "http://www.apps.ietf.org/rfc/rfc3986.html#page-49"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html#sec-2.2"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"ht$tp://example.org/foo"}, new String[0], false);
            new ViolationCodeInfo(1, "PERCENT_ENCODING_SHOULD_BE_UPPERCASE", "Percent-escape sequences should use uppercase.", "<p>Percent-escape sequences should use uppercase.</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-2.1", "URI producers and normalizers should use *uppercase* hexadecimal digits for all percent-encodings.", "<p>URI producers and normalizers should use <em>uppercase</em> hexadecimal digits for all percent-encodings.</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://example.org/foo%c3%80"}, new String[0], false);
            new ViolationCodeInfo(2, "SUPERFLUOUS_NON_ASCII_PERCENT_ENCODING", "Percent-escape sequences should not be used unnecessarily.", "<p>Percent-escape sequences should not be used unnecessarily.</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("IRI", -1, "http://www.apps.ietf.org/rfc/rfc3987.html#sec-3.2", "URI-to-IRI conversion removes percent-encodings", "<p>URI-to-IRI conversion removes percent-encodings</p>")}, new String[]{"http://example.org/foo%C3%A9r"}, new String[0], true);
            new ViolationCodeInfo(3, "SUPERFLUOUS_ASCII_PERCENT_ENCODING", "Percent-escape sequences should not be used unnecessarily.", "<p>Percent-escape sequences should not be used unnecessarily.</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-2.3", "For consistency, percent-encoded octets in the ranges of ALPHA (%41-%5A and %61-%7A), DIGIT (%30-%39), hyphen (%2D), period (%2E), underscore (%5F), or tilde (%7E) should not be created by URI producers", "<p>For consistency, percent-encoded octets in the ranges of ALPHA (%41-%5A and %61-%7A), DIGIT (%30-%39), hyphen (%2D), period (%2E), underscore (%5F), or tilde (%7E) should not be created by URI producers</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://example.org/foo%5Fb%61r"}, new String[0], true);
            new ViolationCodeInfo(4, "UNWISE_CHARACTER", "The character matches no grammar rules of URIs/IRIs. These characters are permitted in RDF URI References, XML system identifiers, and XML Schema anyURIs.", "<p>The character matches no grammar rules of URIs/IRIs. These characters are permitted in RDF URI References, XML system identifiers, and XML Schema anyURIs.</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("IRI", -1, "http://www.apps.ietf.org/rfc/rfc3987.html#page-13", "Systems accepting IRIs MAY also deal with the printable characters in US-ASCII that are not allowed in URIs, namely \"<\", \"&gt;\", '\"', space, \"{\", \"}\", \"|\", \"\\\", \"^\", and \"`\", in step 2 above. If these characters are found but are not converted, then the conversion SHOULD fail.", "<p>Systems accepting IRIs MAY also deal with the printable characters in US-ASCII that are not allowed in URIs, namely \"&lt;\", \"&gt;\", '\"', space, \"{\", \"}\", \"|\", \"\\\", \"^\", and \"`\", in step 2 above. If these characters are found but are not converted, then the conversion SHOULD fail.</p>"), new ViolationCodeInfo.FromAlso("URI", "http://www.apps.ietf.org/rfc/rfc3986.html#page-49")}, new String[]{"http://example.org/fo|o", "http://example.org/fo<o", "http://example.org/fo\"o", "http://example.org/fo`o"}, new String[0], false);
            new ViolationCodeInfo(5, "CONTROL_CHARACTER", "Control characters are not allowed in URIs or RDF URI References.", "<p>Control characters are not allowed in URIs or RDF URI References.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("RDF", -1, "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref", "A URI reference within an RDF graph (an RDF URI reference) is a Unicode string [UNICODE] that: (0)does not contain any control characters ( #x00 - #x1F, #x7F-#x9F) ", "<p>A URI reference within an RDF graph (an RDF URI reference) is a Unicode string [UNICODE] that:</p><ul> <li>does not contain any control characters ( #x00 - #x1F, #x7F-#x9F)</li> </ul><p></p>"), new ViolationCodeInfo.FromSpec_iri("IRI", -1, "http://www.apps.ietf.org/rfc/rfc3987.html", "\nucschar = %xA0-D7FF / %xF900-FDCF / %xFDF0-FFEF\n        / %x10000-1FFFD / %x20000-2FFFD / %x30000-3FFFD\n        / %x40000-4FFFD / %x50000-5FFFD / %x60000-6FFFD\n        / %x70000-7FFFD / %x80000-8FFFD / %x90000-9FFFD\n        / %xA0000-AFFFD / %xB0000-BFFFD / %xC0000-CFFFD\n        / %xD0000-DFFFD / %xE1000-EFFFD\n", "<p></p><pre>\nucschar = %xA0-D7FF / %xF900-FDCF / %xFDF0-FFEF\n        / %x10000-1FFFD / %x20000-2FFFD / %x30000-3FFFD\n        / %x40000-4FFFD / %x50000-5FFFD / %x60000-6FFFD\n        / %x70000-7FFFD / %x80000-8FFFD / %x90000-9FFFD\n        / %xA0000-AFFFD / %xB0000-BFFFD / %xC0000-CFFFD\n        / %xD0000-DFFFD / %xE1000-EFFFD\n</pre><p></p>"), new ViolationCodeInfo.FromAlso("URI", "http://www.apps.ietf.org/rfc/rfc3986.html")}, new String[]{"http://example.org/fo\u007fo", "http://example.org/fo\u0085o", "http://example.org/fo\to", "http://example.org/fo\u0001o"}, new String[0], false);
            new ViolationCodeInfo(6, "NON_XML_CHARACTER", "The character is not legal in XML.", "<p>The character is not legal in XML.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("XML", -1, "http://www.w3.org/TR/2004/REC-xml-20040204/#NT-Char", "Char ::= #x9 | #xA | #xD | [#x20-#xD7FF] | [#xE000-#xFFFD] | [#x10000-#x10FFFF]", "<p>Char ::= #x9 | #xA | #xD | [#x20-#xD7FF] | [#xE000-#xFFFD] | [#x10000-#x10FFFF]</p>"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://example.org/foo\u0001"}, new String[0], false);
            new ViolationCodeInfo(7, "DISCOURAGED_XML_CHARACTER", "The character is discouraged in XML documents.", "<p>The character is discouraged in XML documents.</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("XML", -1, "http://www.w3.org/TR/2004/REC-xml-20040204/#char32", "Document authors are encouraged to avoid \"compatibility characters\", as defined in section 6.8 of [Unicode] (see also D21 in section 3.6 of [Unicode3]). The characters defined in the following ranges are also discouraged. They are either control characters or permanently undefined Unicode characters: [#x7F-#x84], [#x86-#x9F], [#xFDD0-#xFDDF],", "<p>Document authors are encouraged to avoid \"compatibility characters\", as defined in section 6.8 of [Unicode] (see also D21 in section 3.6 of [Unicode3]). The characters defined in the following ranges are also discouraged. They are either control characters or permanently undefined Unicode characters: [#x7F-#x84], [#x86-#x9F], [#xFDD0-#xFDDF],</p>"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://example.org/foo\u0080"}, new String[0], false);
            new ViolationCodeInfo(8, "NON_INITIAL_DOT_SEGMENT", "The path contains a segment /../ not at the beginning of a relative reference, or it contains a /./ These should be removed.", "<p>The path contains a segment /../ not at the beginning of a relative reference, or it contains a /./ These should be removed.</p>", 12, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-6.2.2.3", "The complete path segments \".\" and \"..\" are intended *only* for use within relative references", "<p>The complete path segments \".\" and \"..\" are intended <em>only</em> for use within relative references</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://example.org/../foo", "http://example.org/foo/../foo", "http://example.org/foo/..", "http://example.org/foo/./foo", "http://example.org/./foo", "http://example.org/foo/."}, new String[0], false);
            new ViolationCodeInfo(9, "EMPTY_SCHEME", "The scheme component is empty.", "<p>The scheme component is empty.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.1", "Scheme names consist of a sequence of characters *beginning with a letter* and followed by any combination of letters, digits, plus (\"+\"), period (\".\"), or hyphen (\"-\").", "<p>Scheme names consist of a sequence of characters <em>beginning with a letter</em> and followed by any combination of letters, digits, plus (\"+\"), period (\".\"), or hyphen (\"-\").</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"://example.org/foo"}, new String[0], false);
            new ViolationCodeInfo(10, "SCHEME_MUST_START_WITH_LETTER", "The scheme component must start with a letter.", "<p>The scheme component must start with a letter.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.1", "Scheme names consist of a sequence of characters *beginning with a letter* and followed by any combination of letters, digits, plus (\"+\"), period (\".\"), or hyphen (\"-\").", "<p>Scheme names consist of a sequence of characters <em>beginning with a letter</em> and followed by any combination of letters, digits, plus (\"+\"), period (\".\"), or hyphen (\"-\").</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"007://example.org/foo"}, new String[0], false);
            new ViolationCodeInfo(11, "LOWERCASE_PREFERRED", "lowercase is preferred in this component", "<p>lowercase is preferred in this component</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", 2, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.1", "An implementation should accept uppercase letters as equivalent to lowercase in scheme names (e.g., allow \"HTTP\" as well as \"http\") for the sake of robustness but should only produce lowercase scheme names for consistency.", "<p>An implementation should accept uppercase letters as equivalent to lowercase in scheme names (e.g., allow \"HTTP\" as well as \"http\") for the sake of robustness but should only produce lowercase scheme names for consistency.</p>"), new ViolationCodeInfo.FromSpec_iri("URI", 7, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.2", "Although host is case-insensitive, producers and normalizers should use *lowercase for registered names* and hexadecimal addresses for the sake of uniformity, while only using uppercase letters for percent-encodings.", "<p>Although host is case-insensitive, producers and normalizers should use <em>lowercase for registered names</em> and hexadecimal addresses for the sake of uniformity, while only using uppercase letters for percent-encodings.</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"HTTP://example.org/foo", "http://eXamPle.org/foo"}, new String[0], false);
            new ViolationCodeInfo(12, "PORT_SHOULD_NOT_BE_EMPTY", "The colon introducing an empty port component should be omitted entirely, or a port number should be specified.", "<p>The colon introducing an empty port component should be omitted entirely, or a port number should be specified.</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.2", "URI producers and normalizers should omit the port component *and its \":\" delimiter* if port is empty", "<p>URI producers and normalizers should omit the port component <em>and its \":\" delimiter</em> if port is empty</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://example.org:/foo"}, new String[0], false);
            new ViolationCodeInfo(13, "DEFAULT_PORT_SHOULD_BE_OMITTED", "If the port is the default one for the scheme it should be omitted.", "<p>If the port is the default one for the scheme it should be omitted.</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.2", "URI producers and normalizers should omit the port component and its \":\" delimiter if port is empty or if its value would be the *same as that of the scheme's default.* ", "<p>URI producers and normalizers should omit the port component and its \":\" delimiter if port is empty or if its value would be the <em>same as that of the scheme's default.</em> </p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://example.org:80/foo"}, new String[0], false);
            new ViolationCodeInfo(14, "PORT_SHOULD_NOT_BE_WELL_KNOWN", "Ports under 1024 should be accessed using the appropriate scheme name.", "<p>Ports under 1024 should be accessed using the appropriate scheme name.</p>", 8, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-7.2", "Applications should prevent dereference of a URI that specifies a TCP port number within the \"well-known port\" range *(0 - 1023)* unless the protocol being used to dereference that URI is compatible with the protocol expected on that well-known port.", "<p>Applications should prevent dereference of a URI that specifies a TCP port number within the \"well-known port\" range <em>(0 - 1023)</em> unless the protocol being used to dereference that URI is compatible with the protocol expected on that well-known port.</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://example.org:180/foo"}, new String[0], false);
            new ViolationCodeInfo(15, "PORT_SHOULD_NOT_START_IN_ZERO", "Leading zeros in the port number should be omitted. This is an added feature of this implementation, not mandated by any standard.", "<p>Leading zeros in the port number should be omitted. This is an added feature of this implementation, not mandated by any standard.</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromAlso("URI", "http://www.apps.ietf.org/rfc/rfc3986.html"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://example.org:08080/foo"}, new String[0], false);
            new ViolationCodeInfo(16, "BIDI_FORMATTING_CHARACTER", "A prohibited bi-directional control character was found.", "<p>A prohibited bi-directional control character was found.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("IRI", -1, "http://www.apps.ietf.org/rfc/rfc3987.html#sec-4.1", "IRIs MUST NOT contain bidirectional formatting characters (LRM, RLM, LRE, RLE, LRO, RLO, and PDF).", "<p>IRIs MUST NOT contain bidirectional formatting characters (LRM, RLM, LRE, RLE, LRO, RLO, and PDF).</p>")}, new String[]{"http://example.org/Andr\u202abar", "http://example.org/Andr\u202bbar", "http://example.org/Andr\u202cbar", "http://example.org/Andr\u202dbar", "http://example.org/Andr\u202ebar", "http://example.org/Andr\u200ebar", "http://example.org/Andr\u200fbar"}, new String[0], true);
            new ViolationCodeInfo(17, "WHITESPACE", "A single whitespace character. These match no grammar rules of URIs/IRIs. These characters are permitted in RDF URI References, XML system identifiers, and XML Schema anyURIs.", "<p>A single whitespace character. These match no grammar rules of URIs/IRIs. These characters are permitted in RDF URI References, XML system identifiers, and XML Schema anyURIs.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromAlso("URI", "http://www.apps.ietf.org/rfc/rfc3986.html"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html")}, new String[]{"http://example.org/ foo", "file:///Program Files"}, new String[0], false);
            new ViolationCodeInfo(18, "DOUBLE_WHITESPACE", "Either two or more consecutive whitespace characters, or leading or trailing whitespace. These match no grammar rules of URIs/IRIs. These characters are permitted in RDF URI References, XML system identifiers, but not XML Schema anyURIs.", "<p>Either two or more consecutive whitespace characters, or leading or trailing whitespace. These match no grammar rules of URIs/IRIs. These characters are permitted in RDF URI References, XML system identifiers, but not XML Schema anyURIs.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromAlso("URI", "http://www.apps.ietf.org/rfc/rfc3986.html"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://example.org/  foo", "file:///Program  Files", "file:///TabBar ", " rel-with-initial-space"}, new String[0], false);
            new ViolationCodeInfo(19, "NOT_XML_SCHEMA_WHITESPACE", "Whitespace characters match no grammar rules of URIs/IRIs. These characters are permitted in RDF URI References, and XML system identifiers. However, tab and new line characters, and consecutive space characters cannot occur in XML Schema anyURIs.", "<p>Whitespace characters match no grammar rules of URIs/IRIs. These characters are permitted in RDF URI References, and XML system identifiers. However, tab and new line characters, and consecutive space characters cannot occur in XML Schema anyURIs.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromAlso("URI", "http://www.apps.ietf.org/rfc/rfc3986.html"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromSpec_iri("Schema", -1, "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#schema", "\n<xs:simpleType name=\"anyURI\" id=\"anyURI\"&gt;\n\t\t    [...]\n    <xs:restriction base=\"xs:anySimpleType\"&gt;\n      <xs:whiteSpace fixed=\"true\" value=\"collapse\" id=\"anyURI.whiteSpace\"/&gt;\n\n    </xs:restriction&gt;\n</xs:simpleType&gt;\n", "<p></p><pre>\n&lt;xs:simpleType name=\"anyURI\" id=\"anyURI\"&gt;\n\t\t    [...]\n    &lt;xs:restriction base=\"xs:anySimpleType\"&gt;\n      &lt;xs:whiteSpace fixed=\"true\" value=\"collapse\" id=\"anyURI.whiteSpace\"/&gt;\n\n    &lt;/xs:restriction&gt;\n&lt;/xs:simpleType&gt;\n</pre><p></p>")}, new String[]{"file:///Tab\tBar", "file:///Tab\nBar", "file:///Tab\rBar"}, new String[0], false);
            new ViolationCodeInfo(20, "DOUBLE_DASH_IN_REG_NAME", new String[]{"http://foo--bar//"}, new String[0], true);
            new ViolationCodeInfo(21, "SCHEME_INCLUDES_DASH", new String[]{"ht-tp://foo.bar//", "-http://foo.bar//", "http-://foo.bar//"}, new String[0], true);
            new ViolationCodeInfo(22, "NON_URI_CHARACTER", new String[]{"http://foo-bar//\u0333a", "http://foo-b\u0333ar//"}, new String[0], true);
            new ViolationCodeInfo(23, "PERCENT_20", new String[]{"http://foo-bar//%20a"}, new String[0], true);
            new ViolationCodeInfo(24, "PERCENT", new String[]{"http://foo-bar//%AAa"}, new String[0], true);
            new ViolationCodeInfo(25, "IP_V6_OR_FUTURE_ADDRESS_SYNTAX", "A syntax violation was detected in an IP V6 (or future) address.", "<p>A syntax violation was detected in an IP V6 (or future) address.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.2", "\nIP-literal  = \"[\" ( IPv6address / IPvFuture  ) \"]\"\nIPvFuture   = \"v\" 1*HEXDIG \".\" 1*( unreserved / sub-delims / \":\" )\nIPv6address =  6( h16 \":\" ) ls32\n            /                       \"::\" 5( h16 \":\" ) ls32\n            / [               h16 ] \"::\" 4( h16 \":\" ) ls32\n            / [ *1( h16 \":\" ) h16 ] \"::\" 3( h16 \":\" ) ls32\n            / [ *2( h16 \":\" ) h16 ] \"::\" 2( h16 \":\" ) ls32\n            / [ *3( h16 \":\" ) h16 ] \"::\"    h16 \":\"   ls32\n            / [ *4( h16 \":\" ) h16 ] \"::\"              ls32\n            / [ *5( h16 \":\" ) h16 ] \"::\"              h16\n            / [ *6( h16 \":\" ) h16 ] \"::\"\n\nls32        = ( h16 \":\" h16 ) / IPv4address\n                  ; least-significant 32 bits of address\nh16         = 1*4HEXDIG \n\t\t  ; 16 bits of address represented in hexadecimal\n", "<p></p><pre>\nIP-literal  = \"[\" ( IPv6address / IPvFuture  ) \"]\"\nIPvFuture   = \"v\" 1*HEXDIG \".\" 1*( unreserved / sub-delims / \":\" )\nIPv6address =  6( h16 \":\" ) ls32\n            /                       \"::\" 5( h16 \":\" ) ls32\n            / [               h16 ] \"::\" 4( h16 \":\" ) ls32\n            / [ *1( h16 \":\" ) h16 ] \"::\" 3( h16 \":\" ) ls32\n            / [ *2( h16 \":\" ) h16 ] \"::\" 2( h16 \":\" ) ls32\n            / [ *3( h16 \":\" ) h16 ] \"::\"    h16 \":\"   ls32\n            / [ *4( h16 \":\" ) h16 ] \"::\"              ls32\n            / [ *5( h16 \":\" ) h16 ] \"::\"              h16\n            / [ *6( h16 \":\" ) h16 ] \"::\"\n\nls32        = ( h16 \":\" h16 ) / IPv4address\n                  ; least-significant 32 bits of address\nh16         = 1*4HEXDIG \n\t\t  ; 16 bits of address represented in hexadecimal\n</pre><p></p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://[/", "ldap://[20015:db8::7]/c=GB?objectClass?one", "ldap://[2001:db8:::7]/c=GB?objectClass?one"}, new String[0], false);
            new ViolationCodeInfo(26, "IPv6ADDRESS_SHOULD_BE_LOWERCASE", "IP version 6 addresses should use lowercase hexadecimal", "<p>IP version 6 addresses should use lowercase hexadecimal</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.2", "Although host is case-insensitive, producers and normalizers *should use lowercase* for registered names and *hexadecimal addresses* for the sake of uniformity", "<p>Although host is case-insensitive, producers and normalizers <em>should use lowercase</em> for registered names and <em>hexadecimal addresses</em> for the sake of uniformity</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"ldap://[2001:Db8::7]/c=GB?objectClass?one", "ldap://[2001:dB8::7]/c=GB?objectClass?one"}, new String[0], false);
            new ViolationCodeInfo(27, "IP_V4_OCTET_RANGE", "A host entry consists of four numbers, but they are not in the range 0-255, or have leading zeros.", "<p>A host entry consists of four numbers, but they are not in the range 0-255, or have leading zeros.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.2", "A host identified by an IPv4 literal address is represented in dotted-decimal notation (a sequence of *four decimal numbers* in the range *0 to 255* , separated by \".\"),", "<p>A host identified by an IPv4 literal address is represented in dotted-decimal notation (a sequence of <em>four decimal numbers</em> in the range <em>0 to 255</em> , separated by \".\"),</p>"), new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.2", "\ndec-octet   = DIGIT                 ; 0-9\n            / %x31-39 DIGIT         ; 10-99\n            / \"1\" 2DIGIT            ; 100-199\n            / \"2\" %x30-34 DIGIT     ; 200-249\n            / \"25\" %x30-35          ; 250-255\n", "<p></p><pre>\ndec-octet   = DIGIT                 ; 0-9\n            / %x31-39 DIGIT         ; 10-99\n            / \"1\" 2DIGIT            ; 100-199\n            / \"2\" %x30-34 DIGIT     ; 200-249\n            / \"25\" %x30-35          ; 250-255\n</pre><p></p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"ldap://155.00.55.102/c=GB?objectClass?one", "ldap://20.256.20.20/c=GB?objectClass?one", "ldap://20.1000.20.20/c=GB?objectClass?one", "ldap://20.010.20.20/c=GB?objectClass?one"}, new String[0], false);
            new ViolationCodeInfo(28, "NOT_DNS_NAME", "The host component did not meet the restrictions on DNS names.", "<p>The host component did not meet the restrictions on DNS names.</p>", 2, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.2", "URI producers should use names that *conform to the DNS syntax* , even when use of DNS is not immediately apparent, and should limit these names to no more than 255 characters in length.", "<p>URI producers should use names that <em>conform to the DNS syntax</em> , even when use of DNS is not immediately apparent, and should limit these names to no more than 255 characters in length.</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"ldap://foo$/c=GB?objectClass?one", "http://foo.example.$org/"}, new String[0], false);
            new ViolationCodeInfo(29, "USE_PUNYCODE_NOT_PERCENTS", "The host component used percent encoding, where punycode is preferred.", "<p>The host component used percent encoding, where punycode is preferred.</p>", 6, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.2", "URI producers should provide these registered names in the IDNA encoding, rather than a percent-encoding, if they wish to maximize interoperability with legacy URI resolvers.", "<p>URI producers should provide these registered names in the IDNA encoding, rather than a percent-encoding, if they wish to maximize interoperability with legacy URI resolvers.</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"ftp://andr%C3%A9.example.org/"}, new String[0], false);
            new ViolationCodeInfo(30, "ILLEGAL_PERCENT_ENCODING", "The host component a percent occurred without two following hexadecimal digits.", "<p>The host component a percent occurred without two following hexadecimal digits.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-2.1", "A percent-encoded octet is encoded as a character triplet, consisting of the percent character \"%\" followed by the two hexadecimal digits representing that octet's numeric value.", "<p>A percent-encoded octet is encoded as a character triplet, consisting of the percent character \"%\" followed by the two hexadecimal digits representing that octet's numeric value.</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"ftp://andr%%A9.example.org/", "ftp://andr%.example.org/", "ftp://andre.example.org/%", "ftp://andre.example.org/%A", "ftp://andre.example.org/%A?", "ftp://andre.example.org/%A#"}, new String[0], false);
            new ViolationCodeInfo(31, "ACE_PREFIX", new String[0], new String[0], true);
            new ViolationCodeInfo(32, "LONE_SURROGATE", "A unicode surrogate character that is not of a surrogate pair.", "<p>A unicode surrogate character that is not of a surrogate pair.</p>", 0, new ViolationCodeInfo.InSpec[0], new String[]{"http:/foo/p\ud800"}, new String[0], false);
            new ViolationCodeInfo(33, "DNS_LABEL_DASH_START_OR_END", "A DNS name had a - at the beginning or end.", "<p>A DNS name had a - at the beginning or end.</p>", 2, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.2", "Such a name consists of a sequence of domain labels separated by \".\", each domain label starting and ending with an alphanumeric character and possibly also containing \"-\" characters.", "<p>Such a name consists of a sequence of domain labels separated by \".\", each domain label starting and ending with an alphanumeric character and possibly also containing \"-\" characters.</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"ldap://-foo/c=GB?objectClass?one", "http://foo.example.org-/", "http://foo.example.org--/", "http://--foo.example.org/", "http://-fo-o.example.org/"}, new String[0], false);
            new ViolationCodeInfo(34, "BAD_IDN_UNASSIGNED_CHARS", "Characters used in the IRI were unassigned in the version of Unicode known by this system. They may have been assigned since.", "<p>Characters used in the IRI were unassigned in the version of Unicode known by this system. They may have been assigned since.</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.2", "When a non-ASCII registered name represents an internationalized domain name intended for resolution via the DNS, the name must be transformed to the IDNA encoding [RFC3490] prior to name lookup. URI producers should provide these registered names in the IDNA encoding, rather than a percent-encoding, if they wish to maximize interoperability with legacy URI resolvers.", "<p>When a non-ASCII registered name represents an internationalized domain name intended for resolution via the DNS, the name must be transformed to the IDNA encoding [RFC3490] prior to name lookup. URI producers should provide these registered names in the IDNA encoding, rather than a percent-encoding, if they wish to maximize interoperability with legacy URI resolvers.</p>"), new ViolationCodeInfo.FromSpec_iri("IRI", -1, "http://www.apps.ietf.org/rfc/rfc3987.html#sec-3.1", "Replace the ireg-name part of the IRI by the part converted using the ToASCII operation specified in section 4.1 of [RFC3490] on each dot-separated label, and by using U+002E (FULL STOP) as a label separator, with the flag UseSTD3ASCIIRules set to TRUE, and with the flag AllowUnassigned set to FALSE for creating IRIs and set to TRUE otherwise.", "<p>Replace the ireg-name part of the IRI by the part converted using the ToASCII operation specified in section 4.1 of [RFC3490] on each dot-separated label, and by using U+002E (FULL STOP) as a label separator, with the flag UseSTD3ASCIIRules set to TRUE, and with the flag AllowUnassigned set to FALSE for creating IRIs and set to TRUE otherwise.</p>"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://foo.example\u0221.org/"}, new String[0], false);
            new ViolationCodeInfo(35, "BAD_IDN", "The Internationalized Domain Name check failed.", "<p>The Internationalized Domain Name check failed.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.2", "When a non-ASCII registered name represents an internationalized domain name intended for resolution via the DNS, the name must be transformed to the IDNA encoding [RFC3490] prior to name lookup. URI producers should provide these registered names in the IDNA encoding, rather than a percent-encoding, if they wish to maximize interoperability with legacy URI resolvers.", "<p>When a non-ASCII registered name represents an internationalized domain name intended for resolution via the DNS, the name must be transformed to the IDNA encoding [RFC3490] prior to name lookup. URI producers should provide these registered names in the IDNA encoding, rather than a percent-encoding, if they wish to maximize interoperability with legacy URI resolvers.</p>"), new ViolationCodeInfo.FromSpec_iri("IRI", -1, "http://www.apps.ietf.org/rfc/rfc3987.html#sec-3.1", "Replace the ireg-name part of the IRI by the part converted using the ToASCII operation specified in section 4.1 of [RFC3490] on each dot-separated label, and by using U+002E (FULL STOP) as a label separator, with the flag UseSTD3ASCIIRules set to TRUE, and with the flag AllowUnassigned set to FALSE for creating IRIs and set to TRUE otherwise.", "<p>Replace the ireg-name part of the IRI by the part converted using the ToASCII operation specified in section 4.1 of [RFC3490] on each dot-separated label, and by using U+002E (FULL STOP) as a label separator, with the flag UseSTD3ASCIIRules set to TRUE, and with the flag AllowUnassigned set to FALSE for creating IRIs and set to TRUE otherwise.</p>"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://--foo.example.org/", "http://xn--andr--ep-.example.org/", "http://xn.example.\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333\u3333/"}, new String[0], false);
            new ViolationCodeInfo(36, "HAS_PASSWORD", "Including passwords in URIs is deprecated.", "<p>Including passwords in URIs is deprecated.</p>", 24, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.1", "Use of the format \"user:password\" in the userinfo field is deprecated.", "<p>Use of the format \"user:password\" in the userinfo field is deprecated.</p>"), new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2.1", "Applications may choose to ignore or reject such data when it is received as part of a reference and should reject the storage of such data in unencrypted form. The passing of authentication information in clear text has proven to be a security risk in almost every case where it has been used.", "<p>Applications may choose to ignore or reject such data when it is received as part of a reference and should reject the storage of such data in unencrypted form. The passing of authentication information in clear text has proven to be a security risk in almost every case where it has been used.</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"http://user:pass@example.org/"}, new String[0], false);
            new ViolationCodeInfo(37, "DISCOURAGED_IRI_CHARACTER", "Certain characters are discouraged in IRIs.", "<p>Certain characters are discouraged in IRIs.</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("IRI", -1, "http://www.apps.ietf.org/rfc/rfc3987.html#sec-6.1", "The UCS contains many areas of characters for which there are strong visual look-alikes. Because of the likelihood of transcription errors, these also should be avoided. This includes the full-width equivalents of Latin characters, half-width Katakana characters for Japanese, and many others. It also includes many look-alikes of \"space\", \"delims\", and \"unwise\", characters excluded in [RFC3491].", "<p>The UCS contains many areas of characters for which there are strong visual look-alikes. Because of the likelihood of transcription errors, these also should be avoided. This includes the full-width equivalents of Latin characters, half-width Katakana characters for Japanese, and many others. It also includes many look-alikes of \"space\", \"delims\", and \"unwise\", characters excluded in [RFC3491].</p>")}, new String[]{"http://example.org/\u2000en-quad", "http://example.org/\u205fmedium-mathematical-space", "http://example\uff95.org/", "http://example\uff47.org/"}, new String[0], true);
            new ViolationCodeInfo(38, "BAD_BIDI_SUBCOMPONENT", "There are restrictions on bidi characters in subcomponents of IRIs", "<p>There are restrictions on bidi characters in subcomponents of IRIs</p>", 1, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("IRI", -1, "http://www.apps.ietf.org/rfc/rfc3987.html#sec-4.2", " (0)A component SHOULD NOT use both right-to-left and left-to-right characters. (1)A component using right-to-left characters SHOULD start and end with right-to-left characters. ", "<p></p><ol> <li>A component SHOULD NOT use both right-to-left and left-to-right characters.</li>  <li>A component using right-to-left characters SHOULD start and end with right-to-left characters.</li> </ol><p></p>")}, new String[0], new String[0], true);
            new ViolationCodeInfo(39, "DNS_LENGTH_LIMIT", new String[0], new String[0], false);
            new ViolationCodeInfo(40, "DNS_LABEL_LENGTH_LIMIT", new String[0], new String[0], false);
            new ViolationCodeInfo(41, "NOT_UTF8_ESCAPE", new String[0], new String[0], false);
            new ViolationCodeInfo(42, "NOT_UTF8_ESCAPE_IN_HOST", new String[0], new String[0], false);
            new ViolationCodeInfo(43, "BAD_DOT_IN_IDN", new String[0], new String[0], false);
            new ViolationCodeInfo(44, "UNREGISTERED_IANA_SCHEME", "The scheme name does not have a \"-\" in it, but is not in the IANA registry. (Last updated from the registry January 2006)", "<p>The scheme name does not have a \"-\" in it, but is not in the IANA registry. (Last updated from the registry January 2006)</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_other("URL_Registratrion", -1, "http://www.apps.ietf.org/rfc/rfc2717.html#sec-", "", "<p></p>"), new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.2", "The NAMES of schemes registered in the IETF tree MUST NOT contain the dash (also known as the hyphen and minus sign) character ('-') USASCII value 2Dh. Use of this character can cause confusion with schemes registered in alternative trees (see section 3.3).", "<p>The NAMES of schemes registered in the IETF tree MUST NOT contain the dash (also known as the hyphen and minus sign) character ('-') USASCII value 2Dh. Use of this character can cause confusion with schemes registered in alternative trees (see section 3.3).</p>"), new ViolationCodeInfo.FromSpec_iri("URI", -1, "http://www.apps.ietf.org/rfc/rfc3986.html#sec-3.3", "The syntax for alternative trees shall be as follows: each tree will be identified by a unique prefix, which must be established in the same fashion as a URL scheme name in the IETF tree, except that the prefix must be defined by a Standards Track document. Scheme names in the new tree are then constructed by prepending the prefix to an identifier unique to each scheme in that tree, as prescribed by that tree's identifying document:\n      <prefix&gt;'-'<tree-specific identifier&gt;\nFor instance, the \"foo\" tree would allow creation of scheme names of the form: \"foo-blahblah:\" and \"foo-bar:\", where the tree prescribes an arbitrary USASCII string following the tree's unique prefix.", "<p>The syntax for alternative trees shall be as follows: each tree will be identified by a unique prefix, which must be established in the same fashion as a URL scheme name in the IETF tree, except that the prefix must be defined by a Standards Track document. Scheme names in the new tree are then constructed by prepending the prefix to an identifier unique to each scheme in that tree, as prescribed by that tree's identifying document:</p><pre>\n      &lt;prefix&gt;'-'&lt;tree-specific identifier&gt;\n</pre><p>For instance, the \"foo\" tree would allow creation of scheme names of the form: \"foo-blahblah:\" and \"foo-bar:\", where the tree prescribes an arbitrary USASCII string following the tree's unique prefix.</p>"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"foo://example.org/bar"}, new String[0], false);
            new ViolationCodeInfo(45, "UNREGISTERED_NONIETF_SCHEME_TREE", "The scheme name has a \"-\" in it, but it does not start in \"x-\" and the prefix is not known as the prefix of an alternative tree for URI schemes.", "<p>The scheme name has a \"-\" in it, but it does not start in \"x-\" and the prefix is not known as the prefix of an alternative tree for URI schemes.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_other("URL_Registratrion", -1, "http://www.apps.ietf.org/rfc/rfc2717.html#sec-3.3", "The syntax for alternative trees shall be as follows: each tree will be identified by a unique prefix, which must be established in the same fashion as a URL scheme name in the IETF tree, except that the prefix must be defined by a Standards Track document. Scheme names in the new tree are then constructed by prepending the prefix to an identifier unique to each scheme in that tree, as prescribed by that tree's identifying document:\n      <prefix&gt;'-'<tree-specific identifier&gt;\nFor instance, the \"foo\" tree would allow creation of scheme names of the form: \"foo-blahblah:\" and \"foo-bar:\", where the tree prescribes an arbitrary USASCII string following the tree's unique prefix.", "<p>The syntax for alternative trees shall be as follows: each tree will be identified by a unique prefix, which must be established in the same fashion as a URL scheme name in the IETF tree, except that the prefix must be defined by a Standards Track document. Scheme names in the new tree are then constructed by prepending the prefix to an identifier unique to each scheme in that tree, as prescribed by that tree's identifying document:</p><pre>\n      &lt;prefix&gt;'-'&lt;tree-specific identifier&gt;\n</pre><p>For instance, the \"foo\" tree would allow creation of scheme names of the form: \"foo-blahblah:\" and \"foo-bar:\", where the tree prescribes an arbitrary USASCII string following the tree's unique prefix.</p>"), new ViolationCodeInfo.FromAlso("URI", "http://www.apps.ietf.org/rfc/rfc3986.html"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html"), new ViolationCodeInfo.FromAlso("XLink", "http://www.w3.org/TR/2001/REC-xlink-20010627/#link-locators"), new ViolationCodeInfo.FromAlso("XML", "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid"), new ViolationCodeInfo.FromAlso("RDF", "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref"), new ViolationCodeInfo.FromAlso("Schema", "http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/#anyURI")}, new String[]{"foo-bar://example.org/bar"}, new String[0], false);
            new ViolationCodeInfo(46, "NOT_NFC", "The IRI is not in Unicode Normal Form C.", "<p>The IRI is not in Unicode Normal Form C.</p>", 1, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("IRI", -1, "http://www.apps.ietf.org/rfc/rfc3987.html#sec-5.3.2.2", "To avoid false negatives and problems with transcoding, IRIs SHOULD be created by using NFC.", "<p>To avoid false negatives and problems with transcoding, IRIs SHOULD be created by using NFC.</p>")}, new String[]{"http://example.org/#Andre\u0301"}, new String[0], true);
            new ViolationCodeInfo(47, "NOT_NFKC", "The IRI is not in Unicode Normal Form KC.", "<p>The IRI is not in Unicode Normal Form KC.</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("IRI", -1, "http://www.apps.ietf.org/rfc/rfc3987.html#sec-7.5", "Although there may be exceptions, newly created resource names should generally be in NFKC", "<p>Although there may be exceptions, newly created resource names should generally be in NFKC</p>")}, new String[]{"http://example.org/#Andre\u0301"}, new String[0], true);
            new ViolationCodeInfo(48, "DEPRECATED_UNICODE_CHARACTER", "TODO", "<p>TODO</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromAlso("Unicode", "http://www.unicode.org/"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html")}, new String[0], new String[0], false);
            new ViolationCodeInfo(49, "UNDEFINED_UNICODE_CHARACTER", "TODO", "<p>TODO</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromAlso("Unicode", "http://www.unicode.org/"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html")}, new String[0], new String[0], false);
            new ViolationCodeInfo(50, "PRIVATE_USE_CHARACTER", "TODO", "<p>TODO</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromAlso("Unicode", "http://www.unicode.org/"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html")}, new String[0], new String[0], false);
            new ViolationCodeInfo(51, "UNICODE_CONTROL_CHARACTER", "TODO", "<p>TODO</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromAlso("Unicode", "http://www.unicode.org/"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html")}, new String[0], new String[0], false);
            new ViolationCodeInfo(52, "UNASSIGNED_UNICODE_CHARACTER", "The character code is not assigned in the version of Unicode implemented here.", "<p>The character code is not assigned in the version of Unicode implemented here.</p>", 4, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromAlso("Unicode", "http://www.unicode.org/"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html")}, new String[0], new String[0], false);
            new ViolationCodeInfo(53, "MAYBE_NOT_NFC", new String[0], new String[0], true);
            new ViolationCodeInfo(54, "MAYBE_NOT_NFKC", new String[0], new String[0], true);
            new ViolationCodeInfo(55, "UNICODE_WHITESPACE", "TODO", "<p>TODO</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromAlso("Unicode", "http://www.unicode.org/"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html")}, new String[0], new String[0], false);
            new ViolationCodeInfo(56, "COMPATIBILITY_CHARACTER", "TODO", "<p>TODO</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromAlso("Unicode", "http://www.unicode.org/"), new ViolationCodeInfo.FromAlso("IRI", "http://www.apps.ietf.org/rfc/rfc3987.html")}, new String[0], new String[0], false);
            new ViolationCodeInfo(57, "REQUIRED_COMPONENT_MISSING", "A component that is required by the scheme is missing.", "<p>A component that is required by the scheme is missing.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("RDF", 2, "http://www.w3.org/TR/2004/REC-rdf-concepts-20040210/#section-Graph-URIref", "representing an *absolute URI* with optional fragment identifier", "<p>representing an <em>absolute URI</em> with optional fragment identifier</p>"), new ViolationCodeInfo.FromSpec_scheme("http", 7, "http://www.apps.ietf.org/rfc/rfc2616.html"), new ViolationCodeInfo.FromSpec_scheme("https", 7, "http://www.apps.ietf.org/rfc/rfc2818.html"), new ViolationCodeInfo.FromSpec_scheme("ftp", 7, "http://www.apps.ietf.org/rfc/rfc1738.html#sec-5", "\nftpurl = \"ftp://\" login [ \"/\" fpath [ \";type=\" ftptype ]]\n\nlogin = [ user [ \":\" password ] \"@\" ] hostport\n", "<p></p><pre>\nftpurl = \"ftp://\" login [ \"/\" fpath [ \";type=\" ftptype ]]\n\nlogin = [ user [ \":\" password ] \"@\" ] hostport\n</pre><p></p>"), new ViolationCodeInfo.FromSpec_scheme("news", 11, "http://www.apps.ietf.org/rfc/rfc1738.html#sec-5", "\nnewsurl = \"news:\" grouppart\ngrouppart = \"*\" | group | article\ngroup = alpha *[ alpha | digit | \"-\" | \".\" | \"+\" | \"_\" ]\narticle = 1*[ uchar | \";\" | \"/\" | \"?\" | \":\" | \"&amp;\" | \"=\" ] \"@\" host\n", "<p></p><pre>\nnewsurl = \"news:\" grouppart\ngrouppart = \"*\" | group | article\ngroup = alpha *[ alpha | digit | \"-\" | \".\" | \"+\" | \"_\" ]\narticle = 1*[ uchar | \";\" | \"/\" | \"?\" | \":\" | \"&amp;\" | \"=\" ] \"@\" host\n</pre><p></p>"), new ViolationCodeInfo.FromSpec_scheme("nntp", 7, "http://www.apps.ietf.org/rfc/rfc1738.html#sec-3.7"), new ViolationCodeInfo.FromSpec_scheme("file", 11, "http://www.apps.ietf.org/rfc/rfc1738.html#sec-5", "\nfileurl = \"file://\" [ host | \"localhost\" ] \"/\" fpath\n", "<p></p><pre>\nfileurl = \"file://\" [ host | \"localhost\" ] \"/\" fpath\n</pre><p></p>"), new ViolationCodeInfo.FromSpec_scheme("file", 4, "http://www.apps.ietf.org/rfc/rfc1738.html#sec-5", "\nfileurl = \"file://\" [ host | \"localhost\" ] \"/\" fpath\n", "<p></p><pre>\nfileurl = \"file://\" [ host | \"localhost\" ] \"/\" fpath\n</pre><p></p>"), new ViolationCodeInfo.FromSpec_scheme("urn", 11, "http://www.apps.ietf.org/rfc/rfc2141.html#sec-2", "\n<URN&gt; ::= \"urn:\" <NID&gt; \":\" <NSS&gt;\n", "<p></p><pre>\n&lt;URN&gt; ::= \"urn:\" &lt;NID&gt; \":\" &lt;NSS&gt;\n</pre><p></p>")}, new String[0], new String[0], false);
            new ViolationCodeInfo(58, "PROHIBITED_COMPONENT_PRESENT", "A component that is prohibited by the scheme is present.", "<p>A component that is prohibited by the scheme is present.</p>", 0, new ViolationCodeInfo.InSpec[]{new ViolationCodeInfo.FromSpec_iri("XML", 15, "http://www.w3.org/TR/2004/REC-xml-20040204/#dt-sysid", "TODO", "<p>TODO</p>"), new ViolationCodeInfo.FromSpec_scheme("http", 6, "http://www.apps.ietf.org/rfc/rfc2616.html"), new ViolationCodeInfo.FromSpec_scheme("https", 6, "http://www.apps.ietf.org/rfc/rfc2818.html"), new ViolationCodeInfo.FromSpec_scheme("mailto", 4, "http://www.apps.ietf.org/rfc/rfc2368.html", "\n     mailtoURL  =  \"mailto:\" [ to ] [ headers ]\n     to         =  #mailbox\n     headers    =  \"?\" header *( \"&amp;\" header )\n     header     =  hname \"=\" hvalue\n     hname      =  *urlc\n     hvalue     =  *urlc\n", "<p></p><pre>\n     mailtoURL  =  \"mailto:\" [ to ] [ headers ]\n     to         =  #mailbox\n     headers    =  \"?\" header *( \"&amp;\" header )\n     header     =  hname \"=\" hvalue\n     hname      =  *urlc\n     hvalue     =  *urlc\n</pre><p></p>"), new ViolationCodeInfo.FromSpec_scheme("news", 4, "http://www.apps.ietf.org/rfc/rfc1738.html#sec-5", "\nnewsurl = \"news:\" grouppart\ngrouppart = \"*\" | group | article\ngroup = alpha *[ alpha | digit | \"-\" | \".\" | \"+\" | \"_\" ]\narticle = 1*[ uchar | \";\" | \"/\" | \"?\" | \":\" | \"&amp;\" | \"=\" ] \"@\" host\n", "<p></p><pre>\nnewsurl = \"news:\" grouppart\ngrouppart = \"*\" | group | article\ngroup = alpha *[ alpha | digit | \"-\" | \".\" | \"+\" | \"_\" ]\narticle = 1*[ uchar | \";\" | \"/\" | \"?\" | \":\" | \"&amp;\" | \"=\" ] \"@\" host\n</pre><p></p>"), new ViolationCodeInfo.FromSpec_scheme("nntp", 13, "http://www.apps.ietf.org/rfc/rfc1738.html#sec-3.7"), new ViolationCodeInfo.FromSpec_scheme("nntp", 6, "http://www.apps.ietf.org/rfc/rfc1738.html#sec-3.7"), new ViolationCodeInfo.FromSpec_scheme("file", 6, "http://www.apps.ietf.org/rfc/rfc1738.html#sec-5", "\nfileurl = \"file://\" [ host | \"localhost\" ] \"/\" fpath\n", "<p></p><pre>\nfileurl = \"file://\" [ host | \"localhost\" ] \"/\" fpath\n</pre><p></p>"), new ViolationCodeInfo.FromSpec_scheme("file", 10, "http://www.apps.ietf.org/rfc/rfc1738.html#sec-5", "\nfileurl = \"file://\" [ host | \"localhost\" ] \"/\" fpath\n", "<p></p><pre>\nfileurl = \"file://\" [ host | \"localhost\" ] \"/\" fpath\n</pre><p></p>"), new ViolationCodeInfo.FromSpec_scheme("urn", 4, "http://www.apps.ietf.org/rfc/rfc2141.html#sec-2", "\n<URN&gt; ::= \"urn:\" <NID&gt; \":\" <NSS&gt;\n", "<p></p><pre>\n&lt;URN&gt; ::= \"urn:\" &lt;NID&gt; \":\" &lt;NSS&gt;\n</pre><p></p>"), new ViolationCodeInfo.FromSpec_scheme("urn", 4, "http://www.apps.ietf.org/rfc/rfc2141.html#sec-2.1", "\n<NID&gt;         ::= <let-num&gt; [ 1,31<let-num-hyp&gt; ]\n", "<p></p><pre>\n&lt;NID&gt;         ::= &lt;let-num&gt; [ 1,31&lt;let-num-hyp&gt; ]\n</pre><p></p>"), new ViolationCodeInfo.FromSpec_scheme("urn", 13, "http://www.apps.ietf.org/rfc/rfc2141.html#sec-2.3.2")}, new String[0], new String[0], false);
            new ViolationCodeInfo(59, "SCHEME_REQUIRES_LOWERCASE", "Some part of the scheme specific syntax requires lowercase.", "<p>Some part of the scheme specific syntax requires lowercase.</p>", 0, new ViolationCodeInfo.InSpec[0], new String[0], new String[0], false);
            new ViolationCodeInfo(60, "SCHEME_PREFERS_LOWERCASE", "Some part of the scheme specific syntax prefers lowercase.", "<p>Some part of the scheme specific syntax prefers lowercase.</p>", 4, new ViolationCodeInfo.InSpec[0], new String[0], new String[0], false);
            new ViolationCodeInfo(61, "SCHEME_PATTERN_MATCH_FAILED", "The scheme specific syntax rules are violated.", "<p>The scheme specific syntax rules are violated.</p>", 0, new ViolationCodeInfo.InSpec[0], new String[0], new String[0], false);
            new ViolationCodeInfo(62, "QUERY_IN_LEGACY_SCHEME", new String[0], new String[0], false);
        }
    }
}

