/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.ontapi.common.EnhNodeFactory;
import org.apache.jena.ontapi.common.OntConfig;
import org.apache.jena.ontapi.common.OntPersonality;
import org.apache.jena.ontapi.common.OntPersonalityImpl;
import org.apache.jena.ontapi.common.ResourceVocabulary;
import org.apache.jena.ontapi.model.OntEntity;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public class OntObjectPersonalityBuilder {
    private final Map<Class<? extends OntObject>, Function<OntConfig, EnhNodeFactory>> extFactories = new HashMap<Class<? extends OntObject>, Function<OntConfig, EnhNodeFactory>>();
    private final Map<Class<? extends RDFNode>, Implementation> stdFactories = new HashMap<Class<? extends RDFNode>, Implementation>();
    private String name;
    private OntPersonality.Punnings punnings;
    private OntPersonality.Builtins builtins;
    private OntPersonality.Reserved reserved;
    private OntConfig config;

    public static OntObjectPersonalityBuilder from(OntPersonality from) {
        return new OntObjectPersonalityBuilder().addPersonality(OntPersonality.asJenaPersonality(from)).setPunnings(from.getPunnings()).setBuiltins(from.getBuiltins()).setReserved(from.getReserved()).setConfig(from.getConfig());
    }

    private static <X> X require(X obj, Class<X> type) {
        if (obj == null) {
            throw new IllegalStateException("The " + type.getSimpleName() + " Vocabulary must be present in builder.");
        }
        return obj;
    }

    private static <V extends ResourceVocabulary> V hasSpec(V voc, Class ... types) {
        Objects.requireNonNull(voc);
        Set errors = Arrays.stream(types).filter(x -> !voc.supports(x)).collect(Collectors.toSet());
        if (errors.isEmpty()) {
            return voc;
        }
        throw new IllegalArgumentException("The vocabulary " + voc + " has missed required types: " + errors);
    }

    public OntObjectPersonalityBuilder copy() {
        OntObjectPersonalityBuilder res = new OntObjectPersonalityBuilder();
        res.stdFactories.putAll(this.stdFactories);
        res.extFactories.putAll(this.extFactories);
        res.setName(this.name);
        if (this.punnings != null) {
            res.setPunnings(this.punnings);
        }
        if (this.builtins != null) {
            res.setBuiltins(this.builtins);
        }
        if (this.reserved != null) {
            res.setReserved(this.reserved);
        }
        if (this.config != null) {
            res.setConfig(this.config);
        }
        return res;
    }

    public OntObjectPersonalityBuilder add(OntObjectPersonalityBuilder other) {
        this.extFactories.putAll(other.extFactories);
        this.stdFactories.putAll(other.stdFactories);
        return this;
    }

    public OntObjectPersonalityBuilder add(Class<? extends OntObject> type, EnhNodeFactory factory) {
        return this.add(type, (OntConfig config) -> factory);
    }

    public OntObjectPersonalityBuilder add(Class<? extends OntObject> type, Function<OntConfig, EnhNodeFactory> factory) {
        this.extFactories.put(type, factory);
        return this;
    }

    public OntObjectPersonalityBuilder remove(Class<? extends OntObject> type) {
        this.extFactories.remove(type);
        this.stdFactories.remove(type);
        return this;
    }

    public OntObjectPersonalityBuilder addPersonality(Personality<RDFNode> from) {
        this.stdFactories.putAll(new JenaPersonalityAccessor(from).getMap());
        return this;
    }

    public OntObjectPersonalityBuilder setName(String profileName) {
        this.name = profileName;
        return this;
    }

    public OntObjectPersonalityBuilder setPunnings(OntPersonality.Punnings punnings) {
        this.punnings = OntObjectPersonalityBuilder.hasSpec(punnings, this.getEntityTypes());
        return this;
    }

    public OntObjectPersonalityBuilder setBuiltins(OntPersonality.Builtins builtins) {
        this.builtins = OntObjectPersonalityBuilder.hasSpec(builtins, this.getEntityTypes());
        return this;
    }

    public OntObjectPersonalityBuilder setReserved(OntPersonality.Reserved reserved) {
        this.reserved = OntObjectPersonalityBuilder.hasSpec(reserved, Resource.class, Property.class);
        return this;
    }

    public OntObjectPersonalityBuilder setConfig(OntConfig config) {
        this.config = Objects.requireNonNull(config);
        return this;
    }

    public OntPersonality build() throws IllegalStateException {
        OntConfig config = this.config();
        OntPersonality.Punnings punnings = this.punnings();
        OntPersonality.Builtins builtins = this.builtins();
        OntPersonality.Reserved reserved = this.reserved();
        OntPersonalityImpl res = new OntPersonalityImpl(this.name, config, punnings, builtins, reserved);
        this.stdFactories.forEach((arg_0, arg_1) -> ((OntPersonalityImpl)res).add(arg_0, arg_1));
        this.extFactories.forEach((type, factory) -> res.register((Class<? extends OntObject>)type, (EnhNodeFactory)factory.apply(config)));
        return res;
    }

    private Class<?>[] getEntityTypes() {
        return (Class[])OntEntity.TYPES.toArray(Class[]::new);
    }

    private OntPersonality.Punnings punnings() {
        return OntObjectPersonalityBuilder.require(this.punnings, OntPersonality.Punnings.class);
    }

    private OntPersonality.Builtins builtins() {
        return OntObjectPersonalityBuilder.require(this.builtins, OntPersonality.Builtins.class);
    }

    private OntPersonality.Reserved reserved() {
        return OntObjectPersonalityBuilder.require(this.reserved, OntPersonality.Reserved.class);
    }

    private OntConfig config() {
        return Objects.requireNonNull(this.config, "No config is set");
    }

    private static class JenaPersonalityAccessor
    extends Personality<RDFNode> {
        public JenaPersonalityAccessor(Personality<RDFNode> other) {
            super(other);
        }

        protected Map<Class<? extends RDFNode>, Implementation> getMap() {
            return super.getMap();
        }
    }
}

