/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntListImpl;
import org.apache.jena.ontapi.impl.objects.OntNegativePropertyAssertionImpl;
import org.apache.jena.ontapi.impl.objects.OntPropertyImpl;
import org.apache.jena.ontapi.impl.objects.OntStatementImpl;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntList;
import org.apache.jena.ontapi.model.OntNegativeAssertion;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;

public abstract class OntObjectPropertyImpl
extends OntPropertyImpl
implements OntObjectProperty {
    public OntObjectPropertyImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public Stream<OntObjectProperty> superProperties(boolean direct) {
        return OntObjectPropertyImpl.superProperties(this, OntObjectProperty.class, direct);
    }

    @Override
    public Stream<OntObjectProperty> subProperties(boolean direct) {
        return OntObjectPropertyImpl.subProperties(this, OntObjectProperty.class, direct);
    }

    @Override
    public Stream<OntClass> declaringClasses(boolean direct) {
        return OntObjectPropertyImpl.declaringClasses(this, direct);
    }

    @Override
    public boolean hasSuperProperty(OntProperty property, boolean direct) {
        return property.canAs(OntObjectProperty.class) && OntPropertyImpl.hasSuperProperty(this, (OntObjectProperty)property.as(OntObjectProperty.class), OntObjectProperty.class, direct);
    }

    @Override
    public OntNegativeAssertion.WithObjectProperty addNegativeAssertion(OntIndividual source, OntIndividual target) {
        return OntNegativePropertyAssertionImpl.create(this.getModel(), source, this, target);
    }

    @Override
    public OntList<OntObjectProperty> createPropertyChain(Collection<OntObjectProperty> properties) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_CHAIN_AXIOM_FEATURE, "owl:propertyChainAxiom");
        return this.getModel().createOntList(this, OWL2.propertyChainAxiom, OntObjectProperty.class, properties.iterator());
    }

    @Override
    public Stream<OntList<OntObjectProperty>> propertyChains() {
        if (!OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_PROPERTY_CHAIN_AXIOM_FEATURE)) {
            return Stream.empty();
        }
        return OntListImpl.stream(this.getModel(), this, OWL2.propertyChainAxiom, OntObjectProperty.class);
    }

    @Override
    public OntObjectPropertyImpl removePropertyChain(Resource rdfList) throws OntJenaException.IllegalArgument {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_CHAIN_AXIOM_FEATURE, "owl:propertyChainAxiom");
        this.getModel().deleteOntList(this, OWL2.propertyChainAxiom, this.findPropertyChain((RDFNode)rdfList).orElse(null));
        return this;
    }

    @Override
    public Stream<OntObjectProperty> disjointProperties() {
        return OntObjectPropertyImpl.disjointProperties(this.getModel(), OntObjectProperty.class, this);
    }

    @Override
    public OntStatement addPropertyDisjointWithStatement(OntObjectProperty other) {
        return OntObjectPropertyImpl.addDisjointWith(this.getModel(), this, other);
    }

    @Override
    public OntObjectProperty removeDisjointProperty(Resource property) {
        OntObjectPropertyImpl.removeDisjointWith(this.getModel(), this, property);
        return this;
    }

    @Override
    public Stream<OntObjectProperty> equivalentProperties() {
        return OntObjectPropertyImpl.equivalentProperties(this.getModel(), OntObjectProperty.class, this);
    }

    @Override
    public OntStatement addEquivalentPropertyStatement(OntObjectProperty other) {
        return OntObjectPropertyImpl.addEquivalentProperty(this.getModel(), this, other);
    }

    @Override
    public OntObjectProperty removeEquivalentProperty(Resource property) {
        OntObjectPropertyImpl.removeEquivalentProperty(this.getModel(), this, property);
        return this;
    }

    @Override
    public boolean isFunctional() {
        return OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_OBJECT_PROPERTY_FUNCTIONAL_FEATURE) && this.hasType(OWL2.FunctionalProperty);
    }

    @Override
    public OntObjectPropertyImpl setFunctional(boolean functional) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_OBJECT_PROPERTY_FUNCTIONAL_FEATURE, "owl:FunctionalProperty");
        return this.changeRDFType(OWL2.FunctionalProperty, functional);
    }

    @Override
    public OntStatement addFunctionalDeclaration() {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_OBJECT_PROPERTY_FUNCTIONAL_FEATURE, "owl:FunctionalProperty");
        return this.addStatement(RDF.type, (RDFNode)OWL2.FunctionalProperty);
    }

    @Override
    public boolean isInverseFunctional() {
        return OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_PROPERTY_INVERSE_FUNCTIONAL_FEATURE) && this.hasType(OWL2.InverseFunctionalProperty);
    }

    @Override
    public OntObjectPropertyImpl setInverseFunctional(boolean inverseFunctional) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_INVERSE_FUNCTIONAL_FEATURE, "owl:InverseFunctionalProperty");
        return this.changeRDFType(OWL2.InverseFunctionalProperty, inverseFunctional);
    }

    @Override
    public OntStatement addInverseFunctionalDeclaration() {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_INVERSE_FUNCTIONAL_FEATURE, "owl:InverseFunctionalProperty");
        return this.addStatement(RDF.type, (RDFNode)OWL2.InverseFunctionalProperty);
    }

    @Override
    public boolean isSymmetric() {
        return OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_PROPERTY_SYMMETRIC_FEATURE) && this.hasType(OWL2.SymmetricProperty);
    }

    @Override
    public OntObjectPropertyImpl setSymmetric(boolean symmetric) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_SYMMETRIC_FEATURE, "owl:SymmetricProperty");
        return this.changeRDFType(OWL2.SymmetricProperty, symmetric);
    }

    @Override
    public OntStatement addSymmetricDeclaration() {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_SYMMETRIC_FEATURE, "owl:SymmetricProperty");
        return this.addStatement(RDF.type, (RDFNode)OWL2.SymmetricProperty);
    }

    @Override
    public boolean isAsymmetric() {
        return OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_PROPERTY_ASYMMETRIC_FEATURE) && this.hasType(OWL2.AsymmetricProperty);
    }

    @Override
    public OntObjectPropertyImpl setAsymmetric(boolean asymmetric) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_ASYMMETRIC_FEATURE, "owl:AsymmetricProperty");
        return this.changeRDFType(OWL2.AsymmetricProperty, asymmetric);
    }

    @Override
    public OntStatement addAsymmetricDeclaration() {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_ASYMMETRIC_FEATURE, "owl:AsymmetricProperty");
        return this.addStatement(RDF.type, (RDFNode)OWL2.AsymmetricProperty);
    }

    @Override
    public boolean isTransitive() {
        return OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_PROPERTY_TRANSITIVE_FEATURE) && this.hasType(OWL2.TransitiveProperty);
    }

    @Override
    public OntObjectPropertyImpl setTransitive(boolean transitive) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_TRANSITIVE_FEATURE, "owl:TransitiveProperty");
        return this.changeRDFType(OWL2.TransitiveProperty, transitive);
    }

    @Override
    public OntStatement addTransitiveDeclaration() {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_TRANSITIVE_FEATURE, "owl:TransitiveProperty");
        return this.addStatement(RDF.type, (RDFNode)OWL2.TransitiveProperty);
    }

    @Override
    public boolean isReflexive() {
        return OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_PROPERTY_REFLEXIVE_FEATURE) && this.hasType(OWL2.ReflexiveProperty);
    }

    @Override
    public OntObjectPropertyImpl setReflexive(boolean reflexive) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_REFLEXIVE_FEATURE, "owl:ReflexiveProperty");
        return this.changeRDFType(OWL2.ReflexiveProperty, reflexive);
    }

    @Override
    public OntStatement addReflexiveDeclaration() {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_REFLEXIVE_FEATURE, "owl:ReflexiveProperty");
        return this.addStatement(RDF.type, (RDFNode)OWL2.ReflexiveProperty);
    }

    @Override
    public boolean isIrreflexive() {
        return OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_PROPERTY_IRREFLEXIVE_FEATURE) && this.hasType(OWL2.IrreflexiveProperty);
    }

    @Override
    public OntObjectPropertyImpl setIrreflexive(boolean irreflexive) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_IRREFLEXIVE_FEATURE, "owl:IrreflexiveProperty");
        return this.changeRDFType(OWL2.IrreflexiveProperty, irreflexive);
    }

    @Override
    public OntStatement addIrreflexiveDeclaration() {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_PROPERTY_IRREFLEXIVE_FEATURE, "owl:IrreflexiveProperty");
        return this.addStatement(RDF.type, (RDFNode)OWL2.IrreflexiveProperty);
    }

    @Override
    public Stream<OntObjectProperty> inverseProperties() {
        if (!OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_INVERSE_OBJECT_PROPERTIES_FEATURE)) {
            return Stream.empty();
        }
        return this.objects(OWL2.inverseOf, OntObjectProperty.class);
    }

    @Override
    public OntStatement addInverseOfStatement(OntObjectProperty other) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_INVERSE_OBJECT_PROPERTIES_FEATURE, "owl:inverseOf");
        return this.addStatement(OWL2.inverseOf, (RDFNode)other);
    }

    @Override
    public OntObjectProperty removeInverseProperty(Resource other) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_INVERSE_OBJECT_PROPERTIES_FEATURE, "owl:inverseOf");
        this.remove(OWL2.inverseOf, (RDFNode)other);
        return this;
    }

    @Override
    protected OntObjectPropertyImpl changeRDFType(Resource type, boolean add) {
        super.changeRDFType(type, add);
        return this;
    }

    public static class InversePropertyImpl
    extends OntObjectPropertyImpl
    implements OntObjectProperty.Inverse {
        public InversePropertyImpl(Node n, EnhGraph g) {
            super(n, g);
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return Optional.of(this.getModel().createStatement(this, OWL2.inverseOf, (RDFNode)this.getDirect()).asRootStatement());
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntObjectProperty.Inverse.class;
        }

        @Override
        public OntObjectProperty.Named getDirect() {
            OntGraphModelImpl m = this.getModel();
            List res = Iterators.distinct(this.listObjects(OWL2.inverseOf, Resource.class).filterKeep(RDFNode::isURIResource)).toList();
            if (res.size() != 1) {
                throw new OntJenaException.IllegalState("Expected one and only one owl:inverseOf statement, but found: [" + this + " owl:inverseOf " + res + "]");
            }
            return m.getNodeAs(((Resource)res.get(0)).asNode(), OntObjectProperty.Named.class);
        }

        @Override
        public Property asProperty() {
            return this.getDirect().asProperty();
        }
    }

    public static class NamedImpl
    extends OntObjectPropertyImpl
    implements OntObjectProperty.Named {
        public NamedImpl(Node n, EnhGraph g) {
            super(NamedImpl.checkNamed(n), g);
        }

        @Override
        public OntObjectProperty.Inverse createInverse() {
            OntGraphModelImpl m = this.getModel();
            m.checkType(OntObjectProperty.Inverse.class);
            List<Node> nodes = m.localStatements(null, OWL2.inverseOf, (RDFNode)this).map(OntStatement::getSubject).filter(RDFNode::isAnon).map(FrontsNode::asNode).distinct().toList();
            if (nodes.size() > 1) {
                throw new OntJenaException.IllegalState("More than one inverse-of object properties found: [" + nodes + " owl:inverseOf " + this + "]");
            }
            Node n = nodes.isEmpty() ? m.createResource().addProperty(OWL2.inverseOf, (RDFNode)this).asNode() : nodes.get(0);
            return m.getNodeAs(n, OntObjectProperty.Inverse.class);
        }

        @Override
        public boolean isBuiltIn() {
            return this.getModel().isBuiltIn(this);
        }

        public Class<OntObjectProperty.Named> objectType() {
            return OntObjectProperty.Named.class;
        }

        public Property inModel(Model m) {
            return this.getModel() == m ? this : m.createProperty(this.getURI());
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return NamedImpl.getOptionalRootStatement(this, OWL2.ObjectProperty);
        }

        public int getOrdinal() {
            return OntStatementImpl.createProperty(this.node, this.enhGraph).getOrdinal();
        }
    }
}

