/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.utils;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.common.OntConfig;
import org.apache.jena.ontapi.common.OntEnhGraph;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntIndividualImpl;
import org.apache.jena.ontapi.impl.objects.OntListImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.impl.objects.OntStatementImpl;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntDisjoint;
import org.apache.jena.ontapi.model.OntEntity;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntModel;
import org.apache.jena.ontapi.model.OntNegativeAssertion;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntSWRL;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.model.RDFNodeList;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.util.iterator.ExtendedIterator;

public class OntModels {
    public static <O extends OntObject> Class<O> getOntType(O object) {
        Class<? extends OntObject> res = object instanceof OntObjectImpl ? object.objectType() : OntObjectImpl.findActualClass(object);
        return OntJenaException.notNull(res, "Can't determine the type of object " + object);
    }

    public static OntIndividual.Anonymous asAnonymousIndividual(RDFNode inModel) {
        return OntIndividualImpl.createAnonymousIndividual(inModel);
    }

    public static ExtendedIterator<OntModel> listImports(OntModel model) {
        if (model instanceof OntGraphModelImpl) {
            OntGraphModelImpl m = (OntGraphModelImpl)model;
            Reasoner reasoner = ((OntGraphModelImpl)model).getReasoner();
            ExtendedIterator<OntGraphModelImpl> res = m.listImportModels(m.getOntPersonality(), reasoner);
            return res;
        }
        return Iterators.create(model.imports().iterator());
    }

    public static <O extends OntObject> ExtendedIterator<O> listLocalObjects(OntModel model, Class<? extends O> type) {
        if (model instanceof OntGraphModelImpl) {
            return ((OntGraphModelImpl)model).listLocalOntObjects(type);
        }
        Stream<O> res = model.ontObjects(type);
        return Iterators.create(res.iterator()).filterKeep(rec$ -> ((OntObject)rec$).isLocal());
    }

    public static ExtendedIterator<OntEntity> listLocalEntities(OntModel model) {
        if (model instanceof OntGraphModelImpl) {
            return ((OntGraphModelImpl)model).listLocalOntEntities();
        }
        return Iterators.create(model.ontEntities().iterator()).filterKeep(rec$ -> ((OntObject)rec$).isLocal());
    }

    public static <R extends RDFNode> ExtendedIterator<R> listMembers(RDFNodeList<R> list) {
        if (list instanceof OntListImpl) {
            return ((OntListImpl)list).listMembers();
        }
        return Iterators.create(list.members().iterator());
    }

    public static ExtendedIterator<OntClass> listClasses(OntIndividual i) {
        return i instanceof OntIndividualImpl ? ((OntIndividualImpl)i).listClasses() : Iterators.create(i.classes().iterator());
    }

    public static ExtendedIterator<OntStatement> listLocalStatements(OntModel model, Resource s, Property p, RDFNode o) {
        if (model instanceof OntGraphModelImpl) {
            return ((OntGraphModelImpl)model).listLocalStatements(s, p, o);
        }
        return model.getBaseGraph().find(ModelCom.asNode((RDFNode)s), ModelCom.asNode((RDFNode)p), ModelCom.asNode((RDFNode)p)).mapWith(model::asStatement);
    }

    public static ExtendedIterator<OntStatement> listAnnotations(OntStatement s) {
        if (s instanceof OntStatementImpl) {
            return ((OntStatementImpl)s).listAnnotations();
        }
        return Iterators.create(s.annotations().iterator());
    }

    public static ExtendedIterator<OntStatement> listAnnotations(OntObject o) {
        if (o instanceof OntObjectImpl) {
            return ((OntObjectImpl)o).listAnnotations();
        }
        return Iterators.create(o.annotations().iterator());
    }

    public static Stream<OntStatement> annotations(OntStatement statement) {
        return Iterators.fromSet(() -> OntModels.getAllAnnotations(statement));
    }

    public static ExtendedIterator<OntStatement> listAllAnnotations(OntStatement statement) {
        return Iterators.create(() -> Iterators.create(OntModels.getAllAnnotations(statement)));
    }

    public static Set<OntStatement> getAllAnnotations(OntStatement statement) {
        ArrayDeque<OntStatement> queue = new ArrayDeque<OntStatement>();
        LinkedHashSet<OntStatement> res = new LinkedHashSet<OntStatement>();
        queue.add(statement);
        while (!queue.isEmpty()) {
            OntStatement s = (OntStatement)queue.removeFirst();
            if (!res.add(s)) continue;
            OntModels.listAnnotations(s).forEach(queue::add);
        }
        res.remove(statement);
        return res;
    }

    public static ExtendedIterator<OntStatement> listSplitStatements(OntStatement statement) {
        return ((OntStatementImpl)statement).listSplitStatements();
    }

    public static OntStatement toOntStatement(Triple triple, OntModel model) {
        OntStatement res = model.asStatement(triple);
        OntObject subj = res.getSubject();
        return Stream.of(OntEntity.class, OntClass.class, OntDataRange.class, OntDisjoint.class, OntObjectProperty.class, OntNegativeAssertion.class, OntSWRL.class).filter(arg_0 -> ((Resource)subj).canAs(arg_0)).map(arg_0 -> ((Resource)subj).as(arg_0)).map(OntObject::getMainStatement).filter(res::equals).findFirst().orElse(res);
    }

    public static OntConfig config(OntModel m) {
        return m instanceof OntEnhGraph ? ((OntEnhGraph)((Object)m)).getOntPersonality().getConfig() : null;
    }

    public static Stream<OntClass.Named> namedHierarchyRoots(OntModel m) {
        HashSet<OntClass> named = new HashSet<OntClass>();
        HashSet<OntClass> anonymous = new HashSet<OntClass>();
        OntModels.collectNamedHierarchyRoots(m.getOWLThing(), m.hierarchyRoots(), named, anonymous);
        while (!anonymous.isEmpty()) {
            OntClass anon = (OntClass)anonymous.iterator().next();
            anonymous.remove(anon);
            OntModels.collectNamedHierarchyRoots(m.getOWLThing(), anon.subClasses(true), named, anonymous);
        }
        return named.stream().map(OntClass::asNamed);
    }

    private static void collectNamedHierarchyRoots(OntClass thing, Stream<OntClass> classes, Collection<OntClass> named, Collection<OntClass> anonymous) {
        classes.forEach(clazz -> {
            if (named.contains(clazz) || anonymous.contains(clazz)) {
                return;
            }
            if (clazz.superClasses(false).allMatch(it -> it.isAnon() || it.equals(clazz) || it.equals(thing))) {
                (clazz.isAnon() ? anonymous : named).add(clazz);
            }
        });
    }

    public static OntClass getLCA(OntClass u, OntClass v) {
        OntClass root = OntJenaException.notNull(u.getModel().getOWLThing());
        return OntModels.getLCA(root, u, v);
    }

    public static OntClass getLCA(OntClass root, OntClass u, OntClass v) {
        if (u.equals(root) || v.equals(root)) {
            return root;
        }
        if (u.hasSubClass(v, false)) {
            return u;
        }
        if (v.hasSubClass(u, false)) {
            return v;
        }
        LCAIndex index = new LCAIndex();
        OntModels.lca(root, u, v, index);
        return (OntClass)index.getLCA(u, v);
    }

    private static DisjointSet lca(OntClass cls, OntClass uCls, OntClass vCls, LCAIndex index) {
        DisjointSet clsSet = index.getSet(cls);
        if (clsSet.black) {
            return clsSet;
        }
        clsSet.ancestor = clsSet;
        try (Stream<OntClass> subclasses = cls.subClasses(true);){
            subclasses.forEach(child -> {
                if (child.equals(cls) || child.equals(cls.getModel().getOWLNothing())) {
                    return;
                }
                DisjointSet v = OntModels.lca(child, uCls, vCls, index);
                clsSet.union(v);
                clsSet.find().ancestor = clsSet;
            });
        }
        clsSet.black = true;
        if (cls.equals(uCls)) {
            OntModels.checkSolution(uCls, vCls, index);
        } else if (cls.equals(vCls)) {
            OntModels.checkSolution(vCls, uCls, index);
        }
        return clsSet;
    }

    private static void checkSolution(OntClass uCls, OntClass vCls, LCAIndex index) {
        DisjointSet vSet = index.getSet(vCls);
        DisjointSet uSet = index.getSet(uCls);
        if (vSet != null && vSet.black && !vSet.used && uSet != null && uSet.black && !uSet.used) {
            vSet.used = true;
            uSet.used = true;
            OntClass lca = (OntClass)vSet.find().ancestor.node;
            index.setLCA(uCls, vCls, lca);
        }
    }

    private static class LCAIndex {
        private final Map<Resource, DisjointSet> setIndex = new HashMap<Resource, DisjointSet>();
        private final Map<Resource, Map<Resource, Resource>> lcaIndex = new HashMap<Resource, Map<Resource, Resource>>();

        private LCAIndex() {
        }

        Resource getLCA(Resource u, Resource v) {
            Resource lca;
            Map<Resource, Resource> map = this.lcaIndex.get(u);
            Resource resource = lca = map == null ? null : map.get(v);
            if (lca == null) {
                map = this.lcaIndex.get(v);
                lca = map == null ? null : map.get(u);
            }
            return lca;
        }

        void setLCA(Resource u, Resource v, Resource lca) {
            Map uMap = this.lcaIndex.computeIfAbsent(u, k -> new HashMap());
            uMap.put(v, lca);
        }

        DisjointSet getSet(Resource r) {
            return this.setIndex.computeIfAbsent(r, DisjointSet::new);
        }
    }

    private static class DisjointSet {
        private final Resource node;
        private DisjointSet parent;
        private int rank;
        private DisjointSet ancestor;
        private boolean black = false;
        private boolean used = false;

        DisjointSet(Resource node) {
            this.node = node;
            this.rank = 0;
            this.parent = this;
        }

        DisjointSet find() {
            DisjointSet root;
            if (this.parent == this) {
                root = this;
            } else {
                this.parent = root = this.parent.find();
            }
            return root;
        }

        void union(DisjointSet y) {
            DisjointSet xRoot = this.find();
            DisjointSet yRoot = y.find();
            if (xRoot.rank > yRoot.rank) {
                yRoot.parent = xRoot;
            } else if (yRoot.rank > xRoot.rank) {
                xRoot.parent = yRoot;
            } else if (xRoot != yRoot) {
                yRoot.parent = xRoot;
                ++xRoot.rank;
            }
        }
    }
}

