/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.clauses.PrologClause;
import org.apache.jena.arq.querybuilder.clauses.ValuesClause;
import org.apache.jena.arq.querybuilder.handlers.HandlerBlock;
import org.apache.jena.arq.querybuilder.handlers.PrologHandler;
import org.apache.jena.arq.querybuilder.handlers.ValuesHandler;
import org.apache.jena.arq.querybuilder.handlers.WhereHandler;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathParser;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;

public abstract class AbstractQueryBuilder<T extends AbstractQueryBuilder<T>>
implements Cloneable,
PrologClause<T>,
ValuesClause<T> {
    protected Query query = new Query();
    private final Map<Var, Node> values = new HashMap<Var, Node>();

    public Node makeNode(Object o) {
        return AbstractQueryBuilder.makeNode(o, this.query.getPrefixMapping());
    }

    private Object makeNodeOrPath(Object o) {
        return AbstractQueryBuilder.makeNodeOrPath(o, this.query.getPrefixMapping());
    }

    public static Object makeNodeOrPath(Object o, PrefixMapping pMapping) {
        if (o == null) {
            return Node.ANY;
        }
        if (o instanceof Path) {
            return o;
        }
        if (o instanceof FrontsNode) {
            return ((FrontsNode)o).asNode();
        }
        if (o instanceof Node) {
            return o;
        }
        if (o instanceof String) {
            try {
                Path p = PathParser.parse((String)((String)o), (PrefixMapping)pMapping);
                if (p instanceof P_Link) {
                    return ((P_Link)p).getNode();
                }
                return p;
            }
            catch (QueryParseException e) {
                return AbstractQueryBuilder.makeNode(o, pMapping);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NodeFactory.createLiteral((LiteralLabel)LiteralLabelFactory.createTypedLiteral((Object)o));
    }

    public ElementSubQuery asSubQuery() {
        return this.getWhereHandler().makeSubQuery(this);
    }

    public TriplePath makeTriplePath(Object s, Object p, Object o) {
        Object po = this.makeNodeOrPath(p);
        if (po instanceof Path) {
            return new TriplePath(this.makeNode(s), (Path)po, this.makeNode(o));
        }
        return new TriplePath(new Triple(this.makeNode(s), (Node)po, this.makeNode(o)));
    }

    public Expr makeExpr(String expression) throws QueryParseException {
        return ExprUtils.parse((Query)this.query, (String)expression, (boolean)true);
    }

    public static String quote(String q) {
        int qt = q.indexOf(34);
        int sqt = q.indexOf("'");
        if (sqt == -1 || qt < sqt) {
            return String.format("'%s'", q);
        }
        return String.format("\"%s\"", q);
    }

    public static Node checkVar(Node n) {
        if (n.isVariable()) {
            return Var.alloc((Node)n);
        }
        return n;
    }

    public static Node makeNode(Object o, PrefixMapping pMapping) {
        if (o == null) {
            return Node.ANY;
        }
        if (o instanceof FrontsNode) {
            return AbstractQueryBuilder.checkVar(((FrontsNode)o).asNode());
        }
        if (o instanceof Node) {
            return AbstractQueryBuilder.checkVar((Node)o);
        }
        if (o instanceof String) {
            try {
                return AbstractQueryBuilder.checkVar(NodeFactoryExtra.parseNode((String)((String)o), (PrefixMap)PrefixMapFactory.createForInput((PrefixMapping)pMapping)));
            }
            catch (RiotException riotException) {
                // empty catch block
            }
        }
        return NodeFactory.createLiteral((LiteralLabel)LiteralLabelFactory.createTypedLiteral((Object)o));
    }

    public static Var makeVar(Object o) throws ARQInternalErrorException {
        if (o == null) {
            return Var.ANON;
        }
        if (o instanceof Var) {
            return (Var)o;
        }
        Var retval = null;
        retval = o instanceof FrontsNode ? Var.alloc((Node)((FrontsNode)o).asNode()) : (o instanceof Node ? Var.alloc((Node)((Node)o)) : (o instanceof ExprVar ? Var.alloc((ExprVar)((ExprVar)o)) : Var.alloc((String)Var.canonical((String)o.toString()))));
        if ("*".equals(Var.canonical((String)retval.toString()))) {
            return null;
        }
        return retval;
    }

    protected AbstractQueryBuilder() {
    }

    public abstract HandlerBlock getHandlerBlock();

    @Override
    public final PrologHandler getPrologHandler() {
        return this.getHandlerBlock().getPrologHandler();
    }

    @Override
    public ValuesHandler getValuesHandler() {
        return this.getHandlerBlock().getValueHandler();
    }

    public final WhereHandler getWhereHandler() {
        return this.getHandlerBlock().getWhereHandler();
    }

    @Override
    public final ExprFactory getExprFactory() {
        return this.getHandlerBlock().getPrologHandler().getExprFactory();
    }

    public void setVar(Var var, Node value) {
        if (value == null) {
            this.values.remove(var);
        } else {
            this.values.put(var, value);
        }
    }

    public void setVar(Object var, Object value) {
        if (value == null) {
            this.setVar(AbstractQueryBuilder.makeVar(var), null);
        } else {
            this.setVar(AbstractQueryBuilder.makeVar(var), this.makeNode(value));
        }
    }

    @Override
    public T addPrefix(String pfx, Resource uri) {
        return this.addPrefix(pfx, uri.getURI());
    }

    @Override
    public T addPrefix(String pfx, Node uri) {
        return this.addPrefix(pfx, uri.getURI());
    }

    @Override
    public T addPrefix(String pfx, String uri) {
        this.getPrologHandler().addPrefix(pfx, uri);
        return (T)this;
    }

    @Override
    public T addPrefixes(Map<String, String> prefixes) {
        this.getPrologHandler().addPrefixes(prefixes);
        return (T)this;
    }

    @Override
    public T setBase(String base) {
        this.getPrologHandler().setBase(base);
        return (T)this;
    }

    @Override
    public T setBase(Object base) {
        this.setBase(this.makeNode(base).getURI());
        return (T)this;
    }

    public static Collection<Node> makeValueNodes(Iterator<?> iter, PrefixMapping prefixMapping) {
        if (iter == null || !iter.hasNext()) {
            return null;
        }
        ArrayList<Node> values = new ArrayList<Node>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o == null) {
                values.add(null);
                continue;
            }
            values.add(AbstractQueryBuilder.makeNode(o, prefixMapping));
        }
        return values;
    }

    public Collection<Node> makeValueNodes(Iterator<?> iter) {
        return AbstractQueryBuilder.makeValueNodes(iter, this.getPrologHandler().getPrefixes());
    }

    @Override
    public T addValueVar(Object var) {
        if (var == null) {
            throw new IllegalArgumentException("var must not be null.");
        }
        if (var instanceof Collection) {
            Collection column = (Collection)var;
            if (column.size() == 0) {
                throw new IllegalArgumentException("column must have at least one entry.");
            }
            Iterator iter = column.iterator();
            Var v = AbstractQueryBuilder.makeVar(iter.next());
            this.getValuesHandler().addValueVar(v, this.makeValueNodes(iter));
        } else {
            this.getValuesHandler().addValueVar(AbstractQueryBuilder.makeVar(var), null);
        }
        return (T)this;
    }

    @Override
    public T addValueVar(Object var, Object ... objects) {
        Collection<Node> values = null;
        if (objects != null) {
            values = this.makeValueNodes(Arrays.asList(objects).iterator());
        }
        this.getValuesHandler().addValueVar(AbstractQueryBuilder.makeVar(var), values);
        return (T)this;
    }

    @Override
    public <K extends Collection<?>> T addValueVars(Map<?, K> dataTable) {
        ValuesHandler hdlr = new ValuesHandler(null);
        for (Map.Entry<?, K> entry : dataTable.entrySet()) {
            Collection<Node> values = null;
            if (entry.getValue() != null) {
                values = this.makeValueNodes(((Collection)entry.getValue()).iterator());
            }
            hdlr.addValueVar(AbstractQueryBuilder.makeVar(entry.getKey()), values);
        }
        this.getValuesHandler().addAll(hdlr);
        return (T)this;
    }

    @Override
    public T addValueRow(Object ... values) {
        this.getValuesHandler().addValueRow(this.makeValueNodes(Arrays.asList(values).iterator()));
        return (T)this;
    }

    @Override
    public T addValueRow(Collection<?> values) {
        this.getValuesHandler().addValueRow(this.makeValueNodes(values.iterator()));
        return (T)this;
    }

    @Override
    public List<Var> getValuesVars() {
        return this.getValuesHandler().getValuesVars();
    }

    @Override
    public Map<Var, List<Node>> getValuesMap() {
        return this.getValuesHandler().getValuesMap();
    }

    @Override
    public T clearValues() {
        this.getValuesHandler().clear();
        return (T)this;
    }

    public String toString() {
        return this.buildString();
    }

    public final String buildString() {
        return this.build().toString();
    }

    public final Query build() {
        Query q = new Query();
        switch (this.query.getQueryType()) {
            case 444: {
                q.setQueryAskType();
                break;
            }
            case 222: {
                q.setQueryConstructType();
                break;
            }
            case 333: {
                q.setQueryDescribeType();
                break;
            }
            case 111: {
                q.setQuerySelectType();
                break;
            }
            case -123: {
                break;
            }
            default: {
                throw new IllegalStateException("Internal query is not a known type: " + q.getQueryType());
            }
        }
        HandlerBlock handlerBlock = new HandlerBlock(q);
        handlerBlock.addAll(this.getHandlerBlock());
        handlerBlock.setVars(this.values);
        if (q.getQueryPattern() == null) {
            q.setQueryPattern((Element)new ElementGroup());
        }
        handlerBlock.build();
        return q;
    }

    public static Query clone(Query q2) {
        Query retval = new Query();
        if (q2.isSelectType()) {
            retval.setQuerySelectType();
        } else if (q2.isAskType()) {
            retval.setQueryAskType();
        } else if (q2.isDescribeType()) {
            retval.setQueryDescribeType();
        } else if (q2.isConstructType()) {
            retval.setQueryConstructType();
        }
        HandlerBlock hb = new HandlerBlock(retval);
        HandlerBlock hb2 = new HandlerBlock(q2);
        hb.addAll(hb2);
        return retval;
    }

    public static Query rewrite(Query q2, Map<Var, Node> values) {
        HandlerBlock hb = new HandlerBlock(q2);
        hb.setVars(values);
        return q2;
    }
}

