/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.Order;
import org.apache.jena.arq.querybuilder.clauses.DatasetClause;
import org.apache.jena.arq.querybuilder.clauses.SolutionModifierClause;
import org.apache.jena.arq.querybuilder.clauses.WhereClause;
import org.apache.jena.arq.querybuilder.handlers.DatasetHandler;
import org.apache.jena.arq.querybuilder.handlers.HandlerBlock;
import org.apache.jena.arq.querybuilder.handlers.SolutionModifierHandler;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.lang.sparql_11.ParseException;

public class AskBuilder
extends AbstractQueryBuilder<AskBuilder>
implements DatasetClause<AskBuilder>,
WhereClause<AskBuilder>,
SolutionModifierClause<AskBuilder> {
    private final HandlerBlock handlerBlock;

    public AskBuilder() {
        this.query.setQueryAskType();
        this.handlerBlock = new HandlerBlock(this.query);
    }

    @Override
    public HandlerBlock getHandlerBlock() {
        return this.handlerBlock;
    }

    @Override
    public DatasetHandler getDatasetHandler() {
        return this.handlerBlock.getDatasetHandler();
    }

    public AskBuilder clone() {
        AskBuilder qb = new AskBuilder();
        qb.handlerBlock.addAll(this.handlerBlock);
        return qb;
    }

    @Override
    public AskBuilder fromNamed(String graphName) {
        this.getDatasetHandler().fromNamed(graphName);
        return this;
    }

    @Override
    public AskBuilder fromNamed(Collection<String> graphNames) {
        this.getDatasetHandler().fromNamed(graphNames);
        return this;
    }

    @Override
    public AskBuilder from(String graphName) {
        this.getDatasetHandler().from(graphName);
        return this;
    }

    @Override
    public AskBuilder from(Collection<String> graphName) {
        this.getDatasetHandler().from(graphName);
        return this;
    }

    @Override
    public AskBuilder addWhere(TriplePath t) {
        this.getWhereHandler().addWhere(t);
        return this;
    }

    @Override
    public AskBuilder addWhere(Triple t) {
        this.getWhereHandler().addWhere(new TriplePath(t));
        return this;
    }

    @Override
    public AskBuilder addWhere(FrontsTriple t) {
        this.getWhereHandler().addWhere(new TriplePath(t.asTriple()));
        return this;
    }

    @Override
    public AskBuilder addWhere(Object s, Object p, Object o) {
        this.getWhereHandler().addWhere(this.makeTriplePath(s, p, o));
        return this;
    }

    @Override
    public AskBuilder addWhereValueVar(Object var) {
        this.getWhereHandler().addValueVar(this.getPrologHandler().getPrefixes(), var);
        return this;
    }

    @Override
    public AskBuilder addWhereValueVar(Object var, Object ... values) {
        this.getWhereHandler().addValueVar(this.getPrologHandler().getPrefixes(), var, values);
        return this;
    }

    @Override
    public <K extends Collection<?>> AskBuilder addWhereValueVars(Map<?, K> dataTable) {
        this.getWhereHandler().addValueVars(this.getPrologHandler().getPrefixes(), dataTable);
        return this;
    }

    @Override
    public AskBuilder addWhereValueRow(Object ... values) {
        this.getWhereHandler().addValueRow(this.getPrologHandler().getPrefixes(), values);
        return this;
    }

    @Override
    public AskBuilder addWhereValueRow(Collection<?> values) {
        this.getWhereHandler().addValueRow(this.getPrologHandler().getPrefixes(), values);
        return this;
    }

    @Override
    public List<Var> getWhereValuesVars() {
        return this.getWhereHandler().getValuesVars();
    }

    @Override
    public Map<Var, List<Node>> getWhereValuesMap() {
        return this.getWhereHandler().getValuesMap();
    }

    @Override
    public AskBuilder clearWhereValues() {
        this.getWhereHandler().clearValues();
        return this;
    }

    @Override
    public AskBuilder addOptional(TriplePath t) {
        this.getWhereHandler().addOptional(t);
        return this;
    }

    @Override
    public AskBuilder addOptional(Triple t) {
        this.getWhereHandler().addOptional(new TriplePath(t));
        return this;
    }

    @Override
    public AskBuilder addOptional(AbstractQueryBuilder<?> t) {
        this.getWhereHandler().addOptional(t.getWhereHandler());
        return this;
    }

    @Override
    public AskBuilder addOptional(FrontsTriple t) {
        this.getWhereHandler().addOptional(new TriplePath(t.asTriple()));
        return this;
    }

    @Override
    public AskBuilder addOptional(Object s, Object p, Object o) {
        this.getWhereHandler().addOptional(this.makeTriplePath(s, p, o));
        return this;
    }

    @Override
    public AskBuilder addFilter(Expr expr) {
        this.getWhereHandler().addFilter(expr);
        return this;
    }

    @Override
    public AskBuilder addFilter(String s) throws ParseException {
        this.getWhereHandler().addFilter(s);
        return this;
    }

    @Override
    public AskBuilder addSubQuery(AbstractQueryBuilder<?> subQuery) {
        this.getWhereHandler().addSubQuery(subQuery);
        return this;
    }

    @Override
    public AskBuilder addUnion(AbstractQueryBuilder<?> subQuery) {
        this.getWhereHandler().addUnion(subQuery);
        return this;
    }

    @Override
    public AskBuilder addGraph(Object graph, AbstractQueryBuilder<?> subQuery) {
        this.getPrologHandler().addAll(subQuery.getPrologHandler());
        this.getWhereHandler().addGraph(this.makeNode(graph), subQuery.getWhereHandler());
        return this;
    }

    @Override
    public AskBuilder addGraph(Object graph, FrontsTriple triple) {
        this.getWhereHandler().addGraph(this.makeNode(graph), new TriplePath(triple.asTriple()));
        return this;
    }

    @Override
    public AskBuilder addGraph(Object graph, Object subject, Object predicate, Object object) {
        this.getWhereHandler().addGraph(this.makeNode(graph), this.makeTriplePath(subject, predicate, object));
        return this;
    }

    @Override
    public AskBuilder addGraph(Object graph, Triple triple) {
        this.getWhereHandler().addGraph(this.makeNode(graph), new TriplePath(triple));
        return this;
    }

    @Override
    public AskBuilder addGraph(Object graph, TriplePath triplePath) {
        this.getWhereHandler().addGraph(this.makeNode(graph), triplePath);
        return this;
    }

    @Override
    public AskBuilder addBind(Expr expression, Object var) {
        this.getWhereHandler().addBind(expression, AskBuilder.makeVar(var));
        return this;
    }

    @Override
    public AskBuilder addBind(String expression, Object var) throws ParseException {
        this.getWhereHandler().addBind(expression, AskBuilder.makeVar(var));
        return this;
    }

    @Override
    public AskBuilder addOrderBy(Expr orderBy) {
        this.getSolutionModifierHandler().addOrderBy(orderBy);
        return this;
    }

    @Override
    public AskBuilder addOrderBy(Object orderBy) {
        this.getSolutionModifierHandler().addOrderBy(AskBuilder.makeVar(orderBy));
        return this;
    }

    @Override
    public AskBuilder addOrderBy(SortCondition orderBy) {
        this.getSolutionModifierHandler().addOrderBy(orderBy);
        return this;
    }

    @Override
    public AskBuilder addOrderBy(Expr orderBy, Order order) {
        this.getSolutionModifierHandler().addOrderBy(orderBy, order);
        return this;
    }

    @Override
    public AskBuilder addOrderBy(Object orderBy, Order order) {
        this.getSolutionModifierHandler().addOrderBy(AskBuilder.makeVar(orderBy), order);
        return this;
    }

    @Override
    public AskBuilder addGroupBy(Object groupBy) {
        this.getSolutionModifierHandler().addGroupBy(AskBuilder.makeVar(groupBy));
        return this;
    }

    @Override
    public AskBuilder addGroupBy(Expr groupBy) {
        this.getSolutionModifierHandler().addGroupBy(groupBy);
        return this;
    }

    @Override
    public AskBuilder addGroupBy(Object var, Expr expr) {
        this.getSolutionModifierHandler().addGroupBy(AskBuilder.makeVar(var), expr);
        return this;
    }

    @Override
    public AskBuilder addGroupBy(Object var, String expr) {
        this.getSolutionModifierHandler().addGroupBy(AskBuilder.makeVar(var), this.makeExpr(expr));
        return this;
    }

    @Override
    public AskBuilder addHaving(String having) throws ParseException {
        this.getSolutionModifierHandler().addHaving(having);
        return this;
    }

    @Override
    public AskBuilder addHaving(Expr expression) throws ParseException {
        this.getSolutionModifierHandler().addHaving(expression);
        return this;
    }

    @Override
    public AskBuilder addHaving(Object var) throws ParseException {
        this.getSolutionModifierHandler().addHaving(AskBuilder.makeVar(var));
        return this;
    }

    @Override
    public AskBuilder setLimit(int limit) {
        this.getSolutionModifierHandler().setLimit(limit);
        return this;
    }

    @Override
    public AskBuilder setOffset(int offset) {
        this.getSolutionModifierHandler().setOffset(offset);
        return this;
    }

    @Override
    public SolutionModifierHandler getSolutionModifierHandler() {
        return this.handlerBlock.getModifierHandler();
    }

    @Override
    public Node list(Object ... objs) {
        return this.getWhereHandler().list(objs);
    }

    @Override
    public AskBuilder addMinus(AbstractQueryBuilder<?> t) {
        this.getWhereHandler().addMinus(t);
        return this;
    }
}

