/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.clauses.WhereClause;
import org.apache.jena.arq.querybuilder.handlers.HandlerBlock;
import org.apache.jena.arq.querybuilder.handlers.WhereHandler;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.lang.sparql_11.ParseException;

public class WhereBuilder
extends AbstractQueryBuilder<WhereBuilder>
implements WhereClause<WhereBuilder> {
    private HandlerBlock block;
    private WhereHandler handler;

    public WhereBuilder() {
        this.query = new Query();
        this.block = new HandlerBlock(this.query);
        this.handler = this.block.getWhereHandler();
    }

    @Override
    public WhereBuilder addWhere(Triple t) {
        return this.addWhere(new TriplePath(t));
    }

    @Override
    public WhereBuilder addWhere(TriplePath t) {
        this.handler.addWhere(t);
        return this;
    }

    @Override
    public WhereBuilder addWhere(FrontsTriple t) {
        return this.addWhere(t.asTriple());
    }

    @Override
    public WhereBuilder addWhere(Object s, Object p, Object o) {
        return this.addWhere(this.makeTriplePath(s, p, o));
    }

    @Override
    public WhereBuilder addWhereValueVar(Object var) {
        this.handler.addValueVar(this.getPrologHandler().getPrefixes(), var);
        return this;
    }

    @Override
    public WhereBuilder addWhereValueVar(Object var, Object ... values) {
        this.getWhereHandler().addValueVar(this.getPrologHandler().getPrefixes(), var, values);
        return this;
    }

    @Override
    public <K extends Collection<?>> WhereBuilder addWhereValueVars(Map<?, K> dataTable) {
        this.getWhereHandler().addValueVars(this.getPrologHandler().getPrefixes(), dataTable);
        return this;
    }

    @Override
    public WhereBuilder addWhereValueRow(Object ... values) {
        this.getWhereHandler().addValueRow(this.getPrologHandler().getPrefixes(), values);
        return this;
    }

    @Override
    public WhereBuilder addWhereValueRow(Collection<?> values) {
        this.getWhereHandler().addValueRow(this.getPrologHandler().getPrefixes(), values);
        return this;
    }

    @Override
    public List<Var> getWhereValuesVars() {
        return this.getWhereHandler().getValuesVars();
    }

    @Override
    public Map<Var, List<Node>> getWhereValuesMap() {
        return this.getWhereHandler().getValuesMap();
    }

    @Override
    public WhereBuilder clearWhereValues() {
        this.getWhereHandler().clearValues();
        return this;
    }

    @Override
    public WhereBuilder addOptional(TriplePath t) {
        this.getWhereHandler().addOptional(t);
        return this;
    }

    @Override
    public WhereBuilder addOptional(Triple t) {
        this.getWhereHandler().addOptional(new TriplePath(t));
        return this;
    }

    @Override
    public WhereBuilder addOptional(FrontsTriple t) {
        this.getWhereHandler().addOptional(new TriplePath(t.asTriple()));
        return this;
    }

    @Override
    public WhereBuilder addOptional(Object s, Object p, Object o) {
        this.getWhereHandler().addOptional(this.makeTriplePath(s, p, o));
        return this;
    }

    @Override
    public WhereBuilder addOptional(AbstractQueryBuilder<?> t) {
        this.getWhereHandler().addOptional(t.getWhereHandler());
        return this;
    }

    @Override
    public WhereBuilder addFilter(Expr expr) {
        this.getWhereHandler().addFilter(expr);
        return this;
    }

    @Override
    public WhereBuilder addFilter(String s) throws ParseException {
        this.getWhereHandler().addFilter(s);
        return this;
    }

    @Override
    public WhereBuilder addSubQuery(AbstractQueryBuilder<?> subQuery) {
        this.getWhereHandler().addSubQuery(subQuery);
        return this;
    }

    @Override
    public WhereBuilder addUnion(AbstractQueryBuilder<?> subQuery) {
        this.getWhereHandler().addUnion(subQuery);
        return this;
    }

    @Override
    public WhereBuilder addGraph(Object graph, AbstractQueryBuilder<?> subQuery) {
        this.getPrologHandler().addAll(subQuery.getPrologHandler());
        this.getWhereHandler().addGraph(this.makeNode(graph), subQuery.getWhereHandler());
        return this;
    }

    @Override
    public WhereBuilder addGraph(Object graph, FrontsTriple triple) {
        this.getWhereHandler().addGraph(this.makeNode(graph), new TriplePath(triple.asTriple()));
        return this;
    }

    @Override
    public WhereBuilder addGraph(Object graph, Object subject, Object predicate, Object object) {
        this.getWhereHandler().addGraph(this.makeNode(graph), this.makeTriplePath(subject, predicate, object));
        return this;
    }

    @Override
    public WhereBuilder addGraph(Object graph, Triple triple) {
        this.getWhereHandler().addGraph(this.makeNode(graph), new TriplePath(triple));
        return this;
    }

    @Override
    public WhereBuilder addGraph(Object graph, TriplePath triplePath) {
        this.getWhereHandler().addGraph(this.makeNode(graph), triplePath);
        return this;
    }

    @Override
    public WhereBuilder addBind(Expr expression, Object var) {
        this.getWhereHandler().addBind(expression, WhereBuilder.makeVar(var));
        return this;
    }

    @Override
    public WhereBuilder addBind(String expression, Object var) throws ParseException {
        this.getWhereHandler().addBind(expression, WhereBuilder.makeVar(var));
        return this;
    }

    @Override
    public Node list(Object ... objs) {
        return this.getWhereHandler().list(objs);
    }

    @Override
    public WhereBuilder addMinus(AbstractQueryBuilder<?> t) {
        this.getWhereHandler().addMinus(t);
        return this;
    }

    @Override
    public HandlerBlock getHandlerBlock() {
        return this.block;
    }

    @Override
    public String toString() {
        return this.query.toString();
    }
}

