/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.updatebuilder;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jena.arq.querybuilder.updatebuilder.QuadHolder;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class CollectionQuadHolder
implements QuadHolder {
    private final Set<Triple> collection;
    private final Node defaultGraphName;
    private Map<Var, Node> values;

    public CollectionQuadHolder(Node graph, Collection<Triple> triples) {
        this.collection = new HashSet<Triple>();
        this.collection.addAll(triples);
        this.defaultGraphName = graph;
    }

    public CollectionQuadHolder(Node graph, Iterator<Triple> triples) {
        this.collection = WrappedIterator.create(triples).toSet();
        this.defaultGraphName = graph;
    }

    public CollectionQuadHolder(Collection<Triple> triples) {
        this(Quad.defaultGraphNodeGenerated, triples);
    }

    public CollectionQuadHolder(Iterator<Triple> triples) {
        this.collection = WrappedIterator.create(triples).toSet();
        this.defaultGraphName = Quad.defaultGraphNodeGenerated;
    }

    private Node valueMap(Node n) {
        if (n.isVariable()) {
            Var v = Var.alloc((Node)n);
            Node n2 = this.values.get(n);
            return n2 == null ? n : n2;
        }
        return n;
    }

    @Override
    public ExtendedIterator<Quad> getQuads() {
        if (this.values == null) {
            this.values = Collections.emptyMap();
        }
        return WrappedIterator.create(this.collection.iterator()).mapWith(triple -> new Triple(this.valueMap(triple.getSubject()), this.valueMap(triple.getPredicate()), this.valueMap(triple.getObject()))).mapWith(triple -> new Quad(this.defaultGraphName, triple));
    }

    @Override
    public QuadHolder setValues(Map<Var, Node> values) {
        this.values = values;
        return this;
    }
}

