/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.updatebuilder;

import java.util.Map;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.updatebuilder.QuadHolder;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.SingletonIterator;

public class SingleQuadHolder
implements QuadHolder {
    private Quad quad;
    private Quad updated;

    public SingleQuadHolder(Quad quad) {
        this.quad = quad.getGraph().isVariable() || quad.getSubject().isVariable() || quad.getPredicate().isVariable() || quad.getObject().isVariable() ? new Quad(AbstractQueryBuilder.checkVar(quad.getGraph()), AbstractQueryBuilder.checkVar(quad.getSubject()), AbstractQueryBuilder.checkVar(quad.getPredicate()), AbstractQueryBuilder.checkVar(quad.getObject())) : quad;
    }

    public SingleQuadHolder(Triple triple) {
        this.quad = new Quad(Quad.defaultGraphNodeGenerated, AbstractQueryBuilder.checkVar(triple.getSubject()), AbstractQueryBuilder.checkVar(triple.getPredicate()), AbstractQueryBuilder.checkVar(triple.getObject()));
    }

    public SingleQuadHolder(Node graph, Triple triple) {
        this.quad = new Quad(graph, triple);
    }

    @Override
    public ExtendedIterator<Quad> getQuads() {
        return new SingletonIterator((Object)(this.updated == null ? this.quad : this.updated));
    }

    private Node mapValue(Node n, Map<Var, Node> values) {
        Node retval = null;
        if (n.isVariable()) {
            Var v = Var.alloc((Node)n);
            retval = values.get(v);
        }
        return retval == null ? n : retval;
    }

    @Override
    public QuadHolder setValues(Map<Var, Node> values) {
        this.updated = new Quad(this.mapValue(this.quad.getGraph(), values), this.mapValue(this.quad.getSubject(), values), this.mapValue(this.quad.getPredicate(), values), this.mapValue(this.quad.getObject(), values));
        return this;
    }
}

