/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.util.Collection;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.Order;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.arq.querybuilder.clauses.ConstructClause;
import org.apache.jena.arq.querybuilder.clauses.DatasetClause;
import org.apache.jena.arq.querybuilder.clauses.SolutionModifierClause;
import org.apache.jena.arq.querybuilder.clauses.WhereClause;
import org.apache.jena.arq.querybuilder.handlers.ConstructHandler;
import org.apache.jena.arq.querybuilder.handlers.DatasetHandler;
import org.apache.jena.arq.querybuilder.handlers.HandlerBlock;
import org.apache.jena.arq.querybuilder.handlers.SolutionModifierHandler;
import org.apache.jena.arq.querybuilder.handlers.WhereHandler;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.lang.sparql_11.ParseException;

public class ConstructBuilder
extends AbstractQueryBuilder<ConstructBuilder>
implements DatasetClause<ConstructBuilder>,
WhereClause<ConstructBuilder>,
SolutionModifierClause<ConstructBuilder>,
ConstructClause<ConstructBuilder> {
    private final HandlerBlock handlerBlock;

    public ConstructBuilder() {
        this.query.setQueryConstructType();
        this.handlerBlock = new HandlerBlock(this.query);
    }

    @Override
    public DatasetHandler getDatasetHandler() {
        return this.handlerBlock.getDatasetHandler();
    }

    @Override
    public WhereHandler getWhereHandler() {
        return this.handlerBlock.getWhereHandler();
    }

    @Override
    public ConstructHandler getConstructHandler() {
        return this.handlerBlock.getConstructHandler();
    }

    @Override
    public SolutionModifierHandler getSolutionModifierHandler() {
        return this.handlerBlock.getModifierHandler();
    }

    @Override
    public HandlerBlock getHandlerBlock() {
        return this.handlerBlock;
    }

    public ConstructBuilder clone() {
        ConstructBuilder qb = new ConstructBuilder();
        qb.handlerBlock.addAll(this.handlerBlock);
        return qb;
    }

    @Override
    public ConstructBuilder fromNamed(String graphName) {
        this.getDatasetHandler().fromNamed(graphName);
        return this;
    }

    @Override
    public ConstructBuilder fromNamed(Collection<String> graphNames) {
        this.getDatasetHandler().fromNamed(graphNames);
        return this;
    }

    @Override
    public ConstructBuilder from(String graphName) {
        this.getDatasetHandler().from(graphName);
        return this;
    }

    @Override
    public ConstructBuilder from(Collection<String> graphName) {
        this.getDatasetHandler().from(graphName);
        return this;
    }

    @Override
    public ConstructBuilder addOrderBy(Expr orderBy) {
        this.getSolutionModifierHandler().addOrderBy(orderBy);
        return this;
    }

    @Override
    public ConstructBuilder addOrderBy(Object orderBy) {
        this.getSolutionModifierHandler().addOrderBy(this.makeVar(orderBy));
        return this;
    }

    @Override
    public ConstructBuilder addOrderBy(SortCondition orderBy) {
        this.getSolutionModifierHandler().addOrderBy(orderBy);
        return this;
    }

    @Override
    public ConstructBuilder addOrderBy(Expr orderBy, Order order) {
        this.getSolutionModifierHandler().addOrderBy(orderBy, order);
        return this;
    }

    @Override
    public ConstructBuilder addOrderBy(Object orderBy, Order order) {
        this.getSolutionModifierHandler().addOrderBy(this.makeVar(orderBy), order);
        return this;
    }

    @Override
    public ConstructBuilder addGroupBy(Object groupBy) {
        this.getSolutionModifierHandler().addGroupBy(this.makeVar(groupBy));
        return this;
    }

    @Override
    public ConstructBuilder addGroupBy(Expr groupBy) {
        this.getSolutionModifierHandler().addGroupBy(groupBy);
        return this;
    }

    @Override
    public ConstructBuilder addGroupBy(Object var, Expr expr) {
        this.getSolutionModifierHandler().addGroupBy(this.makeVar(var), expr);
        return this;
    }

    @Override
    public ConstructBuilder addGroupBy(Object var, String expr) {
        this.getSolutionModifierHandler().addGroupBy(this.makeVar(var), this.makeExpr(expr));
        return this;
    }

    @Override
    public ConstructBuilder addHaving(String having) throws ParseException {
        this.getSolutionModifierHandler().addHaving(having);
        return this;
    }

    @Override
    public ConstructBuilder addHaving(Expr expression) throws ParseException {
        this.getSolutionModifierHandler().addHaving(expression);
        return this;
    }

    @Override
    public ConstructBuilder addHaving(Object var) throws ParseException {
        this.getSolutionModifierHandler().addHaving(this.makeVar(var));
        return this;
    }

    @Override
    public ConstructBuilder setLimit(int limit) {
        this.getSolutionModifierHandler().setLimit(limit);
        return this;
    }

    @Override
    public ConstructBuilder setOffset(int offset) {
        this.getSolutionModifierHandler().setOffset(offset);
        return this;
    }

    @Override
    public ConstructBuilder addWhere(TriplePath t) {
        this.getWhereHandler().addWhere(t);
        return this;
    }

    @Override
    public ConstructBuilder addWhere(Triple t) {
        this.getWhereHandler().addWhere(new TriplePath(t));
        return this;
    }

    @Override
    public ConstructBuilder addWhere(FrontsTriple t) {
        this.getWhereHandler().addWhere(new TriplePath(t.asTriple()));
        return this;
    }

    @Override
    public ConstructBuilder addWhere(Object s, Object p, Object o) {
        this.getWhereHandler().addWhere(this.makeTriplePath(s, p, o));
        return this;
    }

    @Override
    public ConstructBuilder addOptional(TriplePath t) {
        this.getWhereHandler().addOptional(t);
        return this;
    }

    @Override
    public ConstructBuilder addOptional(Triple t) {
        this.getWhereHandler().addOptional(new TriplePath(t));
        return this;
    }

    @Override
    public ConstructBuilder addOptional(SelectBuilder t) {
        this.getWhereHandler().addOptional(t.getWhereHandler());
        return this;
    }

    @Override
    public ConstructBuilder addOptional(FrontsTriple t) {
        this.getWhereHandler().addOptional(new TriplePath(t.asTriple()));
        return this;
    }

    @Override
    public ConstructBuilder addOptional(Object s, Object p, Object o) {
        this.getWhereHandler().addOptional(this.makeTriplePath(s, p, o));
        return this;
    }

    @Override
    public ConstructBuilder addFilter(String s) throws ParseException {
        this.getWhereHandler().addFilter(s);
        return this;
    }

    @Override
    public ConstructBuilder addSubQuery(SelectBuilder subQuery) {
        this.getWhereHandler().addSubQuery(subQuery);
        return this;
    }

    @Override
    public ConstructBuilder addUnion(SelectBuilder subQuery) {
        this.getWhereHandler().addUnion(subQuery);
        return this;
    }

    @Override
    public ConstructBuilder addGraph(Object graph, SelectBuilder subQuery) {
        this.getPrologHandler().addAll(subQuery.getPrologHandler());
        this.getWhereHandler().addGraph(this.makeNode(graph), subQuery.getWhereHandler());
        return this;
    }

    @Override
    public ConstructBuilder addBind(Expr expression, Object var) {
        this.getWhereHandler().addBind(expression, this.makeVar(var));
        return this;
    }

    @Override
    public ConstructBuilder addBind(String expression, Object var) throws ParseException {
        this.getWhereHandler().addBind(expression, this.makeVar(var));
        return this;
    }

    @Override
    public ConstructBuilder addConstruct(Triple t) {
        this.getConstructHandler().addConstruct(t);
        return this;
    }

    @Override
    public ConstructBuilder addConstruct(FrontsTriple t) {
        return this.addConstruct(t.asTriple());
    }

    @Override
    public ConstructBuilder addConstruct(Object s, Object p, Object o) {
        return this.addConstruct(new Triple(this.makeNode(s), this.makeNode(p), this.makeNode(o)));
    }

    @Override
    public Node list(Object ... objs) {
        return this.getWhereHandler().list(objs);
    }
}

