/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.util.Collection;
import java.util.List;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.Order;
import org.apache.jena.arq.querybuilder.clauses.DatasetClause;
import org.apache.jena.arq.querybuilder.clauses.SelectClause;
import org.apache.jena.arq.querybuilder.clauses.SolutionModifierClause;
import org.apache.jena.arq.querybuilder.clauses.WhereClause;
import org.apache.jena.arq.querybuilder.handlers.DatasetHandler;
import org.apache.jena.arq.querybuilder.handlers.HandlerBlock;
import org.apache.jena.arq.querybuilder.handlers.SelectHandler;
import org.apache.jena.arq.querybuilder.handlers.SolutionModifierHandler;
import org.apache.jena.arq.querybuilder.handlers.WhereHandler;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.lang.sparql_11.ParseException;

public class SelectBuilder
extends AbstractQueryBuilder<SelectBuilder>
implements DatasetClause<SelectBuilder>,
WhereClause<SelectBuilder>,
SolutionModifierClause<SelectBuilder>,
SelectClause<SelectBuilder> {
    private final HandlerBlock handlerBlock;

    public SelectBuilder() {
        this.query.setQuerySelectType();
        this.handlerBlock = new HandlerBlock(this.query);
    }

    @Override
    public DatasetHandler getDatasetHandler() {
        return this.handlerBlock.getDatasetHandler();
    }

    @Override
    public HandlerBlock getHandlerBlock() {
        return this.handlerBlock;
    }

    @Override
    public WhereHandler getWhereHandler() {
        return this.handlerBlock.getWhereHandler();
    }

    public SelectBuilder clone() {
        SelectBuilder qb = new SelectBuilder();
        qb.handlerBlock.addAll(this.handlerBlock);
        return qb;
    }

    @Override
    public SelectBuilder setDistinct(boolean state) {
        this.getSelectHandler().setDistinct(state);
        return this;
    }

    @Override
    public SelectBuilder setReduced(boolean state) {
        this.getSelectHandler().setReduced(state);
        return this;
    }

    @Override
    public SelectBuilder addVar(Object var) {
        this.getSelectHandler().addVar(this.makeVar(var));
        return this;
    }

    @Override
    public SelectBuilder addVar(String expression, Object var) throws ParseException {
        this.getSelectHandler().addVar(expression, this.makeVar(var));
        return this;
    }

    @Override
    public SelectBuilder addVar(Expr expr, Object var) {
        this.getSelectHandler().addVar(expr, this.makeVar(var));
        return this;
    }

    @Override
    public List<Var> getVars() {
        return this.getSelectHandler().getVars();
    }

    @Override
    public SelectBuilder fromNamed(String graphName) {
        this.getDatasetHandler().fromNamed(graphName);
        return this;
    }

    @Override
    public SelectBuilder fromNamed(Collection<String> graphNames) {
        this.getDatasetHandler().fromNamed(graphNames);
        return this;
    }

    @Override
    public SelectBuilder from(String graphName) {
        this.getDatasetHandler().from(graphName);
        return this;
    }

    @Override
    public SelectBuilder from(Collection<String> graphName) {
        this.getDatasetHandler().from(graphName);
        return this;
    }

    @Override
    public SelectBuilder addOrderBy(Expr orderBy) {
        this.getSolutionModifierHandler().addOrderBy(orderBy);
        return this;
    }

    @Override
    public SelectBuilder addOrderBy(Object orderBy) {
        this.getSolutionModifierHandler().addOrderBy(this.makeVar(orderBy));
        return this;
    }

    @Override
    public SelectBuilder addOrderBy(SortCondition orderBy) {
        this.getSolutionModifierHandler().addOrderBy(orderBy);
        return this;
    }

    @Override
    public SelectBuilder addOrderBy(Expr orderBy, Order order) {
        this.getSolutionModifierHandler().addOrderBy(orderBy, order);
        return this;
    }

    @Override
    public SelectBuilder addOrderBy(Object orderBy, Order order) {
        this.getSolutionModifierHandler().addOrderBy(this.makeVar(orderBy), order);
        return this;
    }

    @Override
    public SelectBuilder addGroupBy(Object groupBy) {
        this.getSolutionModifierHandler().addGroupBy(this.makeVar(groupBy));
        return this;
    }

    @Override
    public SelectBuilder addGroupBy(Expr groupBy) {
        this.getSolutionModifierHandler().addGroupBy(groupBy);
        return this;
    }

    @Override
    public SelectBuilder addGroupBy(Object var, Expr expr) {
        this.getSolutionModifierHandler().addGroupBy(this.makeVar(var), expr);
        return this;
    }

    @Override
    public SelectBuilder addGroupBy(Object var, String expr) {
        this.getSolutionModifierHandler().addGroupBy(this.makeVar(var), this.makeExpr(expr));
        return this;
    }

    @Override
    public SolutionModifierHandler getSolutionModifierHandler() {
        return this.handlerBlock.getModifierHandler();
    }

    @Override
    public SelectBuilder addHaving(String having) throws ParseException {
        this.getSolutionModifierHandler().addHaving(having);
        return this;
    }

    @Override
    public SelectBuilder addHaving(Expr expression) throws ParseException {
        this.getSolutionModifierHandler().addHaving(expression);
        return this;
    }

    @Override
    public SelectBuilder addHaving(Object var) throws ParseException {
        this.getSolutionModifierHandler().addHaving(this.makeVar(var));
        return this;
    }

    @Override
    public SelectBuilder setLimit(int limit) {
        this.getSolutionModifierHandler().setLimit(limit);
        return this;
    }

    @Override
    public SelectBuilder setOffset(int offset) {
        this.getSolutionModifierHandler().setOffset(offset);
        return this;
    }

    private static String toString(Node node) {
        if (node.isBlank()) {
            return node.getBlankNodeLabel();
        }
        if (node.isLiteral()) {
            return node.toString();
        }
        if (node.isURI()) {
            return String.format("<%s>", node.getURI());
        }
        if (node.isVariable()) {
            return String.format("?%s", node.getName());
        }
        return node.toString();
    }

    public static String makeString(Object o) {
        if (o instanceof FrontsNode) {
            return SelectBuilder.toString(((FrontsNode)o).asNode());
        }
        if (o instanceof Node) {
            return SelectBuilder.toString((Node)o);
        }
        return o.toString();
    }

    @Override
    public SelectBuilder addWhere(TriplePath t) {
        this.getWhereHandler().addWhere(t);
        return this;
    }

    @Override
    public SelectBuilder addWhere(Triple t) {
        this.getWhereHandler().addWhere(new TriplePath(t));
        return this;
    }

    @Override
    public SelectBuilder addWhere(FrontsTriple t) {
        this.getWhereHandler().addWhere(new TriplePath(t.asTriple()));
        return this;
    }

    @Override
    public SelectBuilder addWhere(Object s, Object p, Object o) {
        this.getWhereHandler().addWhere(this.makeTriplePath(s, p, o));
        return this;
    }

    @Override
    public SelectBuilder addOptional(TriplePath t) {
        this.getWhereHandler().addOptional(t);
        return this;
    }

    @Override
    public SelectBuilder addOptional(Triple t) {
        this.getWhereHandler().addOptional(new TriplePath(t));
        return this;
    }

    @Override
    public SelectBuilder addOptional(FrontsTriple t) {
        this.getWhereHandler().addOptional(new TriplePath(t.asTriple()));
        return this;
    }

    @Override
    public SelectBuilder addOptional(Object s, Object p, Object o) {
        this.getWhereHandler().addOptional(this.makeTriplePath(s, p, o));
        return this;
    }

    @Override
    public SelectBuilder addOptional(SelectBuilder t) {
        this.getWhereHandler().addOptional(t.getWhereHandler());
        return this;
    }

    @Override
    public SelectBuilder addFilter(String s) throws ParseException {
        this.getWhereHandler().addFilter(s);
        return this;
    }

    @Override
    public SelectBuilder addSubQuery(SelectBuilder subQuery) {
        this.getWhereHandler().addSubQuery(subQuery);
        return this;
    }

    @Override
    public SelectBuilder addUnion(SelectBuilder subQuery) {
        this.getWhereHandler().addUnion(subQuery);
        return this;
    }

    @Override
    public SelectBuilder addGraph(Object graph, SelectBuilder subQuery) {
        this.getPrologHandler().addAll(subQuery.getPrologHandler());
        this.getWhereHandler().addGraph(this.makeNode(graph), subQuery.getWhereHandler());
        return this;
    }

    @Override
    public SelectBuilder addBind(Expr expression, Object var) {
        this.getWhereHandler().addBind(expression, this.makeVar(var));
        return this;
    }

    @Override
    public SelectBuilder addBind(String expression, Object var) throws ParseException {
        this.getWhereHandler().addBind(expression, this.makeVar(var));
        return this;
    }

    @Override
    public SelectHandler getSelectHandler() {
        return this.handlerBlock.getSelectHandler();
    }

    @Override
    public Node list(Object ... objs) {
        return this.getWhereHandler().list(objs);
    }
}

